/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core;

import de.latlon.ets.core.util.TestSuiteLogger;
import de.latlon.ets.core.util.URIUtils;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import org.opengeospatial.cite.wmts10.ets.core.TestRunArg;
import org.opengeospatial.cite.wmts10.ets.core.domain.SuiteAttribute;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.Reporter;
import org.w3c.dom.Document;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        this.processWmtsParameter(suite);
        Reporter.clear();
        StringBuilder str = new StringBuilder("Initial test run parameters:\n");
        str.append(suite.getXmlSuite().getAllParameters().toString());
        Reporter.log(str.toString());
        TestSuiteLogger.log(Level.CONFIG, str.toString());
    }

    @Override
    public void onFinish(ISuite suite) {
        Reporter.log("Success? " + !suite.getSuiteState().isFailed());
        String reportDir = suite.getOutputDirectory();
        String msg = String.format("Test run directory: %s", reportDir.substring(0, reportDir.lastIndexOf(File.separatorChar)));
        Reporter.log(msg);
    }

    void processWmtsParameter(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        String wmtsRef = params.get(TestRunArg.WMTS.toString());
        if (null == wmtsRef || wmtsRef.isEmpty()) {
            throw new IllegalArgumentException("Required parameter not found");
        }
        URI wmtsURI = URI.create(wmtsRef);
        Document doc = null;
        try {
            doc = URIUtils.resolveURIAsDocument(wmtsURI);
            if (!"Capabilities".equals(doc.getDocumentElement().getLocalName())) {
                throw new RuntimeException("Did not receive WMTS ServeiceMetadata capabilities document: " + doc.getDocumentElement().getNodeName());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse resource located at " + wmtsURI, ex);
        }
        if (null != doc) {
            suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), doc);
            suite.setAttribute(SuiteAttribute.LAYER_INFO.getName(), ServiceMetadataUtils.parseLayerInfo(doc));
        }
    }
}

