/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import de.latlon.ets.core.util.XMLUtils;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import javax.xml.transform.Source;
import org.apache.tika.io.FilenameUtils;
import org.opengeospatial.cite.wmts10.ets.core.client.WmtsKvpRequest;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.SOAPMessageConsumer;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.w3c.dom.Document;

public class WmtsClient {
    private static final Logger LOGR = Logger.getLogger(WmtsClient.class.getPackage().getName());
    private Client client;
    private Document wmtsCapabilities;

    public WmtsClient(Document wmtsCapabilities) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(SOAPMessageConsumer.class);
        this.client = Client.create(config);
        this.client.addFilter(new LoggingFilter());
        this.wmtsCapabilities = wmtsCapabilities;
    }

    public Document getCapabilities() {
        if (null == this.wmtsCapabilities) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        if (null == endpoint) {
            throw new RuntimeException("GetCapabilities (GET) endpoint not found in capabilities document.");
        }
        WebResource resource = this.client.resource(endpoint);
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add("Request", "GetCapabilities");
        queryParams.add("Service", "WMTS");
        queryParams.add("Version", "1.0.0");
        return resource.queryParams(queryParams).get(Document.class);
    }

    public ClientResponse submitRequest(WmtsKvpRequest request, URI endpoint) {
        WebResource resource = this.client.resource(endpoint);
        return this.submitGetRequest(resource, request);
    }

    private ClientResponse submitPostRequest(WebResource resource, Source payload) {
        LOGR.log(Level.FINE, String.format("Submitting POST request to URI %s", resource.getURI()));
        LOGR.log(Level.FINE, String.format("Request Payload: %s", XMLUtils.transformToString(payload)));
        ClientResponse response = null;
        try {
            response = ((WebResource.Builder)resource.accept("application/soap+xml").type("application/soap+xml")).post(ClientResponse.class, (Object)payload);
            if (LOGR.isLoggable(Level.FINE)) {
                LOGR.log(Level.FINE, String.format("SOAP Response: %s", FilenameUtils.normalize(response.toString())));
            }
        }
        catch (ClientHandlerException | UniformInterfaceException ex) {
            LOGR.log(Level.SEVERE, "Failed to process SOAP request/response: " + resource.getURI(), ex);
        }
        return response;
    }

    private ClientResponse submitGetRequest(WebResource resource, WmtsKvpRequest requestParameter) {
        LOGR.log(Level.FINE, String.format("Submitting GET request to URI %s", resource.getURI()));
        String queryString = requestParameter.asQueryString();
        URI requestURI = UriBuilder.fromUri(resource.getURI()).replaceQuery(queryString).build(new Object[0]);
        LOGR.log(Level.FINE, String.format("Request URI: %s", requestURI));
        resource = resource.uri(requestURI);
        return resource.get(ClientResponse.class);
    }
}

