/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.domain;

public class BoundingBox {
    private final String crs;
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public BoundingBox(String crs, double minX, double minY, double maxX, double maxY) {
        this.checkParameters(crs, minX, minY, maxX, maxY);
        this.crs = crs;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public String getCrs() {
        return this.crs;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public String getBboxAsString() {
        return this.minX + "," + this.minY + "," + this.maxX + "," + this.maxY;
    }

    private void checkParameters(String crs, double minX, double minY, double maxX, double maxY) {
        if (crs == null) {
            throw new IllegalArgumentException("CRS must not be null!");
        }
        if (minX >= maxX) {
            throw new IllegalArgumentException("minX must be less than maxX!");
        }
        if (minY >= maxY) {
            throw new IllegalArgumentException("minY must be less than maxY!");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        long temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (this.crs == null ? other.crs != null : !this.crs.equals(other.crs)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(other.maxX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(other.maxY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(other.minX)) {
            return false;
        }
        return Double.doubleToLongBits(this.minY) == Double.doubleToLongBits(other.minY);
    }

    public String toString() {
        return "BoundingBox [crs=" + this.crs + ", minX=" + this.minX + ", minY=" + this.minY + ", maxX=" + this.maxX + ", maxY=" + this.maxY + "]";
    }
}

