/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

@Consumes(value={"application/soap+xml"})
public class SOAPMessageConsumer
implements MessageBodyReader<SOAPMessage> {
    private static final Logger LOGR = Logger.getLogger(SOAPMessageConsumer.class.getPackage().getName());

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(SOAPMessage.class);
    }

    @Override
    public SOAPMessage readFrom(Class<SOAPMessage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        SOAPMessage message = null;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            message = messageFactory.createMessage();
            SOAPPart soapPart = message.getSOAPPart();
            StreamSource messageSource = new StreamSource(entityStream);
            soapPart.setContent((Source)messageSource);
        }
        catch (SOAPException se) {
            LOGR.warning("Unable to create SOAPMessage.\n" + se.getMessage());
        }
        return message;
    }
}

