/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.util.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.xml.xpath.XPathExpressionException;
import org.opengeospatial.cite.wmts10.ets.core.client.WmtsKvpRequest;
import org.opengeospatial.cite.wmts10.ets.core.domain.LayerInfo;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WmtsKvpRequestBuilder {
    private static final Random RANDOM = new Random();

    private WmtsKvpRequestBuilder() {
    }

    public static WmtsKvpRequest buildGetCapabilitiesRequest(Document wmtsCapabilities, List<LayerInfo> layerInfos) {
        WmtsKvpRequest reqEntity = new WmtsKvpRequest();
        reqEntity.addKvp("Service", "WMTS");
        reqEntity.addKvp("Request", "GetCapabilities");
        reqEntity.addKvp("Version", "1.0.0");
        return reqEntity;
    }

    public static WmtsKvpRequest buildGetTileRequest(Document wmtsCapabilities, List<LayerInfo> layerInfos) throws XPathExpressionException {
        WmtsKvpRequest reqEntity = new WmtsKvpRequest();
        reqEntity.addKvp("Service", "WMTS");
        reqEntity.addKvp("Version", "1.0.0");
        reqEntity.addKvp("Request", "GetTile");
        LayerInfo layerInfo = WmtsKvpRequestBuilder.getRandomLayerInfo(layerInfos);
        Assert.assertNotNull(layerInfo, "Could not find suitable layer for GetTile request.");
        String layerName = layerInfo.getLayerName();
        reqEntity.addKvp("Layer", layerName);
        String style = WmtsKvpRequestBuilder.getRandomLayerStyle(wmtsCapabilities, layerName);
        Assert.assertNotNull(style, "Could not find style for GetTile request for <Layer>: " + layerName);
        reqEntity.addKvp("Style", style);
        String format = WmtsKvpRequestBuilder.getRandomLayerFormat(wmtsCapabilities, layerInfo.getLayerName(), "Format");
        Assert.assertNotNull(format, "Could not find request format for GetTile request for <Layer>: " + layerName);
        reqEntity.addKvp("Format", format);
        String tileMatrixSetName = WmtsKvpRequestBuilder.getRandomLayerTileMatrixSetName(wmtsCapabilities, layerName);
        Assert.assertNotNull(tileMatrixSetName, "Could not find tilematrix set for GetTile request for <Layer>: " + layerName);
        reqEntity.addKvp("TileMatrixSet", tileMatrixSetName);
        String tileMatrixName = WmtsKvpRequestBuilder.getRandomTileMatrix(wmtsCapabilities, tileMatrixSetName);
        Assert.assertNotNull(tileMatrixName, "Could not find tilematrix for GetTile request for <TileMatrixSet>: " + tileMatrixSetName);
        reqEntity.addKvp("TileMatrix", tileMatrixName);
        int[] tiles = WmtsKvpRequestBuilder.getRandomLayerTiles(wmtsCapabilities, tileMatrixSetName, tileMatrixName);
        Assert.assertNotNull(tiles, "Could not find tiles for GetTile request for <TileMatrix> " + tileMatrixName + " under <TileMatrixSet>: " + tileMatrixSetName);
        reqEntity.addKvp("TileCol", Integer.toString(tiles[0]));
        reqEntity.addKvp("TileRow", Integer.toString(tiles[1]));
        return reqEntity;
    }

    public static WmtsKvpRequest buildGetFeatureInfoRequest(Document wmtsCapabilities, List<LayerInfo> layerInfos) throws XPathExpressionException {
        WmtsKvpRequest reqEntity = new WmtsKvpRequest();
        reqEntity.addKvp("Service", "WMTS");
        reqEntity.addKvp("Version", "1.0.0");
        reqEntity.addKvp("Request", "GetFeatureInfo");
        LayerInfo layerInfo = WmtsKvpRequestBuilder.getRandomLayerInfo(layerInfos);
        Assert.assertNotNull(layerInfo, "Could not find suitable layer for GetFeatureInfo request.");
        String layerName = layerInfo.getLayerName();
        reqEntity.addKvp("Layer", layerName);
        String style = WmtsKvpRequestBuilder.getRandomLayerStyle(wmtsCapabilities, layerName);
        Assert.assertNotNull(style, "Could not find style for GetFeatureInfo request for <Layer>: " + layerName);
        reqEntity.addKvp("Style", style);
        String format = WmtsKvpRequestBuilder.getRandomLayerFormat(wmtsCapabilities, layerInfo.getLayerName(), "Format");
        Assert.assertNotNull(format, "Could not find request format for GetFeatureInfo request for <Layer>: " + layerName);
        reqEntity.addKvp("Format", format);
        String tileMatrixSetName = WmtsKvpRequestBuilder.getRandomLayerTileMatrixSetName(wmtsCapabilities, layerName);
        Assert.assertNotNull(tileMatrixSetName, "Could not find tilematrix set for GetFeatureInfo request for <Layer>: " + layerName);
        reqEntity.addKvp("TileMatrixSet", tileMatrixSetName);
        String tileMatrixName = WmtsKvpRequestBuilder.getRandomTileMatrix(wmtsCapabilities, tileMatrixSetName);
        Assert.assertNotNull(tileMatrixName, "Could not find tilematrix for GetFeatureInfo request for <TileMatrixSet>: " + tileMatrixSetName);
        reqEntity.addKvp("TileMatrix", tileMatrixName);
        int[] tiles = WmtsKvpRequestBuilder.getRandomLayerTiles(wmtsCapabilities, tileMatrixSetName, tileMatrixName);
        Assert.assertNotNull(tiles, "Could not find tiles for GetFeatureInfo request for <TileMatrix> " + tileMatrixName + " under <TileMatrixSet>: " + tileMatrixSetName);
        reqEntity.addKvp("TileCol", Integer.toString(tiles[0]));
        reqEntity.addKvp("TileRow", Integer.toString(tiles[1]));
        int[] pixelNum = WmtsKvpRequestBuilder.getRandomLayerTilePixels(wmtsCapabilities, tileMatrixSetName, tileMatrixName);
        Assert.assertNotNull(tiles, "Could not find tile pixel counts for GetFeatureInfo request for <TileMatrix> " + tileMatrixName + " under <TileMatrixSet>: " + tileMatrixSetName);
        reqEntity.addKvp("I", Integer.toString(pixelNum[0]));
        reqEntity.addKvp("J", Integer.toString(pixelNum[1]));
        format = WmtsKvpRequestBuilder.getRandomLayerFormat(wmtsCapabilities, layerInfo.getLayerName(), "InfoFormat");
        Assert.assertNotNull(format, "Could not find request info-format for GetFeatureInfo request for <Layer>: " + layerName);
        reqEntity.addKvp("InfoFormat", format);
        return reqEntity;
    }

    private static LayerInfo getRandomLayerInfo(List<LayerInfo> layerInfos) {
        if (layerInfos.size() > 0) {
            ArrayList<LayerInfo> shuffledLayerInfos = new ArrayList<LayerInfo>(layerInfos);
            Collections.shuffle(shuffledLayerInfos);
            return (LayerInfo)shuffledLayerInfos.get(0);
        }
        return null;
    }

    private static String getRandomLayerFormat(Document wmtsCapabilities, String layerName, String formatParam) throws XPathExpressionException {
        NodeList formats = ServiceMetadataUtils.parseLayerChildElements(wmtsCapabilities, layerName, formatParam);
        if (formats.getLength() > 0) {
            int randomIndex = RANDOM.nextInt(formats.getLength());
            Node format = formats.item(randomIndex);
            return format.getTextContent().trim();
        }
        return null;
    }

    private static String getRandomLayerStyle(Document wmtsCapabilities, String layerName) throws XPathExpressionException {
        NodeList styles = ServiceMetadataUtils.parseLayerChildElements(wmtsCapabilities, layerName, "Style");
        if (styles.getLength() > 0) {
            int randomIndex = RANDOM.nextInt(styles.getLength());
            Node style = styles.item(randomIndex);
            return ServiceMetadataUtils.parseNodeElementName(style);
        }
        return null;
    }

    private static String getRandomLayerTileMatrixSetName(Document wmtsCapabilities, String layerName) throws XPathExpressionException {
        NodeList tileMatrixSetLinks = ServiceMetadataUtils.parseLayerChildElements(wmtsCapabilities, layerName, "TileMatrixSetLink");
        if (tileMatrixSetLinks.getLength() > 0) {
            int randomIndex = RANDOM.nextInt(tileMatrixSetLinks.getLength());
            Node tileMatrixSetLink = tileMatrixSetLinks.item(randomIndex);
            return ServiceMetadataUtils.getNodeText(tileMatrixSetLink, "wmts:TileMatrixSet");
        }
        return null;
    }

    private static String getRandomTileMatrix(Document wmtsCapabilities, String tileMatrixSetName) throws XPathExpressionException {
        NodeList tileMatrices = ServiceMetadataUtils.getNodeElements(wmtsCapabilities, "//wmts:Contents/wmts:TileMatrixSet[ows:Identifier = '" + tileMatrixSetName + "']/wmts:TileMatrix");
        if (tileMatrices.getLength() > 0) {
            int randomIndex = RANDOM.nextInt(tileMatrices.getLength());
            Node tileMatrixSet = tileMatrices.item(randomIndex);
            return ServiceMetadataUtils.parseNodeElementName(tileMatrixSet);
        }
        return null;
    }

    private static int[] getRandomLayerTiles(Document wmtsCapabilities, String tileMatrixSetName, String tileMatrixName) throws XPathExpressionException {
        NodeList tileMatrices = ServiceMetadataUtils.getNodeElements(wmtsCapabilities, "//wmts:Contents/wmts:TileMatrixSet[ows:Identifier = '" + tileMatrixSetName + "']/wmts:TileMatrix[ows:Identifier = '" + tileMatrixName + "']");
        if (tileMatrices.getLength() > 0) {
            Node tileMatrix = tileMatrices.item(0);
            NodeList widths = ServiceMetadataUtils.getNodeElements(tileMatrix, "./wmts:MatrixWidth");
            NodeList heights = ServiceMetadataUtils.getNodeElements(tileMatrix, "./wmts:MatrixHeight");
            Node widthNode = widths.item(0);
            Node heightNode = heights.item(0);
            String widthStr = widthNode.getTextContent().trim();
            String heightStr = heightNode.getTextContent().trim();
            int numWidth = Integer.parseInt(widthStr);
            int numHeight = Integer.parseInt(heightStr);
            int randomWidth = RANDOM.nextInt(numWidth);
            int randomHeight = RANDOM.nextInt(numHeight);
            int[] values = new int[]{randomWidth, randomHeight};
            return values;
        }
        return null;
    }

    private static int[] getRandomLayerTilePixels(Document wmtsCapabilities, String tileMatrixSetName, String tileMatrixName) throws XPathExpressionException {
        NodeList tileMatrices = ServiceMetadataUtils.getNodeElements(wmtsCapabilities, "//wmts:Contents/wmts:TileMatrixSet[ows:Identifier = '" + tileMatrixSetName + "']/wmts:TileMatrix[ows:Identifier = '" + tileMatrixName + "']");
        if (tileMatrices.getLength() > 0) {
            Node tileMatrix = tileMatrices.item(0);
            NodeList widths = ServiceMetadataUtils.getNodeElements(tileMatrix, "./wmts:TileWidth");
            NodeList heights = ServiceMetadataUtils.getNodeElements(tileMatrix, "./wmts:TileHeight");
            Node widthNode = widths.item(0);
            Node heightNode = heights.item(0);
            String widthStr = widthNode.getTextContent().trim();
            String heightStr = heightNode.getTextContent().trim();
            int numWidth = Integer.parseInt(widthStr);
            int numHeight = Integer.parseInt(heightStr);
            int randomWidth = RANDOM.nextInt(numWidth);
            int randomHeight = RANDOM.nextInt(numHeight);
            int[] values = new int[]{randomWidth, randomHeight};
            return values;
        }
        return null;
    }
}

