/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.util.TestSuiteLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.xpath.XPathException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesKeywordTest
extends AbstractBaseGetCapabilitiesFixture {
    private URI getCapabilitiesURI;
    private static final String KEYWORD_FILE = "nas.keywords";

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 17", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsGetCapabilitiesURLExists() {
        this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        Assert.assertTrue(this.getCapabilitiesURI != null, "GetCapabilities (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 17", dependsOnMethods={"wmtsGetCapabilitiesURLExists"})
    public void wmtsCapabilitiesKeywordTest() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(true, "WMTS ServiceMetadata Capabilities docuemnt", this.wmtsCapabilities, "//ows:ServiceIdentification/ows:Keywords");
    }

    public static void verifyNASkeywords(boolean mandatory, String keywordLocationDescription, Node xmlNode, String keywordLocation) {
        try {
            Node keywordsElement = ServiceMetadataUtils.getNode(xmlNode, keywordLocation);
            if (mandatory) {
                Assert.assertFalse(keywordsElement == null, keywordLocationDescription + " contains no mandatory <Keywords> Element.");
                Assert.assertFalse(keywordsElement.getFirstChild() == null || keywordsElement.getChildNodes().getLength() <= 0, keywordLocationDescription + " contains no <Keyword> Elements under the <Keywords>.");
            } else {
                if (keywordsElement == null) {
                    throw new SkipException("There is no <Keywords> Element to compare under " + keywordLocationDescription);
                }
                if (keywordsElement.getFirstChild() == null || keywordsElement.getChildNodes().getLength() <= 0) {
                    throw new SkipException("There are no <Keyword> Elements under the <Keywords> to compare under " + keywordLocationDescription);
                }
            }
            NodeList keywords = keywordsElement.getChildNodes();
            ArrayList<String> keywordsToCheck = new ArrayList<String>();
            for (int keywordNodeIndex = 0; keywordNodeIndex < keywords.getLength(); ++keywordNodeIndex) {
                Node keywordNode = keywords.item(keywordNodeIndex);
                String keyword = keywordNode.getTextContent();
                if (keyword == null) continue;
                keywordsToCheck.add(keyword.toLowerCase().trim());
            }
            Assert.assertFalse(keywordsToCheck == null || keywordsToCheck.isEmpty() || keywordsToCheck.size() < 1, "Error creating or corrupt Keyword list");
            boolean anyFound = false;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(GetCapabilitiesKeywordTest.class.getResourceAsStream(KEYWORD_FILE), "UTF-8"));){
                String nasKeyword;
                while ((nasKeyword = br.readLine()) != null) {
                    if ((nasKeyword = nasKeyword.toLowerCase().trim()).isEmpty() || !keywordsToCheck.contains(nasKeyword)) continue;
                    anyFound = true;
                    break;
                }
                br.close();
            }
            catch (IOException e) {
                TestSuiteLogger.log(Level.WARNING, "Keywords file nas.keywords could not be parsed.", e);
                Assert.assertTrue(false, "Keywords file nas.keywords could not be parsed.");
            }
            Assert.assertTrue(anyFound, "No valid NAS keywords found in: " + keywordLocationDescription);
        }
        catch (XPathException xpe) {
            xpe.printStackTrace();
        }
    }
}

