/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import java.net.URI;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesOperations
extends AbstractBaseGetCapabilitiesFixture {
    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 2", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesExists() {
        Assert.assertTrue(this.wmtsCapabilities != null, "No ServerMetadata Capabilities document");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 2", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesOperationsMetadataExists() {
        String xPathExpr = "//wmts:Capabilities/ows:OperationsMetadata != ''";
        ETSAssert.assertXPath(xPathExpr, this.wmtsCapabilities, NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 2", dependsOnMethods={"wmtsCapabilitiesOperationsMetadataExists"})
    public void wmtsCapabilitiesOperationsMetadataOperationExists() {
        String xPathExpr = "//wmts:Capabilities/ows:OperationsMetadata/ows:Operation != ''";
        ETSAssert.assertXPath(xPathExpr, this.wmtsCapabilities, NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 2", dependsOnMethods={"wmtsCapabilitiesOperationsMetadataOperationExists"})
    public void wmtsCapabilitiesKVPRequestsExists() {
        URI uri = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        Assert.assertTrue(uri != null, "GetCapabilities (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 2", dependsOnMethods={"wmtsCapabilitiesKVPRequestsExists"})
    public void wmtsCapabilitiesValidated() throws XPathFactoryConfigurationException, XPathExpressionException {
        XPath xpath = this.createXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//wmts:Capabilities/ows:OperationsMetadata/ows:Operation", this.wmtsCapabilities, XPathConstants.NODESET);
        for (int ni = 0; ni < nodes.getLength(); ++ni) {
            Node operation = nodes.item(ni);
            NodeList methods = (NodeList)xpath.evaluate("./ows:DCP/ows:HTTP/*", operation, XPathConstants.NODESET);
            for (int mi = 0; mi < methods.getLength(); ++mi) {
                Node method = methods.item(mi);
                URI endPoint = URI.create((String)xpath.evaluate("@xlink:href", method, XPathConstants.STRING));
                if (endPoint.getQuery() != null) {
                    String uri = endPoint.toString();
                    endPoint = URI.create(uri.substring(0, uri.indexOf(63)));
                }
                Assert.assertTrue(endPoint != null, "Invalid endpoint (" + endPoint.toString() + ") located in ServiceMetadata capabilities document");
            }
        }
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return xpath;
    }
}

