/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.util.Strings;
import org.w3c.dom.Document;

public class GetCapabilitiesRest
extends AbstractBaseGetCapabilitiesFixture {
    private URI restURI;
    private boolean _debug = false;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 4", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesRESTCapable() throws XPathExpressionException, XPathFactoryConfigurationException, URISyntaxException {
        String restURIstr;
        this.restURI = ServiceMetadataUtils.getOperationEndpoint_REST(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        if (this.restURI == null && !Strings.isNullOrEmpty(restURIstr = (String)this.createXPath().evaluate("//wmts:ServiceMetadataURL/@xlink:href", this.wmtsCapabilities, XPathConstants.STRING))) {
            this.restURI = new URI(restURIstr);
        }
        Assert.assertTrue(this.restURI != null, "This WMTS does not support REST");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 4", dependsOnMethods={"wmtsCapabilitiesRESTCapable"})
    public void wmtsCapabilitiesRESTReponseTest() {
        Assert.assertTrue(this.restURI != null, "There is no REST URL to test against");
        String restURIstr = this.restURI.toString();
        ETSAssert.assertUrl(restURIstr);
        try {
            Document responseDoc = URIUtils.resolveURIAsDocument(this.restURI);
            Assert.assertTrue("Capabilities".equals(responseDoc.getDocumentElement().getLocalName()), "Invalid REST request for WMTS ServeiceMetadata capabilities document: " + responseDoc.getDocumentElement().getNodeName());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (this._debug) {
                e.printStackTrace();
            }
            Assert.assertTrue(false, "Error found when retrieving REST  WMTS ServeiceMetadata capabilities document: " + e.getMessage());
        }
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return xpath;
    }
}

