/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import java.net.URI;
import javax.xml.soap.SOAPMessage;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.core.util.WmtsSoapContainer;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesSoap
extends AbstractBaseGetCapabilitiesFixture {
    private URI soapURI;

    GetCapabilitiesSoap() {
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 3", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesSoapSupported() {
        this.soapURI = ServiceMetadataUtils.getOperationEndpoint_SOAP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.POST);
        if (this.soapURI == null) {
            throw new SkipException("GetCapabilities (POST) endpoint not found in ServiceMetadata capabilities document or WMTS does not support SOAP.");
        }
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 3", dependsOnMethods={"wmtsCapabilitiesSoapSupported"})
    public void wmtsCapabilitiesSoapReponseTest() {
        Assert.assertTrue(this.soapURI != null, "There is no SOAP URL to test against");
        String soapURIstr = this.soapURI.toString();
        ETSAssert.assertUrl(soapURIstr);
        WmtsSoapContainer soap = new WmtsSoapContainer("GetCapabilities", soapURIstr);
        soap.addParameterWithChild("ows", "AcceptVersions", "Version", "1.0.0");
        soap.addParameterWithChild("ows", "AcceptFormats", "OutputFormat", "application/soap+xml");
        SOAPMessage soapResponse = soap.getSoapResponse(true);
        Assert.assertTrue(soapResponse != null, "SOAP reposnse came back null");
        Document soapDocument = soap.getResponseDocument();
        ETSAssert.assertXPath("//wmts:Capabilities/@version = '1.0.0'", soapDocument, NS_BINDINGS);
    }
}

