/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.gettile;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import java.net.URI;
import org.opengeospatial.cite.wmts10.ets.core.assertion.WmtsAssertion;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.gettile.AbstractBaseGetTileFixture;
import org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities.GetCapabilitiesKvpFormatTest;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class GetTileOfferings
extends AbstractBaseGetTileFixture {
    private URI getTileURI = null;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 14")
    public void wmtsGetCapabilitiiesWithXML(ITestContext testContext) {
        GetCapabilitiesKvpFormatTest gck = new GetCapabilitiesKvpFormatTest();
        gck.init(testContext);
        gck.TestXML();
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 14")
    public void wmtsGetCapabilitiiesWithHTML(ITestContext testContext) {
        GetCapabilitiesKvpFormatTest gck = new GetCapabilitiesKvpFormatTest();
        gck.init(testContext);
        gck.TestHTML();
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 14")
    public void wmtsGetCapabilitiiesInEnglish() {
        throw new SkipException("Test for results in English not implemented.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 14", dependsOnMethods={"verifyGetTileSupported"})
    public void wmtsGetTileKVPRequestsExists() {
        this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetTile", ProtocolBinding.GET);
        Assert.assertTrue(this.getTileURI != null, "GetTile (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 14", dependsOnMethods={"wmtsGetTileKVPRequestsExists"})
    public void wmtsGetTileOfferingsTestPNG() {
        this.checkGetTileWithImageFormat("image/png");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 14", dependsOnMethods={"wmtsGetTileKVPRequestsExists"})
    public void wmtsGetTileOfferingsTestJPG() {
        this.checkGetTileWithImageFormat("image/jpeg");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 14", dependsOnMethods={"wmtsGetTileKVPRequestsExists"})
    public void wmtsGetTileOfferingsTestGIF() {
        this.checkGetTileWithImageFormat("image/gif");
    }

    private void checkGetTileWithImageFormat(String requestFormat) {
        if (this.getTileURI == null) {
            this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetTile", ProtocolBinding.GET);
        }
        this.reqEntity.removeKvp("Format");
        this.reqEntity.addKvp("Format", requestFormat);
        ClientResponse rsp = this.wmtsClient.submitRequest(this.reqEntity, this.getTileURI);
        this.storeResponseImage(rsp, "Requirement14", "simple", requestFormat);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
        WmtsAssertion.assertStatusCode(rsp.getStatus(), 200);
        WmtsAssertion.assertContentType(rsp.getHeaders(), requestFormat);
    }
}

