/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.gettile;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import java.net.URI;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.assertion.WmtsAssertion;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.gettile.AbstractBaseGetTileFixture;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.testng.asserts.SoftAssert;
import org.w3c.dom.NodeList;

public class GetTileParametersKvp
extends AbstractBaseGetTileFixture {
    private URI getTileURI = null;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 5", dependsOnMethods={"verifyGetTileSupported"})
    public void wmtsGetTileKVPRequestsExists() {
        this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetTile", ProtocolBinding.GET);
        Assert.assertTrue(this.getTileURI != null, "GetTile (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 5", dependsOnMethods={"wmtsGetTileKVPRequestsExists"})
    public void wmtsGetTileRequestFormatParameters(ITestContext testContext) {
        if (this.getTileURI == null) {
            this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetTile", ProtocolBinding.GET);
        }
        String requestFormat = null;
        try {
            NodeList layers;
            XPath xPath = this.createXPath();
            String layerName = this.reqEntity.getKvpValue("Layer");
            if (layerName == null && (layers = ServiceMetadataUtils.getNodeElements(xPath, this.wmtsCapabilities, "//wmts:Contents/wmts:Layer/ows:Identifier")).getLength() > 0) {
                layerName = layers.item(0).getTextContent().trim();
            }
            NodeList imageFormats = ServiceMetadataUtils.getNodeElements(xPath, this.wmtsCapabilities, "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layerName + "']/wmts:Format");
            SoftAssert sa = new SoftAssert();
            for (int i = 0; i < imageFormats.getLength(); ++i) {
                this.reqEntity.removeKvp("Format");
                requestFormat = imageFormats.item(i).getTextContent().trim();
                this.reqEntity.addKvp("Format", requestFormat);
                ClientResponse rsp = this.wmtsClient.submitRequest(this.reqEntity, this.getTileURI);
                this.storeResponseImage(rsp, "Requirement5", "simple", requestFormat);
                sa.assertTrue(rsp.hasEntity(), ErrorMessage.get(ErrorMessageKey.MISSING_XML_ENTITY));
                WmtsAssertion.assertStatusCode(sa, rsp.getStatus(), 200);
                WmtsAssertion.assertContentType(sa, rsp.getHeaders(), requestFormat);
            }
            sa.assertAll();
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException xpe) {
            Assert.assertTrue(false, "Invalid or corrupt XML or KVP structure:  " + xpe.getMessage());
        }
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return xpath;
    }
}

