/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.gettile;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.latlon.ets.core.assertion.ETSAssert;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.gettile.AbstractBaseGetTileFixture;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.testng.util.Strings;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetTileParametersRest
extends AbstractBaseGetTileFixture {
    private URI getTileURI = null;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 7", dependsOnMethods={"verifyGetTileSupported"})
    public void wmtsGetTileRESTCapable() throws XPathExpressionException, XPathFactoryConfigurationException {
        URI sampleURI = this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_REST(this.wmtsCapabilities, "GetTile", ProtocolBinding.GET);
        if (this.getTileURI == null) {
            XPath xPath = this.createXPath();
            NodeList resourceURLs = ServiceMetadataUtils.getNodeElements(xPath, this.wmtsCapabilities, "//wmts:Contents/wmts:Layer/wmts:ResourceURL");
            for (int i = 0; sampleURI == null && i < resourceURLs.getLength(); ++i) {
                String templateURL = ServiceMetadataUtils.getNodeText(xPath, resourceURLs.item(i), "@template");
                String tileMatrixSet = ServiceMetadataUtils.getNodeText(xPath, this.wmtsCapabilities, "//wmts:Contents/wmts:TileMatrixSet/ows:Identifier");
                if (templateURL == null) continue;
                try {
                    templateURL = templateURL.replaceAll("\\{(?i)Style\\}", "default");
                    templateURL = templateURL.replaceAll("\\{(?i)TileMatrixSet\\}", tileMatrixSet);
                    templateURL = templateURL.replaceAll("\\{(?i)TileMatrix\\}", "0");
                    templateURL = templateURL.replaceAll("\\{(?i)TileRow\\}", "0");
                    templateURL = templateURL.replaceAll("\\{(?i)TileCol\\}", "0");
                    templateURL = templateURL.replaceAll("\\{(?i)I\\}", "0");
                    templateURL = templateURL.replaceAll("\\{(?i)J\\}", "0");
                    sampleURI = new URI(templateURL);
                    continue;
                }
                catch (URISyntaxException ue) {
                    sampleURI = null;
                }
            }
        }
        Assert.assertTrue(sampleURI != null, "GetTile (GET) endpoint not found or REST is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 7", dependsOnMethods={"wmtsGetTileRESTCapable"})
    public void wmtsGetTileRequestParametersSupported(ITestContext testContext) {
        String requestFormat = null;
        try {
            NodeList layers;
            String layerName = this.reqEntity.getKvpValue("Layer");
            if (layerName == null && (layers = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:Layer/ows:Identifier")).getLength() > 0) {
                layerName = layers.item(0).getTextContent().trim();
            }
            XPath xPath = this.createXPath();
            String style = this.reqEntity.getKvpValue("Style");
            String tileMatrixSet = this.reqEntity.getKvpValue("TileMatrixSet");
            String tileMatrix = this.reqEntity.getKvpValue("TileMatrix");
            String tileRow = this.reqEntity.getKvpValue("TileRow");
            String tileCol = this.reqEntity.getKvpValue("TileCol");
            requestFormat = this.reqEntity.getKvpValue("Format");
            NodeList resourceURLs = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layerName + "']/wmts:ResourceURL");
            Assert.assertTrue(resourceURLs != null && resourceURLs.getLength() > 0, "WMTS apparently does not support REST or contains no REST endpoints for layer: " + layerName);
            Random random = new Random();
            int randomIndx = random.nextInt(resourceURLs.getLength());
            Node resourceNode = resourceURLs.item(randomIndx);
            String templateURL = ServiceMetadataUtils.getNodeText(xPath, resourceNode, "@template");
            requestFormat = ServiceMetadataUtils.getNodeText(xPath, resourceNode, "@format");
            if (Strings.isNullOrEmpty(templateURL) || Strings.isNullOrEmpty(requestFormat)) {
                throw new XPathExpressionException("Invalid or corrupt Resource URL image format");
            }
            try {
                templateURL = templateURL.replaceAll("\\{(?i)Style\\}", style);
                templateURL = templateURL.replaceAll("\\{(?i)TileMatrixSet\\}", tileMatrixSet);
                templateURL = templateURL.replaceAll("\\{(?i)TileMatrix\\}", tileMatrix);
                templateURL = templateURL.replaceAll("\\{(?i)TileRow\\}", tileRow);
                templateURL = templateURL.replaceAll("\\{(?i)TileCol\\}", tileCol);
                templateURL = templateURL.replaceAll("\\{(?i)I\\}", "0");
                templateURL = templateURL.replaceAll("\\{(?i)J\\}", "0");
                this.getTileURI = new URI(templateURL);
            }
            catch (URISyntaxException ue) {
                this.getTileURI = null;
            }
            ETSAssert.assertUrl(this.getTileURI.toString());
            Client client = Client.create();
            WebResource webRes = client.resource(this.getTileURI);
            ClientResponse rsp = webRes.get(ClientResponse.class);
            Assert.assertTrue(rsp != null, "Error processing REST GetTile request");
            this.storeResponseImage(rsp, "Requirement7", "simple", requestFormat);
            ETSAssert.assertContentType(rsp.getHeaders(), requestFormat);
            ETSAssert.assertStatusCode(rsp.getStatus(), 200);
            String erroneousURL = this.getTileURI.toString();
            int indx = erroneousURL.lastIndexOf("/");
            erroneousURL = erroneousURL.substring(0, indx + 1) + "X" + erroneousURL.substring(indx + 1);
            URI invalidURI = null;
            try {
                invalidURI = new URI(erroneousURL);
            }
            catch (URISyntaxException ue) {
                System.out.println(ue.getMessage());
                invalidURI = null;
            }
            Client client2 = Client.create();
            WebResource webRes2 = client2.resource(invalidURI);
            ClientResponse rsp2 = webRes2.get(ClientResponse.class);
            Assert.assertTrue(rsp2 != null, "Error processing invalid REST GetTile request");
            Assert.assertFalse(rsp2.getStatus() == 200, "Expected status code from Invalid REST GetTile request is not expected to be 200. ");
            ETSAssert.assertContentType(rsp2.getHeaders(), "text/xml");
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException xpe) {
            Assert.assertTrue(false, "Error found when retrieving REST Get Tile request: " + xpe.getMessage());
        }
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return xpath;
    }
}

