/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.gettile;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.TestSuiteLogger;
import java.net.URI;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.core.util.WmtsSoapContainer;
import org.opengeospatial.cite.wmts10.ets.testsuite.gettile.AbstractBaseGetTileFixture;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.testng.asserts.SoftAssert;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetTileParametersSoap
extends AbstractBaseGetTileFixture {
    private URI getTileURI = null;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 6", dependsOnMethods={"verifyGetTileSupported"})
    public void wmtsGetTileSoapSupported() {
        this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_SOAP(this.wmtsCapabilities, "GetTile", ProtocolBinding.POST);
        if (this.getTileURI == null) {
            throw new SkipException("GetTile (GET) endpoint not found in ServiceMetadata capabilities document or WMTS does not support SOAP.");
        }
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 6", dependsOnMethods={"wmtsGetTileSoapSupported"})
    public void wmtsGetTileSoapRequestFormatParameters(ITestContext testContext) {
        if (this.getTileURI == null) {
            this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_SOAP(this.wmtsCapabilities, "GetTile", ProtocolBinding.POST);
        }
        String requestFormat = null;
        String soapURIstr = this.getTileURI.toString();
        ETSAssert.assertUrl(soapURIstr);
        try {
            NodeList layers;
            XPath xPath = this.createXPath();
            String layerName = this.reqEntity.getKvpValue("Layer");
            if (layerName == null && (layers = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:Layer/ows:Identifier")).getLength() > 0) {
                layerName = layers.item(0).getTextContent().trim();
            }
            String style = this.reqEntity.getKvpValue("Style");
            String tileMatrixSet = this.reqEntity.getKvpValue("TileMatrixSet");
            String tileMatrix = this.reqEntity.getKvpValue("TileMatrix");
            String tileRow = this.reqEntity.getKvpValue("TileRow");
            String tileCol = this.reqEntity.getKvpValue("TileCol");
            requestFormat = this.reqEntity.getKvpValue("Format");
            NodeList imageFormats = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layerName + "']/wmts:Format");
            SoftAssert sa = new SoftAssert();
            for (int i = 0; i < imageFormats.getLength(); ++i) {
                requestFormat = imageFormats.item(i).getTextContent().trim();
                WmtsSoapContainer soap = new WmtsSoapContainer("GetTile", soapURIstr);
                soap.addParameter("ows", "Layer", layerName);
                soap.addParameter("ows", "Style", style);
                soap.addParameter("ows", "Format", requestFormat);
                soap.addParameter("ows", "TileMatrixSet", tileMatrixSet);
                soap.addParameter("ows", "TileMatrix", tileMatrix);
                soap.addParameter("ows", "TileRow", tileRow);
                soap.addParameter("ows", "TileCol", tileCol);
                SOAPMessage soapResponse = soap.getSoapResponse(true);
                sa.assertTrue(soapResponse != null, "SOAP reposnse came back null");
                Document soapDocument = soap.getResponseDocument();
                if (soapResponse.getAttachments() != null && soapResponse.countAttachments() > 0) {
                    Iterator attachmentsIterator = soapResponse.getAttachments();
                    while (attachmentsIterator.hasNext()) {
                        AttachmentPart attachmentPart = (AttachmentPart)attachmentsIterator.next();
                    }
                    continue;
                }
                String formatStr = ServiceMetadataUtils.getNodeText(xPath, soapDocument, "//wmts:BinaryPayload/wmts:Format");
                this.storeSoapResponseImage(soapResponse, "Requirement6", "simple", formatStr);
                sa.assertEquals(formatStr, requestFormat, "SOAP response received format: " + formatStr + " but expected: " + requestFormat);
            }
            sa.assertAll();
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Invalid or corrupt SOAP content or XML format", xpe);
        }
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(NS_BINDINGS);
        return xpath;
    }
}

