/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.testsuite;

import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.core.util.TestSuiteLogger;
import de.latlon.ets.core.util.XMLUtils;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.client.WmtsClient;
import org.opengeospatial.cite.wmts10.ets.core.client.WmtsKvpRequest;
import org.opengeospatial.cite.wmts10.ets.core.domain.LayerInfo;
import org.opengeospatial.cite.wmts10.ets.core.domain.SuiteAttribute;
import org.opengeospatial.cite.wmts10.ets.core.domain.WmtsNamespaces;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractBaseGetFixture {
    private static final int MAX_RSP_ATTR_LENGTH = 1536;
    protected static final NamespaceBindings NS_BINDINGS = WmtsNamespaces.withStandardBindings();
    protected Document wmtsCapabilities;
    protected WmtsClient wmtsClient;
    protected DocumentBuilder docBuilder;
    protected WmtsKvpRequest reqEntity;
    protected Document rspEntity;
    protected List<LayerInfo> layerInfo;

    public void setWmtsClient(WmtsClient wmtsClient) {
        this.wmtsClient = wmtsClient;
    }

    @BeforeClass(alwaysRun=true)
    public void initBaseFixture(ITestContext testContext) {
        if (this.wmtsCapabilities != null) {
            return;
        }
        this.wmtsCapabilities = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        this.wmtsClient = new WmtsClient(this.wmtsCapabilities);
        this.layerInfo = (List)testContext.getSuite().getAttribute(SuiteAttribute.LAYER_INFO.getName());
    }

    @BeforeClass
    public void initParser() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Failed to create DOM parser", (Exception)e);
        }
    }

    @BeforeMethod
    public void buildGetCapabilitiesResponse() {
        if (this.wmtsCapabilities != null) {
            this.rspEntity = this.wmtsCapabilities;
        }
    }

    @AfterMethod
    public void addAttributesOnTestFailure(ITestResult result) {
        if (result.getStatus() != 2) {
            return;
        }
        if (this.reqEntity != null) {
            String request = this.reqEntity.asQueryString();
            result.setAttribute("request", (Object)request);
        }
        if (this.rspEntity != null) {
            StringBuilder response = new StringBuilder(XMLUtils.writeNodeToString((Node)this.rspEntity));
            if (response.length() > 1536) {
                response.delete(1536, response.length());
            }
            result.setAttribute("response", (Object)response.toString());
        }
    }

    @AfterMethod
    public void addAttributesOnTestSuccess(ITestResult result) {
        if (result.getStatus() != 1) {
            return;
        }
        if (this.reqEntity != null) {
            String request = this.reqEntity.asQueryString();
            result.setAttribute("request", (Object)request);
        }
    }
}

