/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import org.opengeospatial.cite.wmts10.ets.core.assertion.WmtsAssertion;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.ITestContext;
import org.w3c.dom.Document;

public class GetCapabilitiesKvpFormatTest
extends AbstractBaseGetCapabilitiesFixture {
    private URI getCapabilitiesURI;

    public void init(ITestContext testContext) {
        this.initBaseFixture(testContext);
        this.initParser();
        this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        Assert.assertTrue((this.getCapabilitiesURI != null ? 1 : 0) != 0, (String)"GetCapabilities (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
        this.buildGetCapabilitiesRequest();
    }

    public void TestXML() {
        this.verifyFormatResponse("text/xml");
    }

    public void TestHTML() {
        this.verifyFormatResponse("text/html");
    }

    private void verifyFormatResponse(String requestFormat) {
        if (this.getCapabilitiesURI == null) {
            this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        }
        this.reqEntity.removeKvp("Format");
        this.reqEntity.addKvp("Format", requestFormat);
        ClientResponse rsp = this.wmtsClient.submitRequest(this.reqEntity, this.getCapabilitiesURI);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        WmtsAssertion.assertStatusCode(rsp.getStatus(), 200);
        WmtsAssertion.assertContentType((MultivaluedMap<String, String>)rsp.getHeaders(), requestFormat);
    }
}

