/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import java.net.URI;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPathExpressionException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.core.util.WmtsSoapContainer;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class GetCapabilitiesSoapVersionTest
extends AbstractBaseGetCapabilitiesFixture {
    private URI getCapabilitiesURI;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 16", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsGetCapabilitiesURLExists() {
        this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint_SOAP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.POST);
        if (this.getCapabilitiesURI == null) {
            throw new SkipException("GetCapabilities (POST) endpoint not found or SOAP is not supported in ServiceMetadata capabilities document.");
        }
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 16", dependsOnMethods={"wmtsGetCapabilitiesURLExists"})
    public void wmtsCapabilitiesVersionTest() throws XPathExpressionException {
        String versionManipulation = "1.0.0";
        versionManipulation = 1 + Integer.parseInt(versionManipulation.substring(0, 1)) + versionManipulation.substring(1);
        Assert.assertFalse((boolean)this.verifyVersionResponse(versionManipulation), (String)("WMTS did not handle an invalid version ('" + versionManipulation + "') correctly"));
        versionManipulation = "0.0.1";
        Assert.assertFalse((boolean)this.verifyVersionResponse(versionManipulation), (String)("WMTS did not handle an invalid version ('" + versionManipulation + "') correctly"));
        Assert.assertTrue((boolean)this.verifyVersionResponse("1.0.0"), (String)"This WMTS does not accept the current version ('1.0.0')");
    }

    private boolean verifyVersionResponse(String version) throws XPathExpressionException {
        boolean result = false;
        if (this.getCapabilitiesURI == null) {
            this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        }
        String soapURIstr = this.getCapabilitiesURI.toString();
        ETSAssert.assertUrl((String)soapURIstr);
        WmtsSoapContainer soap = new WmtsSoapContainer("GetCapabilities", soapURIstr);
        soap.addParameterWithChild("ows", "AcceptVersions", "Version", version);
        soap.addParameterWithChild("ows", "AcceptFormats", "OutputFormat", "application/soap+xml");
        SOAPMessage soapResponse = soap.getSoapResponse(false);
        result = soapResponse != null;
        return result;
    }
}

