/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getfeatureinfo;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getfeatureinfo.AbstractBaseGetFeatureInfoFixture;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GetFeatureInfoKvp
extends AbstractBaseGetFeatureInfoFixture {
    private URI getFeatureInfoURI;
    private boolean _debug = false;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 8", dependsOnMethods={"verifyGetFeatureInfoSupported"})
    public void wmtsGetFeatureInfoExists() {
        this.getFeatureInfoURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        Assert.assertTrue((this.getFeatureInfoURI != null ? 1 : 0) != 0, (String)"GetFeatureInfo (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 5", dependsOnMethods={"wmtsGetFeatureInfoExists"})
    public void wmtsGetFeatureInfoRequestParameters(ITestContext testContext) {
        if (this.getFeatureInfoURI == null) {
            this.getFeatureInfoURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        }
        Object requestFormat = null;
        try {
            NodeList layers;
            XPath xPath = this.createXPath();
            String layerName = this.reqEntity.getKvpValue("Layer");
            if (layerName == null && (layers = ServiceMetadataUtils.getNodeElements(xPath, this.wmtsCapabilities, "//wmts:Contents/wmts:Layer/ows:Identifier")).getLength() > 0) {
                layerName = layers.item(0).getTextContent().trim();
            }
            String infoFormat = this.reqEntity.getKvpValue("InfoFormat");
            ClientResponse rsp = this.wmtsClient.submitRequest(this.reqEntity, this.getFeatureInfoURI);
            this.rspEntity = (Document)rsp.getEntity(Document.class);
            Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
            ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
            ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)infoFormat);
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException xpe) {
            System.out.println(xpe.getMessage());
            if (this._debug) {
                xpe.printStackTrace();
            }
            Assert.assertTrue((boolean)false, (String)("Invalid or corrupt XML or KVP structure:  " + xpe.getMessage()));
        }
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }
}

