/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getfeatureinfo;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.TestSuiteLogger;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPathExpressionException;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.core.util.WmtsSoapContainer;
import org.opengeospatial.cite.wmts10.ets.testsuite.getfeatureinfo.AbstractBaseGetFeatureInfoFixture;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.NodeList;

public class GetFeatureInfoSoap
extends AbstractBaseGetFeatureInfoFixture {
    private URI getFeatureInfoURI = null;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 9", dependsOnMethods={"verifyGetFeatureInfoSupported"})
    public void wmtsGetFeatureInfoSoapSupported() {
        this.getFeatureInfoURI = ServiceMetadataUtils.getOperationEndpoint_SOAP(this.wmtsCapabilities, "GetFeatureInfo", ProtocolBinding.POST);
        if (this.getFeatureInfoURI == null) {
            throw new SkipException("GetFeatureInfo (POST) endpoint not found in ServiceMetadata capabilities document or WMTS does not support SOAP.");
        }
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 9", dependsOnMethods={"wmtsGetFeatureInfoSoapSupported"})
    public void wmtsGetFeatureInfoSoapRequestFormatParameters(ITestContext testContext) {
        if (this.getFeatureInfoURI == null) {
            this.getFeatureInfoURI = ServiceMetadataUtils.getOperationEndpoint_SOAP(this.wmtsCapabilities, "GetFeatureInfo", ProtocolBinding.POST);
        }
        String soapURIstr = this.getFeatureInfoURI.toString();
        ETSAssert.assertUrl((String)soapURIstr);
        try {
            WmtsSoapContainer soap = this.createSoapContainer(soapURIstr);
            SOAPMessage soapResponse = soap.getSoapResponse(true);
            Assert.assertTrue((soapResponse != null ? 1 : 0) != 0, (String)"SOAP response came back null");
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Invalid or corrupt SOAP content or XML format", (Exception)xpe);
        }
    }

    private WmtsSoapContainer createSoapContainer(String soapURIstr) throws XPathExpressionException {
        WmtsSoapContainer soap = new WmtsSoapContainer("GetFeatureInfo", soapURIstr);
        soap.addParameter("ows", "Layer", this.findLayerName());
        this.addParamFromRequest(soap, "Style");
        this.addParamFromRequest(soap, "Format");
        this.addParamFromRequest(soap, "TileMatrixSet");
        this.addParamFromRequest(soap, "TileMatrix");
        this.addParamFromRequest(soap, "TileRow");
        this.addParamFromRequest(soap, "I");
        this.addParamFromRequest(soap, "J");
        this.addParamFromRequest(soap, "InfoFormat");
        return soap;
    }

    private String findLayerName() throws XPathExpressionException {
        NodeList layers;
        String layerName = this.reqEntity.getKvpValue("Layer");
        if (layerName == null && (layers = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:Layer/ows:Identifier")).getLength() > 0) {
            layerName = layers.item(0).getTextContent().trim();
        }
        return layerName;
    }

    private void addParamFromRequest(WmtsSoapContainer soap, String paramName) {
        String style = this.reqEntity.getKvpValue(paramName);
        soap.addParameter("ows", paramName, style);
    }
}

