/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.assertion;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import de.latlon.ets.core.util.NamespaceBindings;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.namespace.QName;
import org.opengeospatial.cite.wmts10.ets.core.domain.WmtsNamespaces;
import org.testng.Assert;
import org.testng.asserts.SoftAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class WmtsAssertion {
    private WmtsAssertion() {
    }

    public static void assertSimpleWMTSCapabilities(Document doc) {
        ETSAssert.assertQualifiedName((Node)doc.getDocumentElement(), (QName)new QName("http://www.opengis.net/wmts/1.0", "Capabilities"));
    }

    public static void assertVersion100(Document response) {
        WmtsAssertion.assertXPath("//wmts:Capabilities/@version = '1.0.0'", response, WmtsNamespaces.withStandardBindings());
    }

    public static void assertStatusCode(SoftAssert sa, int actualCode, int ... expectedCodes) {
        Arrays.sort(expectedCodes);
        boolean containsExpectedCodes = Arrays.binarySearch(expectedCodes, actualCode) >= 0;
        String msg = String.format("Expected status code(s) %s but received %d.", Arrays.toString(expectedCodes), actualCode);
        if (sa == null) {
            Assert.assertTrue((boolean)containsExpectedCodes, (String)msg);
        } else {
            sa.assertTrue(containsExpectedCodes, msg);
        }
    }

    public static void assertStatusCode(int actualCode, int ... expectedCodes) {
        WmtsAssertion.assertStatusCode(null, actualCode, expectedCodes);
    }

    public static void assertContentType(SoftAssert sa, MultivaluedMap<String, String> headers, String expectedContentType) {
        List contentTypes = (List)headers.get((Object)"Content-Type");
        boolean containsContentType = WmtsAssertion.containsContentType(contentTypes, expectedContentType);
        String msg = String.format("Expected content type %s, but received %s", expectedContentType, WmtsAssertion.asString(contentTypes));
        if (sa == null) {
            Assert.assertTrue((boolean)containsContentType, (String)msg);
        } else {
            sa.assertTrue(containsContentType, msg);
        }
    }

    public static void assertContentType(MultivaluedMap<String, String> headers, String expectedContentType) {
        WmtsAssertion.assertContentType(null, headers, expectedContentType);
    }

    public static void assertUrl(SoftAssert sa, String url) {
        boolean urlWellFormed = false;
        String msg = null;
        try {
            new URL(url);
            urlWellFormed = true;
        }
        catch (MalformedURLException e) {
            msg = String.format("Invalid URL: %s", url);
        }
        if (sa == null) {
            Assert.assertTrue((boolean)urlWellFormed, (String)msg);
        } else {
            sa.assertTrue(urlWellFormed, msg);
        }
    }

    public static void assertUrl(String url) {
        WmtsAssertion.assertUrl(null, url);
    }

    public static void assertUriIsResolvable(SoftAssert sa, String url) {
        try {
            DefaultClientConfig config = new DefaultClientConfig();
            Client client = Client.create((ClientConfig)config);
            WebResource resource = client.resource(new URI(url));
            ClientResponse response = (ClientResponse)resource.get(ClientResponse.class);
            WmtsAssertion.assertStatusCode(sa, response.getStatus(), 200);
        }
        catch (NullPointerException | URISyntaxException e) {
            String errorMsg = String.format("Invalid URI %s: %s", url, e.getMessage());
            throw new AssertionError((Object)errorMsg);
        }
    }

    public static void assertXPath(SoftAssert sa, String expr, Node context, NamespaceBindings nsBindings) {
        Boolean result = ETSAssert.checkXPath((String)expr, (Node)context, (NamespaceBindings)nsBindings);
        if (sa == null) {
            Assert.assertTrue((boolean)result, (String)ErrorMessage.format((ErrorMessageKey)ErrorMessageKey.XPATH_RESULT, (Object[])new Object[]{context.getNodeName(), expr}));
        } else {
            sa.assertTrue(result.booleanValue(), ErrorMessage.format((ErrorMessageKey)ErrorMessageKey.XPATH_RESULT, (Object[])new Object[]{context.getNodeName(), expr}));
        }
    }

    public static void assertXPath(String expr, Node context, NamespaceBindings nsBindings) {
        WmtsAssertion.assertXPath(null, expr, context, nsBindings);
    }

    private static boolean containsContentType(List<String> contentTypes, String expectedContentType) {
        if (contentTypes != null) {
            for (String contentType : contentTypes) {
                if (!contentType.contains(expectedContentType)) continue;
                return true;
            }
        }
        return false;
    }

    private static String asString(List<String> values) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

