/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.gettile;

import com.sun.jersey.api.client.ClientResponse;
import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.opengeospatial.cite.wmts10.ets.core.assertion.WmtsAssertion;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.gettile.AbstractBaseGetTileFixture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetTileCachingInfo
extends AbstractBaseGetTileFixture {
    private URI getTileURI = null;
    private ClientResponse response = null;
    private List<String> cacheControls = null;
    private List<String> expires = null;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 19", dependsOnMethods={"verifyGetTileSupported"})
    public void wmtsGetTileKVPRequestsExists() {
        this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetTile", ProtocolBinding.GET);
        Assert.assertTrue((this.getTileURI != null ? 1 : 0) != 0, (String)"GetTile (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 19", dependsOnMethods={"wmtsGetTileKVPRequestsExists"})
    public void wmtsGetTileCachingInformationExists() {
        if (this.getTileURI == null) {
            this.getTileURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetTile", ProtocolBinding.GET);
        }
        this.reqEntity.removeKvp("Format");
        String requestFormat = "image/png";
        this.reqEntity.addKvp("Format", requestFormat);
        this.response = this.wmtsClient.submitRequest(this.reqEntity, this.getTileURI);
        this.storeResponseImage(this.response, "Requirement19", "simple", requestFormat);
        Assert.assertTrue((boolean)this.response.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        WmtsAssertion.assertStatusCode(this.response.getStatus(), 200);
        WmtsAssertion.assertContentType((MultivaluedMap<String, String>)this.response.getHeaders(), requestFormat);
        this.cacheControls = (List)this.response.getHeaders().get((Object)"Cache-control");
        this.expires = (List)this.response.getHeaders().get((Object)"Expires");
        boolean anyCacheControls = this.cacheControls != null && this.cacheControls.size() > 0;
        boolean anyExpires = this.expires != null && this.expires.size() > 0;
        Assert.assertTrue((anyCacheControls || anyExpires ? 1 : 0) != 0, (String)"WMTS does not provide appropriate caching information");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 19", dependsOnMethods={"wmtsGetTileCachingInformationExists"})
    public void wmtsGetTileExpirationExists() {
        boolean hasExpiration = false;
        if (this.expires != null && this.expires.size() > 0) {
            hasExpiration = true;
        }
        if (this.cacheControls != null && this.cacheControls.size() > 0) {
            String cacheControl = this.cacheControls.get(0);
            hasExpiration |= cacheControl.contains("max-age") || cacheControl.contains("maxage");
        }
        Assert.assertTrue((boolean)hasExpiration, (String)"WMTS has cache-control or expiration headers, but no expiration time or date is found.");
    }
}

