/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.core.keyword;

import de.latlon.ets.core.keyword.DfddKeywordMatcher;
import de.latlon.ets.core.util.TestSuiteLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class DfddKeywordMatcherFromFile
implements DfddKeywordMatcher {
    private static final String KEYWORD_FILE = "dfdd.keywords";
    private List<String> dfddKeywords;

    @Override
    public boolean containsAtLeastOneDfddKeyword(List<String> keywordsToCheck) {
        this.parseKeywords();
        for (String keyword : keywordsToCheck) {
            if (!this.dfddKeywords.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private void parseKeywords() {
        if (this.dfddKeywords == null) {
            InputStream resource = DfddKeywordMatcherFromFile.class.getResourceAsStream(KEYWORD_FILE);
            this.dfddKeywords = this.parseKeywordsFromStream(resource);
        }
    }

    private List<String> parseKeywordsFromStream(InputStream resource) {
        ArrayList<String> keywords = new ArrayList<String>();
        if (resource != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resource, "UTF-8"));){
                String line;
                while ((line = br.readLine()) != null) {
                    String keyword = line.trim();
                    if (keyword.isEmpty()) continue;
                    keywords.add(keyword);
                }
            }
            catch (IOException e) {
                TestSuiteLogger.log(Level.WARNING, "Keywords file dfdd.keywords could not be parsed.", e);
            }
        } else {
            TestSuiteLogger.log(Level.WARNING, "Could not find keywords file 'dfdd.keywords'.");
        }
        return keywords;
    }
}

