/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.opengeospatial.cite.wmts10.ets.core.domain.BoundingBox;
import org.opengeospatial.cite.wmts10.ets.core.domain.LayerInfo;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesCrsTest
extends AbstractBaseGetCapabilitiesFixture {
    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 11", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesExists() {
        Assert.assertTrue((this.wmtsCapabilities != null ? 1 : 0) != 0, (String)"No ServerMetadata Capabilities document");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 11", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesCrsTest() {
        try {
            boolean CRS84 = false;
            boolean EPSG4326 = false;
            NodeList crsList = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//ows:SupportedCRS");
            for (int crsI = 0; !(crsI >= crsList.getLength() || CRS84 && EPSG4326); ++crsI) {
                String modCrsName;
                int indx1;
                int indx0;
                Node supportedCRS = crsList.item(crsI);
                String crsName = supportedCRS.getTextContent();
                if (!CRS84 && crsName.contains("CRS:") && crsName.contains(":84") && (indx0 = crsName.lastIndexOf("CRS:")) < (indx1 = crsName.lastIndexOf(":84"))) {
                    modCrsName = crsName.substring(indx0, indx0 + 3) + crsName.substring(indx1, indx1 + 3);
                    CRS84 = modCrsName.equals("CRS:84");
                }
                if (EPSG4326 || !crsName.contains("EPSG:") || !crsName.contains(":4326") || (indx0 = crsName.lastIndexOf("EPSG:")) >= (indx1 = crsName.lastIndexOf(":4326"))) continue;
                modCrsName = crsName.substring(indx0, indx0 + 4) + crsName.substring(indx1, indx1 + 5);
                EPSG4326 = modCrsName.equals("EPSG:4326");
            }
            if (!CRS84 || !EPSG4326) {
                for (int layerI = 0; !(layerI >= this.layerInfo.size() || CRS84 && EPSG4326); ++layerI) {
                    LayerInfo layer = (LayerInfo)this.layerInfo.get(layerI);
                    List<BoundingBox> bbox = layer.getBboxes();
                    for (int bboxI = -1; !(bboxI >= bbox.size() || CRS84 && EPSG4326); ++bboxI) {
                        String modCrsName;
                        int indx1;
                        int indx0;
                        String crsName = null;
                        crsName = bboxI < 0 ? layer.getGeographicBbox().getCrs() : bbox.get(bboxI).getCrs();
                        if (!CRS84 && crsName.contains("CRS:") && crsName.contains(":84") && (indx0 = crsName.lastIndexOf("CRS:")) < (indx1 = crsName.lastIndexOf(":84"))) {
                            modCrsName = crsName.substring(indx0, indx0 + 3) + crsName.substring(indx1, indx1 + 3);
                            CRS84 = modCrsName.equals("CRS:84");
                        }
                        if (EPSG4326 || !crsName.contains("EPSG:") || !crsName.contains(":4326") || (indx0 = crsName.lastIndexOf("EPSG:")) >= (indx1 = crsName.lastIndexOf(":4326"))) continue;
                        modCrsName = crsName.substring(indx0, indx0 + 4) + crsName.substring(indx1, indx1 + 5);
                        EPSG4326 = modCrsName.equals("EPSG:4326");
                    }
                }
            }
            Assert.assertTrue((boolean)CRS84, (String)"WMTS does not support CRS:84 (WGS84) in none of its <Layer>s or <TileMatrixSet>s.");
            Assert.assertTrue((boolean)EPSG4326, (String)"WMTS does not support EPSG:4326 (WGS84) in none of its <Layer>s or <TileMatrixSet>s.");
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }
}

