/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.util;

import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.core.util.TestSuiteLogger;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengeospatial.cite.wmts10.ets.core.domain.BoundingBox;
import org.opengeospatial.cite.wmts10.ets.core.domain.LayerInfo;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.domain.WmtsNamespaces;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ServiceMetadataUtils {
    private static final Logger LOGR = Logger.getLogger(ServiceMetadataUtils.class.getName());
    private static final NamespaceBindings NS_BINDINGS = WmtsNamespaces.withStandardBindings();

    private ServiceMetadataUtils() {
    }

    public static URI getOperationEndpoint_KVP(Document wmtsMetadata, String opName, ProtocolBinding binding) {
        return ServiceMetadataUtils.getOperationEndpoint(wmtsMetadata, binding, "KVP", opName);
    }

    public static URI getOperationEndpoint_REST(Document wmtsMetadata, String opName, ProtocolBinding binding) {
        return ServiceMetadataUtils.getOperationEndpoint(wmtsMetadata, binding, "RESTful", opName);
    }

    public static URI getOperationEndpoint_SOAP(Document wmtsMetadata, String opName, ProtocolBinding binding) {
        return ServiceMetadataUtils.getOperationEndpoint(wmtsMetadata, binding, "SOAP", opName);
    }

    private static URI getOperationEndpoint(Document wmtsMetadata, ProtocolBinding binding, String protocol, String opName) {
        if (binding == null || binding.equals((Object)ProtocolBinding.ANY)) {
            binding = ServiceMetadataUtils.getOperationBindings(wmtsMetadata, opName).iterator().next();
        }
        if (binding == null) {
            return null;
        }
        try {
            String xPathString = "//ows:OperationsMetadata/ows:Operation[@name = '%s'and ( ./ows:Constraint/ows:AllowedValues/ows:Value = '%s' or ./ows:DCP/ows:HTTP/ows:%s/ows:Constraint/ows:AllowedValues/ows:Value = '%s')]/ows:DCP/ows:HTTP/ows:%s/@xlink:href";
            String xPathExpr = String.format(xPathString, opName, protocol, binding.getElementName(), protocol, binding.getElementName());
            XPath xPath = ServiceMetadataUtils.createXPath();
            String href = ServiceMetadataUtils.getNodeText(xPath, wmtsMetadata, xPathExpr);
            return ServiceMetadataUtils.createEndpoint(href);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log((Level)Level.INFO, (String)ex.getMessage());
            return null;
        }
    }

    public static Set<ProtocolBinding> getOperationBindings(Document wmtsMetadata, String opName) {
        HashSet<ProtocolBinding> protoBindings = new HashSet<ProtocolBinding>();
        if (ServiceMetadataUtils.isOperationBindingSupported(wmtsMetadata, opName, ProtocolBinding.GET)) {
            protoBindings.add(ProtocolBinding.GET);
        }
        if (ServiceMetadataUtils.isOperationBindingSupported(wmtsMetadata, opName, ProtocolBinding.POST)) {
            protoBindings.add(ProtocolBinding.POST);
        }
        return protoBindings;
    }

    public static NodeList getNodeElements(XPath xPath, Node wmtsCapabilities, String xPathAbstract) throws XPathExpressionException {
        if (xPath == null) {
            xPath = ServiceMetadataUtils.createXPath();
        }
        return (NodeList)xPath.evaluate(xPathAbstract, wmtsCapabilities, XPathConstants.NODESET);
    }

    public static NodeList getNodeElements(Node wmtsCapabilities, String xPathAbstract) throws XPathExpressionException {
        return ServiceMetadataUtils.getNodeElements(null, wmtsCapabilities, xPathAbstract);
    }

    public static Node getNode(XPath xPath, Node wmtsCapabilities, String xPathAbstract) throws XPathExpressionException {
        if (xPath == null) {
            xPath = ServiceMetadataUtils.createXPath();
        }
        return (Node)xPath.evaluate(xPathAbstract, wmtsCapabilities, XPathConstants.NODE);
    }

    public static Node getNode(Node wmtsCapabilities, String xPathAbstract) throws XPathExpressionException {
        return ServiceMetadataUtils.getNode(null, wmtsCapabilities, xPathAbstract);
    }

    public static String getNodeText(XPath xPath, Node wmtsCapabilities, String xPathAbstract) throws XPathExpressionException {
        if (xPath == null) {
            xPath = ServiceMetadataUtils.createXPath();
        }
        return (String)xPath.evaluate(xPathAbstract, wmtsCapabilities, XPathConstants.STRING);
    }

    public static String getNodeText(Node wmtsCapabilities, String xPathAbstract) throws XPathExpressionException {
        return ServiceMetadataUtils.getNodeText(null, wmtsCapabilities, xPathAbstract);
    }

    public static NodeList parseLayerChildElements(Document wmtsCapabilities, String layerName, String childElement) {
        if (!((String)childElement).startsWith("ows:") && !((String)childElement).startsWith("wmts:")) {
            childElement = "wmts:" + (String)childElement;
        }
        String xPathExpr = "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layerName + "']/" + (String)childElement;
        try {
            return ServiceMetadataUtils.getNodeElements(wmtsCapabilities, xPathExpr);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log((Level)Level.INFO, (String)ex.getMessage());
            return null;
        }
    }

    public static List<LayerInfo> parseLayerInfo(Document wmtsCapabilities) {
        ArrayList<LayerInfo> layerInfos = new ArrayList<LayerInfo>();
        XPath xPath = ServiceMetadataUtils.createXPath();
        try {
            NodeList layerNodes = ServiceMetadataUtils.parseLayers(xPath, wmtsCapabilities);
            for (int layerNodeIndex = 0; layerNodeIndex < layerNodes.getLength(); ++layerNodeIndex) {
                Node layerNode = layerNodes.item(layerNodeIndex);
                LayerInfo layerInfo = ServiceMetadataUtils.parseLayerInfo(xPath, layerNode);
                layerInfos.add(layerInfo);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing layer infos from doc. ", e);
        }
        return layerInfos;
    }

    public static NodeList parseLayers(XPath xPath, Document wmtsCapabilities) {
        try {
            return ServiceMetadataUtils.getNodeElements(xPath, wmtsCapabilities, "//wmts:Contents/wmts:Layer");
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error collecting layers from the Service Metadata Capabilities doc. ", xpe);
        }
    }

    public static NodeList parseLayers(Document wmtsCapabilities) {
        return ServiceMetadataUtils.parseLayers(ServiceMetadataUtils.createXPath(), wmtsCapabilities);
    }

    public static String parseNodeElementName(XPath xPath, Node nodeElement) throws XPathExpressionException {
        if (xPath == null) {
            xPath = ServiceMetadataUtils.createXPath();
        }
        String name = (String)xPath.evaluate("ows:Identifier", nodeElement, XPathConstants.STRING);
        return name.trim();
    }

    public static String parseNodeElementName(Node nodeElement) throws XPathExpressionException {
        return ServiceMetadataUtils.parseNodeElementName(ServiceMetadataUtils.createXPath(), nodeElement);
    }

    public static BoundingBox parseBoundingBox(Node bboxNode, boolean presumedWGS84) {
        XPath xPath = ServiceMetadataUtils.createXPath();
        String crsID = "";
        BoundingBox bbox = null;
        try {
            NodeList coordsList = bboxNode.getChildNodes();
            if (coordsList.getLength() > 0) {
                Node cornerCoordNode = (Node)xPath.evaluate("//ows:LowerCorner", bboxNode, XPathConstants.NODE);
                double[] lowerCoords = ServiceMetadataUtils.asDoublePair(bboxNode, cornerCoordNode.getNodeName(), xPath);
                cornerCoordNode = (Node)xPath.evaluate("//ows:UpperCorner", bboxNode, XPathConstants.NODE);
                double[] upperCoords = ServiceMetadataUtils.asDoublePair(bboxNode, cornerCoordNode.getNodeName(), xPath);
                String crsStr = ((String)xPath.evaluate("@crs", bboxNode, XPathConstants.STRING)).toUpperCase();
                if (presumedWGS84) {
                    crsID = "CRS:84";
                    if (crsStr.contains("EPSG:")) {
                        crsID = "EPSG:4326";
                    }
                } else {
                    if (crsStr.contains("EPSG:")) {
                        int indx = crsStr.indexOf("EPSG:");
                        crsID = crsStr.substring(indx).replace("::", ":");
                    } else if (crsStr.contains("CRS:")) {
                        int indx = crsStr.indexOf("CRS:");
                        crsID = crsStr.substring(indx).replace("::", ":");
                    }
                    Assert.assertFalse((boolean)crsID.equals(""), (String)("Unknown CRS: " + crsStr));
                }
                bbox = new BoundingBox(crsID, lowerCoords[0], lowerCoords[1], upperCoords[0], upperCoords[1]);
            }
            Assert.assertTrue((bbox != null ? 1 : 0) != 0, (String)String.format("Could not parse %s Bounding Box", crsID));
            return bbox;
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc while parsing geographic BBOX of layer. ", xpe);
        }
    }

    private static LayerInfo parseLayerInfo(XPath xPath, Node layerNode) throws XPathExpressionException, ParseException {
        String layerName = ServiceMetadataUtils.parseNodeElementName(xPath, layerNode);
        List<BoundingBox> bboxes = ServiceMetadataUtils.parseBoundingBoxes(xPath, layerNode);
        BoundingBox wgs84BBox = ServiceMetadataUtils.parseWGS84BoundingBox(xPath, layerNode);
        return new LayerInfo(layerName, bboxes, wgs84BBox);
    }

    private static List<BoundingBox> parseBoundingBoxes(XPath xPath, Node layerNode) throws XPathExpressionException {
        HashMap<String, BoundingBox> bboxes = new HashMap<String, BoundingBox>();
        String bboxesExpr = "ancestor-or-self::wmts:Layer/ows:BoundingBox";
        NodeList bboxNodes = ServiceMetadataUtils.getNodeElements(xPath, layerNode, bboxesExpr);
        for (int bboxNodeIndex = 0; bboxNodeIndex < bboxNodes.getLength(); ++bboxNodeIndex) {
            Node bboxNode = bboxNodes.item(bboxNodeIndex);
            BoundingBox bbox = ServiceMetadataUtils.parseBoundingBox(bboxNode, false);
            bboxes.put(bbox.getCrs(), bbox);
        }
        return new ArrayList<BoundingBox>(bboxes.values());
    }

    private static BoundingBox parseWGS84BoundingBox(XPath xPath, Node layerNode) throws XPathExpressionException {
        String bboxExpr = "ancestor-or-self::wmts:Layer/ows:WGS84BoundingBox";
        Node bboxNode = (Node)xPath.evaluate(bboxExpr, layerNode, XPathConstants.NODE);
        return ServiceMetadataUtils.parseBoundingBox(bboxNode, true);
    }

    private static double[] asDoublePair(Node node, String xPathExpr, XPath xPath) throws XPathExpressionException {
        String content = (String)xPath.evaluate(xPathExpr, node, XPathConstants.STRING);
        int indx = content.indexOf(32);
        if (indx < 0) {
            indx = content.indexOf(44);
        }
        String content0 = content.substring(0, indx);
        String content1 = content.substring(indx + 1);
        double[] pair = new double[]{Double.parseDouble(content0), Double.parseDouble(content1)};
        return pair;
    }

    private static boolean isOperationBindingSupported(Document wmtsMetadata, String opName, ProtocolBinding binding) {
        String exprTemplate = "count(/wmts:Capabilities/ows:OperationsMetadata/ows:Operation[@name='%s']/ows:DCP/ows:HTTP/ows:%s)";
        String xPathExpr = String.format(exprTemplate, opName, binding.getElementName());
        try {
            XPath xPath = ServiceMetadataUtils.createXPath();
            Double bindings = (Double)xPath.evaluate(xPathExpr, wmtsMetadata, XPathConstants.NUMBER);
            if (bindings > 0.0) {
                return true;
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
        return false;
    }

    private static URI createEndpoint(String href) {
        if (href == null || href.isEmpty()) {
            return null;
        }
        URI endpoint = URI.create(href);
        if (null != endpoint.getQuery()) {
            String uri = endpoint.toString();
            endpoint = URI.create(uri.substring(0, uri.indexOf(63)));
        }
        return endpoint;
    }

    private static XPath createXPath() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xPath;
    }
}

