/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.testsuite;

import org.opengeospatial.cite.wmts10.ets.core.assertion.WmtsAssertion;
import org.opengeospatial.cite.wmts10.ets.core.client.WmtsClient;
import org.opengeospatial.cite.wmts10.ets.core.domain.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Prerequisites {
    @Test
    public void verifyServiceDescription(ITestContext testContext) {
        Document wmtsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        WmtsAssertion.assertSimpleWMTSCapabilities(wmtsMetadata);
    }

    @Test(dependsOnMethods={"verifyServiceDescription"})
    public void serviceIsAvailable(ITestContext testContext) {
        Document wmtsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        WmtsClient wmtsClient = new WmtsClient(wmtsMetadata);
        Document capabilities = wmtsClient.getCapabilities();
        Assert.assertNotNull((Object)capabilities, (String)"No GetCapabilities response from SUT.");
        Element docElement = capabilities.getDocumentElement();
        Assert.assertEquals((String)docElement.getLocalName(), (String)"Capabilities", (String)"Capabilities document element has unexpected [local name].");
        Assert.assertEquals((String)docElement.getNamespaceURI(), (String)"http://www.opengis.net/wmts/1.0", (String)"Capabilities document element has unexpected [namespace name].");
    }
}

