/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.testsuite.gettile;

import de.latlon.ets.core.util.TestSuiteLogger;
import jakarta.ws.rs.core.Response;
import jakarta.xml.soap.SOAPMessage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tika.io.FilenameUtils;
import org.joda.time.DateTime;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.core.util.WmtsSoapContainer;
import org.opengeospatial.cite.wmts10.ets.core.util.request.WmtsKvpRequestBuilder;
import org.opengeospatial.cite.wmts10.ets.testsuite.AbstractBaseGetFixture;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractBaseGetTileFixture
extends AbstractBaseGetFixture {
    private final String MIME_FILENAME = "mime.types";
    private final String SUBDIRECTORY = "GetTileTests";
    private final String DISCRIMINATOR = DateTime.now().toString("yyyyMMddHHmm");
    private Path imageDirectory;

    @BeforeClass
    public void buildGetTileRequest() throws XPathExpressionException {
        this.reqEntity = WmtsKvpRequestBuilder.buildGetTileRequest(this.wmtsCapabilities, this.layerInfo);
    }

    @BeforeClass
    public void setResultDirectory(ITestContext testContext) {
        String outputDirectory = this.retrieveSessionDir(testContext);
        TestSuiteLogger.log((Level)Level.INFO, (String)("Directory to store GetTile responses: " + outputDirectory));
        try {
            Path resultDir = Paths.get(outputDirectory, new String[0]);
            this.imageDirectory = this.createDirectory(resultDir, "GetTileTests_" + this.DISCRIMINATOR);
        }
        catch (IOException e) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Could not create directory for GetTile response.", (Exception)e);
        }
    }

    @Test
    public void verifyGetTileSupported() {
        Node getTileEntry = null;
        try {
            getTileEntry = ServiceMetadataUtils.getNode(this.wmtsCapabilities, "//ows:OperationsMetadata/ows:Operation[@name = 'GetTile']");
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)getTileEntry, (String)"GetTile is not supported by this WMTS");
    }

    protected void storeResponseImage(Response rsp, String testGroup, String testName, String requestFormat) {
        if (this.imageDirectory == null) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Directory to store GetTile responses is not set. GetTile response is not written!");
            return;
        }
        this.writeIntoFile(rsp, testGroup, testName, requestFormat);
    }

    protected void storeSoapResponseImage(SOAPMessage soapResponse, String testGroup, String testName, String requestFormat) {
        if (this.imageDirectory == null) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Directory to store GetTile responses is not set. GetTile response is not written!");
            return;
        }
        this.writeIntoFile(soapResponse, testGroup, testName, requestFormat);
    }

    private void writeIntoFile(Response rsp, String testGroup, String testName, String requestFormat) {
        try {
            Path testClassDirectory = this.createDirectory(this.imageDirectory, testGroup);
            InputStream imageStream = (InputStream)rsp.readEntity(InputStream.class);
            Object fileExtension = this.detectFileExtension(requestFormat);
            if (fileExtension != null && !((String)fileExtension).startsWith(".")) {
                fileExtension = "." + (String)fileExtension;
            }
            String fileName = testName + (String)fileExtension;
            Path imageFile = testClassDirectory.resolve(FilenameUtils.normalize((String)fileName));
            Integer indx = -1;
            while (Files.exists(imageFile, LinkOption.NOFOLLOW_LINKS)) {
                indx = indx + 1;
                fileName = testName + indx.toString() + "." + (String)fileExtension;
                imageFile = testClassDirectory.resolve(FilenameUtils.normalize((String)fileName));
            }
            Files.copy(imageStream, imageFile, new CopyOption[0]);
        }
        catch (IOException ioe) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"IO:  Writing the GetTile response into file failed.", (Exception)ioe);
        }
    }

    private void writeIntoFile(SOAPMessage soapResponse, String testGroup, String testName, String requestFormat) {
        try {
            Path testClassDirectory = this.createDirectory(this.imageDirectory, testGroup);
            String fileExtension = this.detectFileExtension(requestFormat);
            if (fileExtension != null && fileExtension.startsWith(".")) {
                fileExtension = fileExtension.substring(1);
            }
            String fileName = testName + "." + fileExtension;
            Path imageFile = testClassDirectory.resolve(FilenameUtils.normalize((String)fileName));
            Integer indx = -1;
            while (Files.exists(imageFile, LinkOption.NOFOLLOW_LINKS)) {
                indx = indx + 1;
                fileName = testName + indx.toString() + "." + fileExtension;
                imageFile = testClassDirectory.resolve(FilenameUtils.normalize((String)fileName));
            }
            Document soapDocument = WmtsSoapContainer.makeResponseDocument(soapResponse);
            String imageString = ServiceMetadataUtils.getNodeText(soapDocument, "//wmts:BinaryPayload/wmts:BinaryContent");
            BufferedImage bufferedImage = null;
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] imageByte = decoder.decode(imageString);
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            bufferedImage = ImageIO.read(bis);
            bis.close();
            OutputStream imageOutputFile = Files.newOutputStream(imageFile, new OpenOption[0]);
            ImageIO.write((RenderedImage)bufferedImage, fileExtension, imageOutputFile);
            imageOutputFile.close();
        }
        catch (IOException ioe) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"IO:  Writing the GetTile response into file failed.", (Exception)ioe);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"SOAP converted document contains an error (no or corrupt BinaryContent)", (Exception)xpe);
        }
    }

    private String detectFileExtension(String requestFormat) {
        String extension = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("mime.types"), "UTF-8"));
            String mimeLine = null;
            do {
                if ((mimeLine = br.readLine()) == null || mimeLine.indexOf(58) <= 0) continue;
                int indx = mimeLine.indexOf(58);
                String mime = mimeLine.substring(0, indx);
                String m_ext = mimeLine.substring(indx + 1);
                if (!mime.equalsIgnoreCase(requestFormat)) continue;
                extension = m_ext;
            } while (mimeLine != null && extension == null);
            br.close();
        }
        catch (IOException e) {
            TestSuiteLogger.log((Level)Level.WARNING, (String)"Cannot find MIME Types.", (Exception)e);
        }
        return extension;
    }

    private Path createDirectory(Path parent, String child) throws IOException {
        Path testClassDirectory = parent.resolve(child);
        Files.createDirectories(testClassDirectory, new FileAttribute[0]);
        return testClassDirectory;
    }

    private String retrieveSessionDir(ITestContext testContext) {
        File outputDir = new File(testContext.getOutputDirectory());
        return outputDir.getPath();
    }

    private void parseNodes(Node n, int level) {
        if (n != null) {
            Object nam = n.getNodeName();
            String val = n.getNodeValue();
            String lnm = n.getLocalName();
            if (!((String)nam).contains(":") && !((String)nam).startsWith("#")) {
                String namespaceURI = n.getNamespaceURI();
                if (namespaceURI.contains("soap")) {
                    nam = "soap:" + (String)nam;
                } else if (namespaceURI.contains("ows")) {
                    nam = "ows:" + (String)nam;
                } else if (namespaceURI.contains("wmts")) {
                    nam = "wmts:" + (String)nam;
                }
            }
            for (int i = 0; i < level; ++i) {
                System.out.print("\t");
            }
            System.out.println("Node: " + (String)nam + " = " + val);
            this.parseNodes(n.getFirstChild(), level + 1);
            this.parseNodes(n.getNextSibling(), level);
        }
    }
}

