/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.error.ErrorMessage;
import de.latlon.ets.core.error.ErrorMessageKey;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class GetCapabilitiesKvpVersionTest
extends AbstractBaseGetCapabilitiesFixture {
    private URI getCapabilitiesURI;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 15", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsGetCapabilitiesURLExists() {
        this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        Assert.assertTrue((this.getCapabilitiesURI != null ? 1 : 0) != 0, (String)"GetCapabilities (GET) endpoint not found or KVP is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 15", dependsOnMethods={"wmtsGetCapabilitiesURLExists"})
    public void wmtsCapabilitiesVersionTest() {
        Object versionManipulation = "1.0.0";
        versionManipulation = 1 + Integer.parseInt(((String)versionManipulation).substring(0, 1)) + ((String)versionManipulation).substring(1);
        Assert.assertFalse((boolean)this.verifyVersionResponse((String)versionManipulation), (String)("WMTS did not handle an invalid version ('" + (String)versionManipulation + "') correctly"));
        versionManipulation = "0.0.1";
        Assert.assertFalse((boolean)this.verifyVersionResponse((String)versionManipulation), (String)("WMTS did not handle an invalid version ('" + (String)versionManipulation + "') correctly"));
        Assert.assertTrue((boolean)this.verifyVersionResponse("1.0.0"), (String)"This WMTS does not accept the current version ('1.0.0')");
    }

    private boolean verifyVersionResponse(String version) {
        boolean result = false;
        if (this.getCapabilitiesURI == null) {
            this.getCapabilitiesURI = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        }
        this.reqEntity.removeKvp("AcceptVersions");
        this.reqEntity.addKvp("AcceptVersions", version);
        Response rsp = this.wmtsClient.submitRequest(this.reqEntity, this.getCapabilitiesURI);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get((ErrorMessageKey)ErrorMessageKey.MISSING_XML_ENTITY));
        this.rspEntity = (Document)rsp.readEntity(Document.class);
        result = rsp.getStatus() == 200;
        return result;
    }
}

