/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.opengeospatial.cite.wmts10.ets.core.domain.BoundingBox;
import org.opengeospatial.cite.wmts10.ets.core.domain.LayerInfo;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.opengeospatial.cite.wmts10.nsg.core.util.NSG_CRSUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesProjectionTest
extends AbstractBaseGetCapabilitiesFixture {
    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 12", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesExists() {
        Assert.assertTrue((this.wmtsCapabilities != null ? 1 : 0) != 0, (String)"No ServerMetadata Capabilities document");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 12", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesEPSG3395Test() {
        this.assessAdvertisedProjections("EPSG:3395", "World Mercator Projection", -1.54965707397E7, 1.87646562314E7, -84.0, 80.0);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 12", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesUPS_NorthTest() {
        this.assessAdvertisedProjections("EPSG:5041", "WGS 84 / UPS North", -1.4440759350252E7, 1.8440759350252E7, 60.0, 90.0);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 12", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesUPS_SouthTest() {
        this.assessAdvertisedProjections("EPSG:5042", "WGS 84 / UPS South", -1.4440759350252E7, 1.8440759350252E7, -90.0, -60.0);
    }

    private void assessAdvertisedProjections(String crsName2Look4, String crsFullName, double crsMin, double crsMax, double latMin, double latMax) {
        try {
            boolean crsFound;
            String parsedCrs = NSG_CRSUtils.normaliseCrsName(crsName2Look4);
            boolean hasLayerInRange = crsFound = this.isCrsFound(parsedCrs);
            boolean isAdvertised = crsFound;
            if (!crsFound) {
                for (int layerI = 0; layerI < this.layerInfo.size() && !crsFound; ++layerI) {
                    LayerInfo layer = (LayerInfo)this.layerInfo.get(layerI);
                    List<BoundingBox> bbox = layer.getBboxes();
                    for (int bboxI = -1; bboxI < bbox.size() && !crsFound; ++bboxI) {
                        boolean insideLimits = false;
                        String crsName = null;
                        if (bboxI < 0) {
                            crsName = layer.getGeographicBbox().getCrs();
                            minLat = layer.getGeographicBbox().getMinY();
                            maxLat = layer.getGeographicBbox().getMaxY();
                            insideLimits = minLat >= latMin && minLat <= latMax || maxLat >= latMin && maxLat <= latMax;
                        } else {
                            crsName = bbox.get(bboxI).getCrs();
                            minLat = bbox.get(bboxI).getMinY();
                            maxLat = bbox.get(bboxI).getMaxY();
                            boolean bl = insideLimits = minLat >= crsMin && minLat <= crsMax || maxLat >= crsMin && maxLat <= crsMax;
                        }
                        if (!insideLimits) continue;
                        hasLayerInRange = true;
                        crsFound = crsName.contains(parsedCrs);
                    }
                }
            }
            if (!hasLayerInRange && isAdvertised) {
                throw new SkipException("WMTS does not have a Layer within range of " + parsedCrs + " (" + crsFullName + ")");
            }
            Assert.assertTrue((crsFound && isAdvertised ? 1 : 0) != 0, (String)("WMTS does not support " + parsedCrs + " (" + crsFullName + ") in any of its <Layer>s or <TileMatrixSet>s."));
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    private boolean isCrsFound(String crsName2Look4) throws XPathExpressionException {
        boolean crsFound = false;
        NodeList crsList = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//ows:SupportedCRS");
        for (int crsI = 0; crsI < crsList.getLength() && !crsFound; ++crsI) {
            Node supportedCRS = crsList.item(crsI);
            String crsName = NSG_CRSUtils.normaliseCrsName(supportedCRS.getTextContent());
            crsFound = crsName.contains(crsName2Look4);
        }
        return crsFound;
    }
}

