/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.opengeospatial.cite.wmts10.nsg.core.util.NSG_CRSUtils;
import org.opengeospatial.cite.wmts10.nsg.core.util.NSG_XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCapabilitiesWellKnownScaleTest
extends AbstractBaseGetCapabilitiesFixture {
    private static final String ANNEX_B1_3395_TABLE = "Annex_B1_EPSG3395.xml";
    private static final String ANNEX_B2_4326_TABLE = "Annex_B2_EPSG4326.xml";
    private static final String NSG_WMTS_EPSG_5041 = "NSG_WMTS_EPSG_5041.xml";
    private static final String NSG_WMTS_EPSG_5042 = "NSG_WMTS_EPSG_5042.xml";

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 13", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesExists() {
        Assert.assertTrue((this.wmtsCapabilities != null ? 1 : 0) != 0, (String)"No ServerMetadata Capabilities document");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 13, Annex B.1", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesWellKnownScaleTest_3395_Test() throws IOException, XPathExpressionException {
        String wellKnownScaleSet = "EPSG:3395";
        NodeList listFromAnnexB = this.parseAnnex(ANNEX_B1_3395_TABLE, wellKnownScaleSet);
        this.testWellKnownScale(wellKnownScaleSet, listFromAnnexB);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 13, Annex B.2", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesWellKnownScaleTest_4326_Test() throws IOException, XPathExpressionException {
        String wellKnownScaleSet = "EPSG:4326";
        NodeList listFromAnnexB = this.parseAnnex(ANNEX_B2_4326_TABLE, wellKnownScaleSet);
        this.testWellKnownScale(wellKnownScaleSet, listFromAnnexB);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 13, Annex B.3", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesWellKnownScaleTest_5041_Test() throws IOException, XPathExpressionException {
        String wellKnownScaleSet = "EPSG:5041";
        NodeList listFromAnnexB = this.parseAnnex(NSG_WMTS_EPSG_5041, wellKnownScaleSet);
        this.testWellKnownScale(wellKnownScaleSet, listFromAnnexB);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 13, Annex B.3", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesWellKnownScaleTest_5042_Test() throws IOException, XPathExpressionException {
        String wellKnownScaleSet = "EPSG:5042";
        NodeList listFromAnnexB = this.parseAnnex(NSG_WMTS_EPSG_5042, wellKnownScaleSet);
        this.testWellKnownScale(wellKnownScaleSet, listFromAnnexB);
    }

    private void testWellKnownScale(String wellKnownScaleSet, NodeList listFromAnnexB) throws XPathExpressionException {
        NodeList tileMatrixSetList;
        List<Element> tileMatrixSetsWithCrs = this.retrieveTileMatrixSetsWithSupportedCrs(wellKnownScaleSet = NSG_CRSUtils.normaliseCrsName(wellKnownScaleSet), tileMatrixSetList = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:TileMatrixSet"));
        Assert.assertTrue((tileMatrixSetsWithCrs.size() > 0 ? 1 : 0) != 0, (String)("Well-Known Scale Set for " + wellKnownScaleSet + " is not advertised in WMTS"));
        boolean isAtLeastOneTileMatrixSetWithCrsWellKnown = this.isAtLeastOneTileMatrixSetWithCrsWellKnown(listFromAnnexB, tileMatrixSetsWithCrs);
        Assert.assertTrue((boolean)isAtLeastOneTileMatrixSetWithCrsWellKnown, (String)("Scale Set for " + wellKnownScaleSet + " is advertised in WMTS but not Well-Known"));
    }

    private List<Element> retrieveTileMatrixSetsWithSupportedCrs(String wellKnownScaleSet, NodeList tileMatrixSetList) {
        ArrayList<Element> tileMatrixSetsWithSupportedCrs = new ArrayList<Element>();
        for (int tmsI = 0; tmsI < tileMatrixSetList.getLength(); ++tmsI) {
            Element tileMatrixSet = (Element)tileMatrixSetList.item(tmsI);
            String crsName = NSG_XMLUtils.getXMLElementTextValue(tileMatrixSet, "ows:SupportedCRS");
            if (!(crsName = NSG_CRSUtils.normaliseCrsName(crsName)).contains(wellKnownScaleSet)) continue;
            tileMatrixSetsWithSupportedCrs.add(tileMatrixSet);
        }
        return tileMatrixSetsWithSupportedCrs;
    }

    private boolean isAtLeastOneTileMatrixSetWithCrsWellKnown(NodeList listFromAnnexB, List<Element> tileMatrixSetsWithCrs) {
        for (Element tileMatrixSet : tileMatrixSetsWithCrs) {
            boolean tileMatrixSetWellKnown = this.isTileMatrixSetWellKnown(listFromAnnexB, tileMatrixSet);
            if (!tileMatrixSetWellKnown) continue;
            return true;
        }
        return false;
    }

    private boolean isTileMatrixSetWellKnown(NodeList listFromAnnexB, Element tileMatrixSet) {
        NodeList tileMatrixes = tileMatrixSet.getElementsByTagName("TileMatrix");
        if (listFromAnnexB.getLength() < tileMatrixes.getLength()) {
            return false;
        }
        for (int tmI = 0; tmI < tileMatrixes.getLength(); ++tmI) {
            boolean tileMatrixWellKnown = this.isTileMatrixWellKnown(listFromAnnexB, tileMatrixes, tmI);
            if (tileMatrixWellKnown) continue;
            return false;
        }
        return true;
    }

    private boolean isTileMatrixWellKnown(NodeList listFromAnnexB, NodeList tileMatrixes, int currentTileMatrix) {
        Element annexNode = (Element)listFromAnnexB.item(currentTileMatrix);
        Element node_tms = (Element)tileMatrixes.item(currentTileMatrix);
        boolean scaleDenominatorCorrect = this.isScaleDenominatorCorrect(annexNode, node_tms);
        boolean tileDimensionsCorrect = this.isTileDimensionsCorrect(annexNode, node_tms);
        boolean matrixDimensionsCorrect = this.isMatrixDimensionsCorrect(annexNode, node_tms);
        return scaleDenominatorCorrect && tileDimensionsCorrect && matrixDimensionsCorrect;
    }

    private boolean isScaleDenominatorCorrect(Element annexNode, Element node_tms) {
        double scaleDenominator;
        String scaleDemon = NSG_XMLUtils.getXMLElementTextValue(annexNode, "ScaleDenominator");
        double tolerance = this.determineTolerance(scaleDemon);
        double scaleDenominator4326 = Double.parseDouble(scaleDemon);
        return Math.abs(scaleDenominator4326 - (scaleDenominator = Double.parseDouble(NSG_XMLUtils.getXMLElementTextValue(node_tms, "ScaleDenominator")))) <= tolerance;
    }

    private boolean isTileDimensionsCorrect(Element annexNode, Element node_tms) {
        int annexTileWidth = this.parseAsInt(annexNode, "TileWidth");
        int annexTileHeight = this.parseAsInt(annexNode, "TileHeight");
        int tileWidth = this.parseAsInt(node_tms, "TileWidth");
        int tileHeight = this.parseAsInt(node_tms, "TileHeight");
        return tileWidth == annexTileWidth && tileHeight == annexTileHeight && tileWidth == tileHeight;
    }

    private boolean isMatrixDimensionsCorrect(Element annexNode, Element node_tms) {
        int annexMatrixWidth = this.parseAsInt(annexNode, "MatrixWidth");
        int annexMatrixHeight = this.parseAsInt(annexNode, "MatrixHeight");
        int matrixWidth = this.parseAsInt(node_tms, "MatrixWidth");
        int matrixHeight = this.parseAsInt(node_tms, "MatrixHeight");
        return matrixWidth == annexMatrixWidth && matrixHeight == annexMatrixHeight;
    }

    private double determineTolerance(String scaleDemon) {
        BigDecimal bigNum = new BigDecimal(scaleDemon);
        if (bigNum.scale() <= 0) {
            return 0.0;
        }
        return Math.pow(10.0, -(bigNum.scale() - 2));
    }

    private int parseAsInt(Element elementNode, String tagName) {
        return Integer.parseInt(NSG_XMLUtils.getXMLElementTextValue(elementNode, tagName));
    }

    private NodeList parseAnnex(String resource, String wellKnownScaleSet) throws IOException {
        NodeList listFromAnnexB = NSG_XMLUtils.openXMLDocument(this.getClass().getResourceAsStream(resource), "TileMatrix");
        if (listFromAnnexB == null || listFromAnnexB.getLength() == 0) {
            throw new IOException("Required external file of " + wellKnownScaleSet + " values is not accessible");
        }
        return listFromAnnexB;
    }
}

