/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.pfl.tf.spi.Util;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class SimpleMethodTracer
extends MethodVisitor {
    final Util util;
    final Set<Label> visitedLables = new HashSet<Label>();

    private void msg(String str) {
        this.util.info(2, "---" + str);
    }

    public SimpleMethodTracer(MethodVisitor mv, Util util) {
        super(458752, mv);
        this.util = util;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.msg("visitAnnotationDefault");
        return this.mv.visitAnnotationDefault();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.msg("visitAnnotation(desc=" + desc + ",visible=" + visible + ")");
        return this.mv.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.msg("visitParameterAnnotation(parameter=" + parameter + ".desc=" + desc + ",visible=" + visible + ")");
        return this.mv.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        this.msg("visitAttribute(attr=" + String.valueOf(attr) + ")");
        this.mv.visitAttribute(attr);
    }

    public void visitCode() {
        this.msg("visitCode");
        this.mv.visitCode();
    }

    private String getFrameType(int type) {
        switch (type) {
            case 1: {
                return "APPEND";
            }
            case 2: {
                return "CHOP";
            }
            case 0: {
                return "FULL";
            }
            case -1: {
                return "NEW";
            }
            case 3: {
                return "SAME";
            }
            case 4: {
                return "SAME1";
            }
        }
        return "BAD_FRAME_TYPE";
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.msg("visitFrame(type=" + this.getFrameType(type) + ",nLocal=" + nLocal + ",local=" + String.valueOf(Arrays.asList(local)) + ",nStack=" + nStack + ",stack=" + String.valueOf(Arrays.asList(stack)) + ")");
        this.mv.visitFrame(type, nLocal, local, nStack, stack);
    }

    public void visitInsn(int opcode) {
        this.msg("visitInsn(opcode=" + Util.opcodeToString(opcode) + ")");
        this.mv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.msg("visitIntInsn(opcode=" + Util.opcodeToString(opcode) + ",operand=" + operand + ")");
        this.mv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.msg("visitVarInsn(opcode=" + Util.opcodeToString(opcode) + ",var=" + var + ")");
        this.mv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.msg("visitTypeInsn(opcode=" + Util.opcodeToString(opcode) + ",type=" + type + ")");
        this.mv.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.msg("visitFieldInsn(opcode=" + Util.opcodeToString(opcode) + ",owner=" + owner + ",name=" + name + ",desc=" + desc + ")");
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.msg("visitMethodInsn(opcode=" + Util.opcodeToString(opcode) + ",owner=" + owner + ",name=" + name + ",desc=" + desc + ")");
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.msg("visitJumpInsn(opcode=" + Util.opcodeToString(opcode) + ",label=" + String.valueOf(label) + ")");
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.msg("visitLabel(label=" + String.valueOf(label) + ")");
        this.visitedLables.add(label);
        this.mv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.msg("visitLdcInsn(cst=" + String.valueOf(cst) + ")");
        this.mv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.msg("visitIincInsn(var=" + var + ",increment=" + increment + ")");
        this.mv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.msg("visitTableSwitchInsn");
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.msg("visitLookupSwitchInsn");
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.msg("visitMultiANewArrayInsn(desc=" + desc + ",dims=" + dims + ")");
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.msg("visitTryCatchBlock(start=" + String.valueOf(start) + ",end=" + String.valueOf(end) + ",handler=" + String.valueOf(handler) + ",type=" + type + ")");
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (!this.visitedLables.contains(start)) {
            throw new RuntimeException("visitLocalVariable: start label has not been visited");
        }
        if (!this.visitedLables.contains(end)) {
            throw new RuntimeException("visitLocalVariable: end label has not been visited");
        }
        this.msg("visitLocalVariable(name=" + name + ",desc=" + desc + ",signature=" + signature + ",start=" + String.valueOf(start) + ",end=" + String.valueOf(end) + ",index=" + index + ")");
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.msg("visitLineNumber(line=" + line + ",start=" + String.valueOf(start) + ")");
        this.mv.visitLineNumber(line, start);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.msg("visitMaxs(maxStack=" + maxStack + ",maxLocals=" + maxLocals + ")");
        this.mv.visitMaxs(maxStack, maxLocals);
    }

    public void visitEnd() {
        this.msg("visitEnd");
        this.mv.visitEnd();
    }
}

