/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class XMLUtils {
    private static final Logger LOGR = Logger.getLogger(XMLUtils.class.getPackage().getName());

    private XMLUtils() {
    }

    public static String writeNodeToString(Node node) {
        if (null == node) {
            throw new IllegalArgumentException("Supplied node is null.");
        }
        StringWriter writer = new StringWriter();
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            idTransformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (TransformerException ex) {
            LOGR.log(Level.WARNING, "Failed to serialize DOM node: " + node.getNodeName(), ex);
        }
        return writer.toString();
    }

    public static void writeNode(Node node, OutputStream outputStream) {
        if (null == node) {
            throw new IllegalArgumentException("Supplied node is null.");
        }
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("method", "xml");
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            idTransformer.transform(new DOMSource(node), new StreamResult(outputStream));
        }
        catch (TransformerException ex) {
            String nodeName = node.getNodeType() == 9 ? ((Document)Document.class.cast(node)).getDocumentElement().getNodeName() : node.getNodeName();
            LOGR.log(Level.WARNING, "Failed to serialize DOM node: " + nodeName, ex);
        }
    }

    public static String transformToString(Source source) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap((Object)domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem((XdmItem)node);
        return xpath.evaluate();
    }

    public static String resultToString(Result result) {
        if (null == result) {
            throw new IllegalArgumentException("Result is null.");
        }
        StringWriter writer = new StringWriter();
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)DOMResult.class.cast(result)).getNode();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            try {
                Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
                idTransformer.setOutputProperties(outProps);
                idTransformer.transform(new DOMSource(node), new StreamResult(writer));
            }
            catch (TransformerException | TransformerFactoryConfigurationError e) {
                LOGR.warning(e.getMessage());
            }
        } else if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)StreamResult.class.cast(result);
            OutputStream os = streamResult.getOutputStream();
            if (null != os) {
                writer.write(os.toString());
            } else {
                Path path = Paths.get(URI.create(streamResult.getSystemId()));
                try {
                    byte[] data = Files.readAllBytes(path);
                    writer.write(new String(data));
                }
                catch (IOException e) {
                    LOGR.warning(e.getMessage());
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported Result type:" + result.getClass());
        }
        return writer.toString();
    }
}

