/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.client;

import de.latlon.ets.core.util.XMLUtils;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import org.apache.tika.io.FilenameUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.opengeospatial.cite.wmts10.ets.core.client.WmtsKvpRequest;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.SOAPMessageConsumer;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.w3c.dom.Document;

public class WmtsClient {
    private static final Logger LOGR = Logger.getLogger(WmtsClient.class.getPackage().getName());
    private Client client;
    private Document wmtsCapabilities;

    public WmtsClient(Document wmtsCapabilities) {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.followRedirects", (Object)true);
        config.property("jersey.config.client.connectTimeout", (Object)10000);
        config.register((Object)new LoggingFeature(LOGR, Level.ALL, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(5000)));
        config.register(SOAPMessageConsumer.class);
        this.client = ClientBuilder.newClient((Configuration)config);
        this.wmtsCapabilities = wmtsCapabilities;
    }

    public Document getCapabilities() {
        if (null == this.wmtsCapabilities) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint_KVP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.GET);
        if (null == endpoint) {
            throw new RuntimeException("GetCapabilities (GET) endpoint not found in capabilities document.");
        }
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        queryParams.add((Object)"Request", (Object)"GetCapabilities");
        queryParams.add((Object)"Service", (Object)"WMTS");
        queryParams.add((Object)"Version", (Object)"1.0.0");
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)endpoint);
        if (null != queryParams) {
            for (Map.Entry param : queryParams.entrySet()) {
                uriBuilder.queryParam((String)param.getKey(), new Object[]{((List)param.getValue()).get(0)});
            }
        }
        URI uri = uriBuilder.build(new Object[0]);
        WebTarget target = this.client.target(uri);
        Invocation.Builder reqBuilder = target.request();
        return (Document)reqBuilder.buildGet().invoke().readEntity(Document.class);
    }

    public Response submitRequest(WmtsKvpRequest request, URI endpoint) {
        WebTarget target = this.client.target(endpoint);
        return this.submitGetRequest(target, request);
    }

    private Response submitPostRequest(WebTarget target, Source payload) {
        LOGR.log(Level.FINE, String.format("Submitting POST request to URI %s", target.getUri()));
        LOGR.log(Level.FINE, String.format("Request Payload: %s", XMLUtils.transformToString((Source)payload)));
        Response response = null;
        try {
            response = target.request(new String[]{"application/soap+xml"}).buildPost(Entity.entity((Object)payload, (String)"application/soap+xml")).invoke();
            if (LOGR.isLoggable(Level.FINE)) {
                LOGR.log(Level.FINE, String.format("SOAP Response: %s", FilenameUtils.normalize((String)response.toString())));
            }
        }
        catch (ProcessingException ex) {
            LOGR.log(Level.SEVERE, "Failed to process SOAP request/response: " + target.getUri(), ex);
        }
        return response;
    }

    private Response submitGetRequest(WebTarget target, WmtsKvpRequest requestParameter) {
        LOGR.log(Level.FINE, String.format("Submitting GET request to URI %s", target.getUri()));
        String queryString = requestParameter.asQueryString();
        URI requestURI = UriBuilder.fromUri((URI)target.getUri()).replaceQuery(queryString).build(new Object[0]);
        LOGR.log(Level.FINE, String.format("Request URI: %s", requestURI));
        target = this.client.target(requestURI);
        Invocation.Builder reqBuilder = target.request();
        Invocation req = reqBuilder.buildGet();
        return req.invoke();
    }
}

