/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.ets.core.util;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPConnection;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class WmtsSoapContainer {
    private static final Logger LOGR = Logger.getLogger(WmtsSoapContainer.class.getName());
    private final String soapURL;
    private final String callFunction;
    private SOAPMessage soapMessage;
    private SOAPEnvelope soapMessageEnvelope;
    private SOAPBody soapMessageBody;
    private SOAPPart soapMessagePart;
    private SOAPElement soapMessageElement;
    private SOAPElement soapMessageElementParent;
    private SOAPMessage soapResponse;
    private Document responseDocument;

    public WmtsSoapContainer(String function, String soap_URL) {
        this.callFunction = function;
        this.soapURL = soap_URL;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
            this.soapMessage = messageFactory.createMessage();
            MimeHeaders headers = this.soapMessage.getMimeHeaders();
            headers.addHeader("SOAPAction", this.soapURL + "/" + this.callFunction);
            this.soapMessagePart = this.soapMessage.getSOAPPart();
            this.soapMessageEnvelope = this.soapMessagePart.getEnvelope();
            this.soapMessageBody = this.soapMessageEnvelope.getBody();
            QName qnElem = new QName("http://www.opengis.net/wmts/1.0", this.callFunction);
            this.soapMessageElement = this.soapMessageBody.addChildElement(qnElem);
            this.addWmtsAttribute("Service", "WMTS");
            if (!this.callFunction.equals("GetCapabilities")) {
                this.addWmtsAttribute("Version", "1.0.0");
            }
            this.addNamespace("ows", "http://www.opengis.net/ows/1.1");
            if (this.callFunction.equals("GetFeatureInfo")) {
                this.soapMessageElementParent = this.soapMessageElement;
                QName qnTileElem = new QName("http://www.opengis.net/wmts/1.0", "GetTile");
                this.soapMessageElement = this.soapMessageElementParent.addChildElement(qnTileElem);
                this.addWmtsAttribute("Service", "WMTS");
                this.addWmtsAttribute("Version", "1.0.0");
                this.addNamespace("ows", "http://www.opengis.net/ows/1.1");
            }
        }
        catch (SOAPException se) {
            LOGR.log(Level.SEVERE, "Error adding SOAP Namespace identifier", se);
            Assert.assertTrue((boolean)false, (String)("Error adding SOAP Namespace identifier:  " + se.getMessage()));
        }
    }

    public void addWmtsAttribute(String attribute, String value) {
        if (this.soapMessageElement != null) {
            try {
                QName qAttr = new QName("http://www.opengis.net/wmts/1.0", attribute.toLowerCase());
                this.soapMessageElement.addAttribute(qAttr, value);
            }
            catch (SOAPException se) {
                LOGR.log(Level.SEVERE, "Error adding SOAP Namespace identifier", se);
                Assert.assertTrue((boolean)false, (String)("Error adding SOAP Namesapce identifier:  " + se.getMessage()));
            }
        }
    }

    public void addNamespace(String namespace, String namespaceURL) {
        if (this.soapMessageElement != null) {
            try {
                this.soapMessageElement.addNamespaceDeclaration(namespace, namespaceURL);
            }
            catch (SOAPException se) {
                LOGR.log(Level.SEVERE, "Error adding SOAP Namespace identifier", se);
                Assert.assertTrue((boolean)false, (String)("Error adding SOAP Namesapce identifier:  " + se.getMessage()));
            }
        }
    }

    public void addParameter(String namespace, String parameterName, String value) {
        if (this.soapMessageElement != null) {
            try {
                SOAPElement element = this.soapMessageElement;
                if (this.callFunction.equals("GetFeatureInfo") && this.soapMessageElementParent != null && (parameterName.equals("I") || parameterName.equals("J") || parameterName.equals("InfoFormat"))) {
                    element = this.soapMessageElementParent;
                }
                SOAPElement childElement = element.addChildElement(parameterName, namespace);
                childElement.addTextNode(value);
            }
            catch (SOAPException se) {
                LOGR.log(Level.SEVERE, "Error adding SOAP Parameter", se);
                Assert.assertTrue((boolean)false, (String)("Error adding SOAP Parameter:  " + se.getMessage()));
            }
        }
    }

    public void addParameterWithChild(String namespace, String parameterName, String childParameterName, String value) {
        if (this.soapMessageElement != null) {
            try {
                SOAPElement childElement = this.soapMessageElement.addChildElement(parameterName, namespace);
                SOAPElement childChildElement = childElement.addChildElement(childParameterName, namespace);
                childChildElement.addTextNode(value);
            }
            catch (SOAPException se) {
                LOGR.log(Level.SEVERE, "Error adding SOAP Parameter", se);
                Assert.assertTrue((boolean)false, (String)("Error adding SOAP Parameter:  " + se.getMessage()));
            }
        }
    }

    public SOAPMessage getSoapResponse(boolean trapSoapErrors) {
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            this.finalizeSoapMessage();
            this.logSoapMessage();
            this.soapResponse = soapConnection.call(this.soapMessage, (Object)this.soapURL);
            soapConnection.close();
            this.responseDocument = WmtsSoapContainer.makeResponseDocument(this.soapResponse);
            NodeList anyResponseExceptions = ServiceMetadataUtils.getNodeElements(this.responseDocument, "//ows:ExceptionText");
            if (anyResponseExceptions != null && anyResponseExceptions.getLength() > 0) {
                Object exceptionText = "";
                for (int i = 0; i < anyResponseExceptions.getLength(); ++i) {
                    exceptionText = (String)exceptionText + anyResponseExceptions.item(i).getTextContent().trim() + ";  ";
                }
                throw new SOAPException((String)exceptionText);
            }
            this.logSoapResponse();
        }
        catch (SOAPException se) {
            if (trapSoapErrors) {
                LOGR.log(Level.SEVERE, "Error with SOAP Response:  ", se);
                Assert.assertTrue((boolean)false, (String)("Error with SOAP Response" + se.getMessage()));
            }
        }
        catch (XPathExpressionException xe) {
            LOGR.log(Level.SEVERE, "Error processing SOAP exception message", xe);
            Assert.assertTrue((boolean)false, (String)("Error processing SOAP exception message:  " + xe.getMessage()));
        }
        return this.soapResponse;
    }

    public Document getResponseDocument() {
        return this.responseDocument;
    }

    public static Document makeResponseDocument(SOAPMessage soapResponse) {
        Document soapDocument = null;
        if (soapResponse == null) {
            return null;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Source sourceContent = soapResponse.getSOAPPart().getContent();
            DOMResult result = new DOMResult();
            transformer.transform(sourceContent, result);
            soapDocument = (Document)result.getNode();
        }
        catch (SOAPException se) {
            LOGR.log(Level.SEVERE, "Converting SOAP message to document", se);
            Assert.assertTrue((boolean)false, (String)("Converting SOAP message to document Error = " + se.getMessage()));
        }
        catch (TransformerException te) {
            LOGR.log(Level.SEVERE, "Transforming SOAP message to document", te);
            Assert.assertTrue((boolean)false, (String)("Transforming SOAP message to document error = " + te.getMessage()));
        }
        return soapDocument;
    }

    private void finalizeSoapMessage() {
        try {
            SOAPHeader header = this.soapMessage.getSOAPHeader();
            SOAPFault fault = this.soapMessageBody.getFault();
            this.soapMessageEnvelope.removeNamespaceDeclaration(this.soapMessageEnvelope.getPrefix());
            this.soapMessageEnvelope.addNamespaceDeclaration("soap", "http://www.w3.org/2003/05/soap-envelope");
            this.soapMessageEnvelope.setPrefix("soap");
            header.setPrefix("soap");
            this.soapMessageBody.setPrefix("soap");
            if (fault != null) {
                fault.setPrefix("soap");
            }
            this.soapMessage.saveChanges();
        }
        catch (SOAPException se) {
            LOGR.log(Level.SEVERE, "Completing SOAP message construct", se);
            Assert.assertTrue((boolean)false, (String)("Completing SOAP message construct Error = " + se.getMessage()));
        }
    }

    private void logSoapResponse() {
        try {
            if (Level.SEVERE.equals(LOGR.getLevel())) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                Source sourceContent = this.soapResponse.getSOAPPart().getContent();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(bos);
                transformer.transform(sourceContent, result);
                bos.close();
                LOGR.log(Level.SEVERE, "Response SOAP message ", bos.toString());
            }
        }
        catch (TransformerException te) {
            LOGR.log(Level.WARNING, "Transforming Error when printing SOAP response for logging", te);
        }
        catch (SOAPException se) {
            LOGR.log(Level.WARNING, "Error when printing SOAP response for logging", se);
        }
        catch (IOException ioe) {
            LOGR.log(Level.WARNING, "Error when printing SOAP response for logging", ioe);
        }
    }

    private void logSoapMessage() {
        try {
            if (Level.SEVERE.equals(LOGR.getLevel())) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.soapMessage.writeTo((OutputStream)bos);
                bos.close();
                LOGR.log(Level.SEVERE, "Request SOAP message ", bos.toString());
            }
        }
        catch (SOAPException se) {
            LOGR.log(Level.WARNING, "Error when printing SOAP message for logging", se);
        }
        catch (IOException ioe) {
            LOGR.log(Level.WARNING, "Error when printing SOAP message for logging", ioe);
        }
    }
}

