/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import jakarta.xml.soap.SOAPMessage;
import java.net.URI;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.core.util.WmtsSoapContainer;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetCapabilitiesSoap
extends AbstractBaseGetCapabilitiesFixture {
    private URI soapURI;

    GetCapabilitiesSoap() {
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 3", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesSoapSupported() {
        this.soapURI = ServiceMetadataUtils.getOperationEndpoint_SOAP(this.wmtsCapabilities, "GetCapabilities", ProtocolBinding.POST);
        if (this.soapURI == null) {
            throw new SkipException("GetCapabilities (POST) endpoint not found in ServiceMetadata capabilities document or WMTS does not support SOAP.");
        }
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 3", dependsOnMethods={"wmtsCapabilitiesSoapSupported"})
    public void wmtsCapabilitiesSoapReponseTest() {
        Assert.assertTrue((this.soapURI != null ? 1 : 0) != 0, (String)"There is no SOAP URL to test against");
        String soapURIstr = this.soapURI.toString();
        ETSAssert.assertUrl((String)soapURIstr);
        WmtsSoapContainer soap = new WmtsSoapContainer("GetCapabilities", soapURIstr);
        soap.addParameterWithChild("ows", "AcceptVersions", "Version", "1.0.0");
        soap.addParameterWithChild("ows", "AcceptFormats", "OutputFormat", "application/soap+xml");
        SOAPMessage soapResponse = soap.getSoapResponse(true);
        Assert.assertTrue((soapResponse != null ? 1 : 0) != 0, (String)"SOAP reposnse came back null");
        Document soapDocument = soap.getResponseDocument();
        ETSAssert.assertXPath((String)"//wmts:Capabilities/@version = '1.0.0'", (Node)soapDocument, (NamespaceBindings)NS_BINDINGS);
    }
}

