/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengeospatial.cite.wmts10.ets.core.assertion.WmtsAssertion;
import org.opengeospatial.cite.wmts10.ets.core.domain.LayerInfo;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getcapabilities.AbstractBaseGetCapabilitiesFixture;
import org.opengeospatial.cite.wmts10.nsg.testsuite.getcapabilities.GetCapabilitiesKeywordTest;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.testng.asserts.SoftAssert;
import org.testng.util.Strings;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceMetadataContent
extends AbstractBaseGetCapabilitiesFixture {
    private final String NSG_ABSTRACTSTATEMENT = "This service implements the NSG WMTS 1.0.0 profile version 1.0";

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"verifyGetCapabilitiesSupported"})
    public void wmtsCapabilitiesExists() {
        ETSAssert.assertXPath((String)".", (Node)this.wmtsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesServiceIdentificationExists() {
        ETSAssert.assertXPath((String)"//ows:ServiceIdentification", (Node)this.wmtsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesServiceProviderExists() {
        ETSAssert.assertXPath((String)"//ows:ServiceProvider", (Node)this.wmtsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesOperationsMetadataExists() {
        ETSAssert.assertXPath((String)"//ows:OperationsMetadata", (Node)this.wmtsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesExists"})
    public void wmtsCapabilitiesContentsExists() {
        ETSAssert.assertXPath((String)"//wmts:Contents", (Node)this.wmtsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesAccessConstraints() {
        ETSAssert.assertXPath((String)"//ows:ServiceIdentification//ows:AccessConstraints", (Node)this.wmtsCapabilities, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesAbstract() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.createXPath();
        Node abstractElement = (Node)xPath.evaluate("//ows:ServiceIdentification/ows:Abstract", this.wmtsCapabilities, XPathConstants.NODE);
        if (abstractElement == null) {
            throw new SkipException("There is no <Abstract> Element to compare.");
        }
        String abstractStatement = (String)xPath.evaluate(".", abstractElement, XPathConstants.STRING);
        Assert.assertTrue((abstractStatement != null && !abstractStatement.isEmpty() ? 1 : 0) != 0, (String)"The <Abstract> statement is blank.");
        Assert.assertTrue((boolean)abstractStatement.contains("This service implements the NSG WMTS 1.0.0 profile version 1.0"), (String)("The <Abstract> statement (" + abstractStatement + ") should be:  This service implements the NSG WMTS 1.0.0 profile version 1.0."));
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesNASkeywords() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(false, "WMTS ServiceMetadata Capabilities docuemnt", this.wmtsCapabilities, "//ows:ServiceIdentification/ows:Keywords");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesNASkeywords_Layer() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(false, "Layer Data Structure", this.wmtsCapabilities, "//wmts:Layer/ows:Keywords");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesNASkeywords_LayerStyle() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(false, "Style Data Structure", this.wmtsCapabilities, "//wmts:Layer/wmts:Style/ows:Keywords");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesNASkeywords_LayerDimension() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(false, "Dimension Data Structure", this.wmtsCapabilities, "//wmts:Layer/wmts:Dimension/ows:Keywords");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesNASkeywords_TileMatrixSet() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(false, "TileMatrixSet Data Structure", this.wmtsCapabilities, "//wmts:TileMatrixSet/ows:Keywords");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesNASkeywords_TileMatrix() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(false, "TileMatrix Data Structure", this.wmtsCapabilities, "//wmts:TileMatrix/ows:Keywords");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesServiceIdentificationExists"})
    public void wmtsCapabilitiesNASkeywords_Theme() {
        GetCapabilitiesKeywordTest.verifyNASkeywords(false, "Theme Data Structure", this.wmtsCapabilities, "//wmts:Theme/ows:Keywords");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesContentsExists"})
    public void wmtsCapabilitiesLayerStyles() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.createXPath();
        if (this.layerInfo == null || this.layerInfo.size() <= 0) {
            throw new SkipException("There are no Layers identified");
        }
        SoftAssert sa = new SoftAssert();
        for (int i = 0; i < this.layerInfo.size(); ++i) {
            LayerInfo layer = (LayerInfo)this.layerInfo.get(i);
            String exprPath = "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layer.getLayerName() + "']/wmts:Style";
            NodeList layerStyles = (NodeList)xPath.evaluate(exprPath, this.wmtsCapabilities, XPathConstants.NODESET);
            sa.assertTrue(layerStyles != null && layerStyles.getLength() > 0, "There are no <Style> elements for <Layer>:  " + layer.getLayerName());
            if (layerStyles == null || layerStyles.getLength() <= 0) continue;
            boolean foundDefault = false;
            for (int si = 0; si < layerStyles.getLength() && !foundDefault; ++si) {
                Node style = layerStyles.item(si);
                String attribute = (String)xPath.evaluate("@isDefault", style, XPathConstants.STRING);
                String styleIdentifier = ServiceMetadataUtils.parseNodeElementName(xPath, style);
                foundDefault = attribute.equals("true") || styleIdentifier.equals("default");
            }
            sa.assertTrue(foundDefault, "There is no default <Style> for <Layer>:  " + layer.getLayerName());
        }
        sa.assertAll();
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesContentsExists"})
    public void wmtsCapabilitiesLayerStyleLegends() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.createXPath();
        if (this.layerInfo == null || this.layerInfo.size() <= 0) {
            throw new SkipException("There are no Layers identified");
        }
        SoftAssert sa = new SoftAssert();
        for (int i = 0; i < this.layerInfo.size(); ++i) {
            LayerInfo layer = (LayerInfo)this.layerInfo.get(i);
            String exprPath = "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layer.getLayerName() + "']/wmts:Style";
            NodeList layerStyles = (NodeList)xPath.evaluate(exprPath, this.wmtsCapabilities, XPathConstants.NODESET);
            sa.assertTrue(layerStyles != null && layerStyles.getLength() > 0, "There are no <Style> elements for <Layer>:  " + layer.getLayerName());
            if (layerStyles == null || layerStyles.getLength() <= 0) continue;
            for (int si = 0; si < layerStyles.getLength(); ++si) {
                Node style = layerStyles.item(si);
                String styleIdentifier = ServiceMetadataUtils.parseNodeElementName(xPath, style);
                NodeList legendList = (NodeList)xPath.evaluate("./wmts:LegendURL", style, XPathConstants.NODESET);
                sa.assertTrue(legendList != null && legendList.getLength() > 0, "There is no Legend for <Style>: " + styleIdentifier + " under <Layer>: " + layer.getLayerName());
                if (legendList == null || legendList.getLength() <= 0) continue;
                boolean foundPreferredFormat = false;
                for (int li = 0; li < legendList.getLength(); ++li) {
                    Node legend = legendList.item(li);
                    String format = (String)xPath.evaluate("@format", legend, XPathConstants.STRING);
                    String url = (String)xPath.evaluate("@xlink:href", legend, XPathConstants.STRING);
                    sa.assertTrue(!Strings.isNullOrEmpty((String)format) && !Strings.isNullOrEmpty((String)url), "Legend for Style: " + styleIdentifier + " under Layer: " + layer.getLayerName() + " is not properly defined.");
                    foundPreferredFormat |= format.equals("image/png") || format.equals("image/gif") || format.equals("image/jpeg");
                    WmtsAssertion.assertUrl(sa, url);
                    WmtsAssertion.assertUriIsResolvable(sa, url);
                    this.checkScaleDenominator(xPath, sa, layer, styleIdentifier, legend);
                }
                sa.assertTrue(foundPreferredFormat, "<Style>: " + styleIdentifier + " under <Layer>: " + layer.getLayerName() + " does not use a preferred Legend image format.");
            }
        }
        sa.assertAll();
    }

    private void checkScaleDenominator(XPath xPath, SoftAssert sa, LayerInfo layer, String styleIdentifier, Node legend) throws XPathExpressionException {
        boolean maxScaleDenominatorIsSet;
        String minScaleDenominator = (String)xPath.evaluate("@minScaleDenominator", legend, XPathConstants.STRING);
        String maxScaleDenominator = (String)xPath.evaluate("@maxScaleDenominator", legend, XPathConstants.STRING);
        boolean minScaleDenominatorIsSet = !Strings.isNullOrEmpty((String)minScaleDenominator);
        boolean bl = maxScaleDenominatorIsSet = !Strings.isNullOrEmpty((String)maxScaleDenominator);
        if (minScaleDenominatorIsSet && maxScaleDenominatorIsSet) {
            Double minScale = Double.parseDouble(minScaleDenominator);
            Double maxScale = Double.parseDouble(maxScaleDenominator);
            sa.assertTrue(minScale <= maxScale, "The minScaleDenominator > maxScaleDenominator for <Layer>: " + layer.getLayerName() + " and <Style>: " + styleIdentifier + " for a Legend");
        }
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesContentsExists"})
    public void wmtsCapabilitiesLayerDimension() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.createXPath();
        if (this.layerInfo == null || this.layerInfo.size() <= 0) {
            throw new SkipException("There are no Layers identified");
        }
        boolean anyDimensions = false;
        SoftAssert sa = new SoftAssert();
        for (int i = 0; i < this.layerInfo.size(); ++i) {
            LayerInfo layer = (LayerInfo)this.layerInfo.get(i);
            String exprPath = "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layer.getLayerName() + "']/wmts:Dimension";
            NodeList layerDimension = (NodeList)xPath.evaluate(exprPath, this.wmtsCapabilities, XPathConstants.NODESET);
            if (layerDimension == null || layerDimension.getLength() <= 0) continue;
            anyDimensions |= true;
            for (int si = 0; si < layerDimension.getLength(); ++si) {
                Node dimension = layerDimension.item(si);
                String dimensionIdentifier = ServiceMetadataUtils.parseNodeElementName(xPath, dimension);
                String defaultValue = (String)xPath.evaluate("./wmts:Default", dimension, XPathConstants.STRING);
                NodeList values = (NodeList)xPath.evaluate("./wmts:Value", dimension, XPathConstants.STRING);
                sa.assertTrue(!Strings.isNullOrEmpty((String)dimensionIdentifier), "There is no <Identifier> element for the <Dimension>, under <Layer>: " + layer.getLayerName());
                if (Strings.isNullOrEmpty((String)dimensionIdentifier)) continue;
                sa.assertTrue(!Strings.isNullOrEmpty((String)defaultValue), "There is no <Default> value element for the <Dimension>, under <Layer>: " + layer.getLayerName());
                if (Strings.isNullOrEmpty((String)defaultValue)) continue;
                sa.assertTrue(values != null && values.getLength() > 0, "There are no <Value> elements for the <Dimension>, under <Layer>: " + layer.getLayerName());
            }
        }
        if (!anyDimensions) {
            throw new SkipException("There are no <Dimension> elements within any of the defined <Layer> elements.");
        }
        sa.assertAll();
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesContentsExists"})
    public void wmtsCapabilitiesLayerInfoFormat() throws XPathExpressionException, XPathFactoryConfigurationException {
        XPath xPath = this.createXPath();
        if (this.layerInfo == null || this.layerInfo.size() <= 0) {
            throw new SkipException("There are no Layers identified");
        }
        SoftAssert sa = new SoftAssert();
        for (int i = 0; i < this.layerInfo.size(); ++i) {
            LayerInfo layer = (LayerInfo)this.layerInfo.get(i);
            String exprPath = "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layer.getLayerName() + "']/wmts:InfoFormat";
            NodeList layerInfoFormats = (NodeList)xPath.evaluate(exprPath, this.wmtsCapabilities, XPathConstants.NODESET);
            sa.assertTrue(layerInfoFormats != null && layerInfoFormats.getLength() > 0, "There are no <InfoFormat> elements for <Layer>:  " + layer.getLayerName());
            if (layerInfoFormats == null || layerInfoFormats.getLength() <= 0) continue;
            for (int fi = 0; fi < layerInfoFormats.getLength(); ++fi) {
                Node infoFormatNode = layerInfoFormats.item(fi);
                String infoFormat = (String)xPath.evaluate(".", infoFormatNode, XPathConstants.STRING);
                sa.assertTrue(!Strings.isNullOrEmpty((String)infoFormat), "There is no or invalid <InfoFormat> element under <Layer>: " + layer.getLayerName());
            }
        }
        sa.assertAll();
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesContentsExists"})
    public void wmtsCapabilitiesFeatureListURL() throws XPathExpressionException, XPathFactoryConfigurationException {
        throw new SkipException("WMTS ServiceMetadata Capabilities does not currently include FeatureListURLs");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirements 4,7", dependsOnMethods={"wmtsCapabilitiesContentsExists"})
    public void wmtsCapabilitiesDataURL() throws XPathExpressionException, XPathFactoryConfigurationException {
        throw new SkipException("WMTS ServiceMetadata Capabilities does not currently include DataURLs");
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }
}

