/*
 * Decompiled with CFR 0.152.
 */
package org.opengeospatial.cite.wmts10.nsg.testsuite.getfeatureinfo;

import de.latlon.ets.core.assertion.ETSAssert;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.glassfish.jersey.client.ClientConfig;
import org.opengeospatial.cite.wmts10.ets.core.domain.ProtocolBinding;
import org.opengeospatial.cite.wmts10.ets.core.util.ServiceMetadataUtils;
import org.opengeospatial.cite.wmts10.ets.testsuite.getfeatureinfo.AbstractBaseGetFeatureInfoFixture;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.Test;
import org.testng.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetFeatureInfoRest
extends AbstractBaseGetFeatureInfoFixture {
    private URI getFeatureInfoURI = null;
    private boolean _debug = false;

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 10", dependsOnMethods={"verifyGetFeatureInfoSupported"})
    public void wmtsGetFeatureInfoRESTCapable() throws XPathExpressionException, XPathFactoryConfigurationException {
        this.getFeatureInfoURI = ServiceMetadataUtils.getOperationEndpoint_REST(this.wmtsCapabilities, "GetFeatureInfo", ProtocolBinding.GET);
        Assert.assertTrue((this.getFeatureInfoURI != null ? 1 : 0) != 0, (String)"GetFeatureInfo (GET) endpoint not found or REST is not supported in ServiceMetadata capabilities document.");
    }

    @Test(description="NSG Web Map Tile Service (WMTS) 1.0.0, Requirement 10", dependsOnMethods={"wmtsGetFeatureInfoRESTCapable"})
    public void wmtsGetFeatureInfoRequestParametersSupported(ITestContext testContext) {
        String requestFormat = null;
        try {
            NodeList layers;
            String layerName = this.reqEntity.getKvpValue("Layer");
            if (layerName == null && (layers = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:Layer/ows:Identifier")).getLength() > 0) {
                layerName = layers.item(0).getTextContent().trim();
            }
            XPath xPath = this.createXPath();
            String style = this.reqEntity.getKvpValue("Style");
            String tileMatrixSet = this.reqEntity.getKvpValue("TileMatrixSet");
            String tileMatrix = this.reqEntity.getKvpValue("TileMatrix");
            String tileRow = this.reqEntity.getKvpValue("TileRow");
            String tileCol = this.reqEntity.getKvpValue("TileCol");
            requestFormat = this.reqEntity.getKvpValue("Format");
            NodeList resourceURLs = ServiceMetadataUtils.getNodeElements(this.wmtsCapabilities, "//wmts:Contents/wmts:Layer[ows:Identifier = '" + layerName + "']/wmts:ResourceURL");
            Assert.assertTrue((resourceURLs != null && resourceURLs.getLength() > 0 ? 1 : 0) != 0, (String)("WMTS apparently does not support REST or contains no REST endpoints for layer: " + layerName));
            Random random = new Random();
            int randomIndx = random.nextInt(resourceURLs.getLength());
            Node resourceNode = resourceURLs.item(randomIndx);
            String templateURL = ServiceMetadataUtils.getNodeText(xPath, resourceNode, "@template");
            requestFormat = ServiceMetadataUtils.getNodeText(xPath, resourceNode, "@format");
            if (Strings.isNullOrEmpty((String)templateURL) || Strings.isNullOrEmpty((String)requestFormat)) {
                throw new XPathExpressionException("Invalid or corrupt Resource URL image format");
            }
            try {
                templateURL = templateURL.replaceAll("\\{(?i)Style\\}", style);
                templateURL = templateURL.replaceAll("\\{(?i)FeatureInfoMatrixSet\\}", tileMatrixSet);
                templateURL = templateURL.replaceAll("\\{(?i)FeatureInfoMatrix\\}", tileMatrix);
                templateURL = templateURL.replaceAll("\\{(?i)FeatureInfoRow\\}", tileRow);
                templateURL = templateURL.replaceAll("\\{(?i)FeatureInfoCol\\}", tileCol);
                templateURL = templateURL.replaceAll("\\{(?i)I\\}", "0");
                templateURL = templateURL.replaceAll("\\{(?i)J\\}", "0");
                this.getFeatureInfoURI = new URI(templateURL);
            }
            catch (URISyntaxException ue) {
                this.getFeatureInfoURI = null;
            }
            ETSAssert.assertUrl((String)this.getFeatureInfoURI.toString());
            ClientConfig config = new ClientConfig();
            Client client = ClientBuilder.newClient((Configuration)config);
            WebTarget target = client.target(this.getFeatureInfoURI);
            Invocation.Builder reqBuilder = target.request();
            Response rsp = reqBuilder.buildGet().invoke();
            this.rspEntity = (Document)rsp.readEntity(Document.class);
            Assert.assertTrue((rsp != null ? 1 : 0) != 0, (String)"Error processing REST GetFeatureInfo request");
            ETSAssert.assertContentType((MultivaluedMap)rsp.getHeaders(), (String)requestFormat);
            ETSAssert.assertStatusCode((int)rsp.getStatus(), (int[])new int[]{200});
            Object erroneousURL = this.getFeatureInfoURI.toString();
            int indx = ((String)erroneousURL).lastIndexOf("/");
            erroneousURL = ((String)erroneousURL).substring(0, indx + 1) + "X" + ((String)erroneousURL).substring(indx + 1);
            URI invalidURI = null;
            try {
                invalidURI = new URI((String)erroneousURL);
            }
            catch (URISyntaxException ue) {
                System.out.println(ue.getMessage());
                invalidURI = null;
            }
            ClientConfig config2 = new ClientConfig();
            Client client2 = ClientBuilder.newClient((Configuration)config2);
            WebTarget target2 = client2.target(invalidURI);
            Invocation.Builder reqBuilder2 = target2.request();
            Response rsp2 = reqBuilder2.buildGet().invoke();
            this.rspEntity = (Document)rsp2.readEntity(Document.class);
            Assert.assertTrue((rsp2 != null ? 1 : 0) != 0, (String)"Error processing invalid REST GetFeatureInfo request");
            Assert.assertFalse((rsp2.getStatus() == 200 ? 1 : 0) != 0, (String)"Expected status code from Invalid REST GetFeatureInfo request is not expected to be 200. ");
            ETSAssert.assertContentType((MultivaluedMap)rsp2.getHeaders(), (String)"text/xml");
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException xpe) {
            System.out.println(xpe.getMessage());
            if (this._debug) {
                xpe.printStackTrace();
            }
            Assert.assertTrue((boolean)false, (String)("Error found when retrieving REST GetFeatureInfo request: " + xpe.getMessage()));
        }
    }

    private XPath createXPath() throws XPathFactoryConfigurationException {
        XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
        return xpath;
    }
}

