/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.saxon;

import com.occamlab.te.TEClassLoader;
import com.occamlab.te.TECore;
import com.occamlab.te.index.FunctionEntry;
import com.occamlab.te.saxon.TEFunctionCall;
import com.occamlab.te.util.Misc;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class TEJavaFunctionCall
extends TEFunctionCall {
    FunctionEntry fe;
    Method[] methods = null;

    public TEJavaFunctionCall(FunctionEntry fe, StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        super(functionName, staticArgs, env);
        this.fe = fe;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Object result;
        int argsIndex;
        Class<?>[] types;
        Method m4;
        Controller controller = context.getController();
        ObjectValue ov = (ObjectValue)controller.getParameter("{http://www.occamlab.com/te}core");
        TECore core = (TECore)ov.getObject();
        TEClassLoader cl = core.getEngine().getClassLoader(core.getOpts().getSourcesName());
        if (this.methods == null) {
            this.methods = new Method[this.fe.getMaxArgs() + 1];
            for (int i = this.fe.getMinArgs(); i <= this.fe.getMaxArgs(); ++i) {
                try {
                    this.methods[i] = Misc.getMethod(this.fe.getClassName(), this.fe.getMethod(), cl, i);
                    continue;
                }
                catch (Exception e) {
                    throw new XPathException("Error: Unable to bind function " + this.fe.getName(), e);
                }
            }
        }
        Object instance = null;
        if (this.fe.isInitialized() && (instance = core.getFunctionInstance(this.fe.hashCode())) == null) {
            try {
                instance = Misc.makeInstance(this.fe.getClassName(), this.fe.getClassParams(), cl);
                core.putFunctionInstance(this.fe.hashCode(), instance);
            }
            catch (Exception e) {
                throw new XPathException(e);
            }
        }
        Expression[] argExpressions = this.getArguments();
        Object[] javaArgs = new Object[argExpressions.length];
        if (this.fe.usesContext()) {
            m4 = this.methods[argExpressions.length + 1];
            types = m4.getParameterTypes();
            Item vr = context.getContextItem();
            javaArgs[0] = Value.asValue(vr).convertToJava(types[0], context);
            argsIndex = 1;
        } else {
            m4 = this.methods[argExpressions.length];
            types = m4.getParameterTypes();
            argsIndex = 0;
        }
        for (int i = 0; i < argExpressions.length; ++i) {
            ValueRepresentation vr = ExpressionTool.lazyEvaluate(argExpressions[i], context, 1);
            javaArgs[argsIndex] = Value.asValue(vr).convertToJava(types[argsIndex], context);
            ++argsIndex;
        }
        try {
            result = m4.invoke(instance, javaArgs);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof InvocationTargetException) {
                cause = e.getCause();
            }
            String msg = "Error invoking " + this.fe.getId() + "\n" + cause.getClass().getName();
            if (cause.getMessage() != null) {
                msg = msg + ": " + cause.getMessage();
            }
            throw new XPathException(msg, cause);
        }
        if (result == null) {
            return EmptyIterator.getInstance();
        }
        Value v = Value.convertJavaObjectToXPath(result, SequenceType.ANY_SEQUENCE, context);
        return v.iterate();
    }
}

