/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps10;

import com.sun.jersey.api.client.Client;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.wps10.SuiteAttribute;
import org.opengis.cite.wps10.TestRunArg;
import org.opengis.cite.wps10.util.ClientUtils;
import org.opengis.cite.wps10.util.TestSuiteLogger;
import org.opengis.cite.wps10.util.URIUtils;
import org.opengis.cite.wps10.util.ValidationUtils;
import org.opengis.cite.wps10.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.w3c.dom.Document;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.registerClientComponent(suite);
    }

    public void onFinish(ISuite suite) {
        if (null != System.getProperty("deleteSubjectOnFinish")) {
            this.deleteTempFiles(suite);
            System.getProperties().remove("deleteSubjectOnFinish");
        }
    }

    void processSuiteParameters(ISuite suite) {
        String httpGetUriParam;
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        String iutParam = (String)params.get(TestRunArg.IUT.toString());
        HashSet<URI> schemaURIs = new HashSet<URI>();
        if (null == iutParam || iutParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.IUT.toString());
        }
        URI iutRef = URI.create(iutParam.trim());
        String iutRefString = (String)params.get(TestRunArg.IUT.toString());
        File entityFile = null;
        try {
            entityFile = URIUtils.dereferenceURI(iutRef);
            if (XMLUtils.isXMLSchema(entityFile)) {
                params.put(TestRunArg.XSD.toString(), iutRefString);
            } else {
                params.put(TestRunArg.XML.toString(), iutRefString);
            }
            schemaURIs.addAll(ValidationUtils.extractSchemaReferences(new StreamSource(entityFile), iutRefString));
        }
        catch (Exception exception) {
            // empty catch block
        }
        suite.setAttribute(SuiteAttribute.XML.getName(), (Object)entityFile);
        suite.setAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName(), (Object)entityFile);
        TestSuiteLogger.log(Level.FINE, String.format("Wrote test subject to file: %s (%d bytes)", entityFile.getAbsolutePath(), entityFile.length()));
        Document iutDoc = null;
        try {
            iutDoc = URIUtils.parseURI(entityFile.toURI());
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to parse resource retrieved from " + iutRef, x);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)iutDoc);
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT_URI.getName(), (Object)URI.create(iutRefString));
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(iutDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
        if (null == (httpGetUriParam = (String)params.get(TestRunArg.EXECUTE_HTTP_GET_URI.toString())) || httpGetUriParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.EXECUTE_HTTP_GET_URI.toString());
        }
        String httpGetUriRefString = (String)params.get(TestRunArg.EXECUTE_HTTP_GET_URI.toString());
        suite.setAttribute(SuiteAttribute.EXECUTE_HTTP_GET_URI.getName(), (Object)URI.create(httpGetUriRefString));
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(iutDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
        String executeRequestRawDataOutputParam = (String)params.get(TestRunArg.EXECUTE_REQUEST_RAW_DATA_URI.toString());
        URI executeRequestRawDataOutputRef = URI.create(executeRequestRawDataOutputParam.trim());
        File executeRequestRawDataOutputFile = null;
        try {
            executeRequestRawDataOutputFile = URIUtils.dereferenceURI(executeRequestRawDataOutputRef);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to dereference resource located at " + executeRequestRawDataOutputRef, ex);
        }
        Document executeRequestRawDataOutputDoc = null;
        try {
            executeRequestRawDataOutputDoc = URIUtils.parseURI(executeRequestRawDataOutputFile.toURI());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse resource retrieved from " + executeRequestRawDataOutputRef, ex);
        }
        suite.setAttribute(SuiteAttribute.EXECUTE_REQUEST_RAW_DATA_URI.getName(), (Object)executeRequestRawDataOutputDoc);
        String executeRequestResponseDocumentOutputParam = (String)params.get(TestRunArg.EXECUTE_REQUEST_RESPONSE_DOCUMENT_URI.toString());
        URI executeRequestResponseDocumentOutputRef = URI.create(executeRequestResponseDocumentOutputParam.trim());
        File executeRequestResponseDocumentOutputFile = null;
        try {
            executeRequestResponseDocumentOutputFile = URIUtils.dereferenceURI(executeRequestResponseDocumentOutputRef);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to dereference resource located at " + executeRequestResponseDocumentOutputRef, ex);
        }
        Document executeRequestResponseDocumentOutputDoc = null;
        try {
            executeRequestResponseDocumentOutputDoc = URIUtils.parseURI(executeRequestResponseDocumentOutputFile.toURI());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse resource retrieved from " + executeRequestResponseDocumentOutputRef, ex);
        }
        suite.setAttribute(SuiteAttribute.EXECUTE_REQUEST_RESPONSE_DOCUMENT_URI.getName(), (Object)executeRequestResponseDocumentOutputDoc);
        String executeRequestUpdatingResponseDocumentOutputParam = (String)params.get(TestRunArg.EXECUTE_REQUEST_UPDATING_RESPONSE_DOCUMENT_URI.toString());
        URI executeRequestUpdatingResponseDocumentOutputRef = URI.create(executeRequestUpdatingResponseDocumentOutputParam.trim());
        File executeRequestUpdatingResponseDocumentOutputFile = null;
        try {
            executeRequestUpdatingResponseDocumentOutputFile = URIUtils.dereferenceURI(executeRequestUpdatingResponseDocumentOutputRef);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to dereference resource located at " + executeRequestUpdatingResponseDocumentOutputRef, ex);
        }
        Document executeRequestUpdatingResponseDocumentOutputDoc = null;
        try {
            executeRequestUpdatingResponseDocumentOutputDoc = URIUtils.parseURI(executeRequestUpdatingResponseDocumentOutputFile.toURI());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse resource retrieved from " + executeRequestUpdatingResponseDocumentOutputRef, ex);
        }
        suite.setAttribute(SuiteAttribute.EXECUTE_REQUEST_UPDATING_RESPONSE_DOCUMENT_URI.getName(), (Object)executeRequestUpdatingResponseDocumentOutputDoc);
    }

    void registerClientComponent(ISuite suite) {
        Client client = ClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), (Object)client);
        }
    }

    void deleteTempFiles(ISuite suite) {
        if (TestSuiteLogger.isLoggable(Level.CONFIG)) {
            return;
        }
        File testSubjFile = (File)suite.getAttribute(SuiteAttribute.TEST_SUBJ_FILE.getName());
        if (testSubjFile.exists()) {
            testSubjFile.delete();
        }
    }

    void processXmlReference(ISuite suite) {
        HashSet<URI> schemaURIs;
        block9: {
            Map params = suite.getXmlSuite().getParameters();
            TestSuiteLogger.log(Level.CONFIG, String.format("Suite parameters:\n %s", params));
            schemaURIs = new HashSet<URI>();
            String xsdURI = (String)params.get(TestRunArg.XSD.toString());
            if (null != xsdURI && !xsdURI.isEmpty()) {
                schemaURIs.add(URI.create(xsdURI));
                suite.setAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName(), schemaURIs);
                return;
            }
            String xmlURI = (String)params.get(TestRunArg.XML.toString());
            if (null == xmlURI || xmlURI.isEmpty()) {
                throw new IllegalArgumentException("Missing XML resource (document or application schema).");
            }
            File xmlFile = null;
            try {
                URI uriXml = URI.create(xmlURI);
                xmlFile = URIUtils.resolveURIAsFile(uriXml);
                if (null == xmlFile || !xmlFile.exists()) {
                    throw new IllegalArgumentException("Failed to dereference URI: " + xmlURI);
                }
                if (XMLUtils.isXMLSchema(xmlFile)) {
                    params.put(TestRunArg.XSD.toString(), xmlURI);
                    schemaURIs.add(URI.create(xmlURI));
                    break block9;
                }
                schemaURIs.addAll(ValidationUtils.extractSchemaReferences(new StreamSource(xmlFile), xmlURI));
                suite.setAttribute(SuiteAttribute.XML.getName(), (Object)xmlFile);
                Document iutDoc = null;
                try {
                    iutDoc = URIUtils.parseURI(uriXml);
                }
                catch (Exception x) {
                    throw new RuntimeException("Failed to parse resource retrieved from " + xmlURI, x);
                }
                suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)iutDoc);
                TestSuiteLogger.log(Level.FINE, "Wrote XML document to " + xmlFile.getAbsolutePath());
                suite.setAttribute(SuiteAttribute.TEST_SUBJECT_URI.getName(), (Object)URI.create(xmlURI));
            }
            catch (IOException iox) {
                throw new RuntimeException("Failed to read resource obtained from " + xmlURI, iox);
            }
            catch (XMLStreamException xse) {
                throw new RuntimeException("Failed to find schema reference in source: " + xmlFile.getAbsolutePath(), xse);
            }
        }
        suite.setAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName(), schemaURIs);
        TestSuiteLogger.log(Level.FINE, String.format("Schema references: %s", schemaURIs));
    }
}

