/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.NonDelegatingURIResolver;
import net.sf.saxon.RelativeURIResolver;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SingletonNode;

public class Document
extends SystemFunction
implements XSLTFunction {
    private String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
        }
    }

    public int computeCardinality() {
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return 57344;
        }
        return 24576;
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public int computeSpecialProperties() {
        return 0x4A0000;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        Configuration config = visitor.getConfiguration();
        if (this.getNumberOfArguments() == 1 && ((Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/preEvaluateDocFunction")).booleanValue()) {
            try {
                AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(null);
                if (hrefVal == null) {
                    return null;
                }
                String href = hrefVal.getStringValue();
                if (href.indexOf(35) >= 0) {
                    return this;
                }
                NodeInfo item = Document.preLoadDoc(href, this.expressionBaseURI, config, this);
                if (item != null) {
                    return new Literal(new SingletonNode(item));
                }
            }
            catch (Exception err) {
                return this;
            }
        }
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addDocToPathMap(pathMap, pathMapNodeSet);
    }

    public Expression copy() {
        Document d = (Document)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        return d;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int numArgs = this.argument.length;
        SequenceIterator hrefSequence = this.argument[0].iterate(context);
        String baseURI = null;
        if (numArgs == 2) {
            NodeInfo base = (NodeInfo)this.argument[1].evaluateItem(context);
            baseURI = base.getBaseURI();
        }
        DocumentMappingFunction map = new DocumentMappingFunction(context);
        map.baseURI = baseURI;
        map.stylesheetURI = this.expressionBaseURI;
        map.locator = this;
        ItemMappingIterator iter = new ItemMappingIterator(hrefSequence, map);
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            return new DocumentOrderIterator(iter, GlobalOrderComparer.getInstance());
        }
        return iter;
    }

    public static NodeInfo makeDoc(String href, String baseURI, XPathContext c, SourceLocator locator) throws XPathException {
        String documentKey;
        Controller controller;
        URIResolver resolver2;
        Configuration config = c.getConfiguration();
        int hash = href.indexOf(35);
        String fragmentId = null;
        if (hash >= 0) {
            if (hash == href.length() - 1) {
                href = href.substring(0, hash);
            } else {
                fragmentId = href.substring(hash + 1);
                href = href.substring(0, hash);
                if (!config.getNameChecker().isValidNCName(fragmentId)) {
                    XPathException de = new XPathException("The fragment identifier " + Err.wrap(fragmentId) + " is not a valid NCName");
                    de.setErrorCode("XTRE1160");
                    de.setXPathContext(c);
                    throw de;
                }
            }
        }
        if ((resolver2 = (controller = c.getController()).getURIResolver()) == null) {
            resolver2 = controller.getStandardURIResolver();
        }
        if (resolver2 instanceof RelativeURIResolver) {
            try {
                documentKey = ((RelativeURIResolver)resolver2).makeAbsolute(href, baseURI);
            }
            catch (TransformerException e) {
                documentKey = '/' + href;
                baseURI = "";
            }
        } else if (baseURI == null) {
            try {
                documentKey = new URI(href).toString();
            }
            catch (URISyntaxException err) {
                documentKey = '/' + href;
                baseURI = "";
            }
        } else if (href.length() == 0) {
            documentKey = baseURI;
        } else {
            try {
                URI uri = new URI(baseURI).resolve(href);
                documentKey = uri.toString();
            }
            catch (URISyntaxException err) {
                documentKey = baseURI + "/../" + href;
            }
            catch (IllegalArgumentException err) {
                documentKey = baseURI + "/../" + href;
            }
        }
        DocumentInfo doc = config.getGlobalDocumentPool().find(documentKey);
        if (doc != null) {
            return doc;
        }
        doc = controller.getDocumentPool().find(documentKey);
        if (doc != null) {
            return Document.getFragment(doc, fragmentId, c);
        }
        if (!controller.checkUniqueOutputDestination(documentKey)) {
            XPathException err = new XPathException("Cannot read a document that was written during the same transformation: " + documentKey);
            err.setXPathContext(c);
            err.setErrorCode("XTRE1500");
            throw err;
        }
        try {
            DocumentInfo newdoc;
            Source source;
            if (resolver2 instanceof RelativeURIResolver) {
                try {
                    source = ((RelativeURIResolver)resolver2).dereference(documentKey);
                }
                catch (Exception ex) {
                    XPathException de = new XPathException("Exception thrown by URIResolver", ex);
                    if (controller.getConfiguration().isTraceExternalFunctions()) {
                        ex.printStackTrace();
                    }
                    de.setLocator(locator);
                    throw de;
                }
            }
            try {
                source = resolver2.resolve(href, baseURI);
            }
            catch (Exception ex) {
                XPathException de = new XPathException("Exception thrown by URIResolver", ex);
                if (controller.getConfiguration().isTraceExternalFunctions()) {
                    ex.printStackTrace();
                }
                de.setLocator(locator);
                throw de;
            }
            if (source == null && !(resolver2 instanceof NonDelegatingURIResolver)) {
                resolver2 = controller.getStandardURIResolver();
                source = resolver2 instanceof RelativeURIResolver ? ((RelativeURIResolver)resolver2).dereference(documentKey) : resolver2.resolve(href, baseURI);
            }
            if ((source = config.getSourceResolver().resolveSource(source, config)) instanceof NodeInfo || source instanceof DOMSource) {
                NodeInfo startNode = controller.prepareInputTree(source);
                newdoc = startNode.getDocumentRoot();
            } else {
                PathMap.PathMapRoot pathRoot;
                PathMap map;
                Builder b;
                Receiver s = b = controller.makeBuilder();
                source = AugmentedSource.makeAugmentedSource(source);
                ((AugmentedSource)source).setStripSpace(4);
                if (controller.getExecutable().stripsInputTypeAnnotations()) {
                    s = controller.getConfiguration().getAnnotationStripper(s);
                }
                if ((map = controller.getPathMapForDocumentProjection()) != null && (pathRoot = map.getRootForDocument(documentKey)) != null && !pathRoot.isReturnable() && !pathRoot.hasUnknownDependencies()) {
                    ((AugmentedSource)source).addFilter(config.makeDocumentProjector(pathRoot));
                }
                new Sender(b.getPipelineConfiguration()).send(source, s);
                newdoc = (DocumentInfo)b.getCurrentRoot();
                b.reset();
                if (source instanceof AugmentedSource && ((AugmentedSource)source).isPleaseCloseAfterUse()) {
                    ((AugmentedSource)source).close();
                }
            }
            controller.registerDocument(newdoc, documentKey);
            controller.addUnavailableOutputDestination(documentKey);
            return Document.getFragment(newdoc, fragmentId, c);
        }
        catch (TransformerException err) {
            XPathException xerr = XPathException.makeXPathException(err);
            xerr.setLocator(locator);
            xerr.setErrorCode("FODC0005");
            try {
                controller.recoverableError(xerr);
            }
            catch (XPathException err2) {
                throw xerr;
            }
            return null;
        }
    }

    public static NodeInfo preLoadDoc(String href, String baseURI, Configuration config, SourceLocator locator) throws XPathException {
        String documentKey;
        int hash = href.indexOf(35);
        if (hash >= 0) {
            throw new XPathException("Fragment identifier not supported for preloaded documents");
        }
        URIResolver resolver2 = config.getURIResolver();
        if (resolver2 instanceof RelativeURIResolver) {
            try {
                documentKey = ((RelativeURIResolver)resolver2).makeAbsolute(href, baseURI);
            }
            catch (TransformerException e) {
                documentKey = '/' + href;
                baseURI = "";
            }
        } else if (baseURI == null) {
            try {
                documentKey = new URI(href).toString();
            }
            catch (URISyntaxException err) {
                documentKey = '/' + href;
                baseURI = "";
            }
        } else if (href.length() == 0) {
            documentKey = baseURI;
        } else {
            try {
                URI uri = new URI(baseURI).resolve(href);
                documentKey = uri.toString();
            }
            catch (URISyntaxException err) {
                documentKey = baseURI + "/../" + href;
            }
            catch (IllegalArgumentException err) {
                documentKey = baseURI + "/../" + href;
            }
        }
        DocumentInfo doc = config.getGlobalDocumentPool().find(documentKey);
        if (doc != null) {
            return doc;
        }
        try {
            URIResolver r = resolver2;
            Source source = null;
            if (r != null) {
                try {
                    source = r.resolve(href, baseURI);
                }
                catch (Exception ex) {
                    XPathException de = new XPathException("Exception thrown by URIResolver", ex);
                    if (config.isTraceExternalFunctions()) {
                        ex.printStackTrace();
                    }
                    de.setLocator(locator);
                    throw de;
                }
            }
            if (source == null && !(r instanceof NonDelegatingURIResolver)) {
                r = config.getSystemURIResolver();
                source = r.resolve(href, baseURI);
            }
            source = config.getSourceResolver().resolveSource(source, config);
            DocumentInfo newdoc = config.buildDocument(source);
            config.getGlobalDocumentPool().add(newdoc, documentKey);
            return newdoc;
        }
        catch (TransformerException err) {
            XPathException xerr = XPathException.makeXPathException(err);
            xerr.setLocator(locator);
            xerr.setErrorCode("FODC0005");
            throw new XPathException(err);
        }
    }

    public void sendDocuments(XPathContext context, Receiver out) throws XPathException {
        Item href;
        SequenceIterator hrefSequence = this.argument[0].iterate(context);
        String explicitBaseURI = null;
        if (this.argument.length == 2) {
            NodeInfo base = (NodeInfo)this.argument[1].evaluateItem(context);
            explicitBaseURI = base.getBaseURI();
        }
        while ((href = hrefSequence.next()) != null) {
            String base = explicitBaseURI == null ? (href instanceof NodeInfo ? ((NodeInfo)href).getBaseURI() : this.expressionBaseURI) : explicitBaseURI;
            Document.sendDoc(href.getStringValue(), base, context, this, out);
        }
    }

    public static void sendDoc(String href, String baseURL, XPathContext c, SourceLocator locator, Receiver out) throws XPathException {
        String documentKey;
        PipelineConfiguration pipe = out.getPipelineConfiguration();
        if (pipe == null) {
            pipe = c.getController().makePipelineConfiguration();
            out.setPipelineConfiguration(pipe);
        }
        if (baseURL == null) {
            try {
                documentKey = new URI(href).toString();
            }
            catch (URISyntaxException err) {
                documentKey = '/' + href;
                baseURL = "";
            }
        } else if (href.length() == 0) {
            documentKey = baseURL;
        } else {
            try {
                URI url = new URI(baseURL).resolve(href);
                documentKey = url.toString();
            }
            catch (URISyntaxException err) {
                documentKey = baseURL + "/../" + href;
            }
            catch (IllegalArgumentException err) {
                documentKey = baseURL + "/../" + href;
            }
        }
        Controller controller = c.getController();
        DocumentInfo doc = controller.getDocumentPool().find(documentKey);
        Source source = null;
        if (doc != null) {
            source = doc;
        } else {
            try {
                URIResolver r = controller.getURIResolver();
                if (r != null) {
                    source = r.resolve(href, baseURL);
                }
                if (source == null) {
                    r = controller.getStandardURIResolver();
                    source = r.resolve(href, baseURL);
                }
                if (source instanceof NodeInfo || source instanceof DOMSource) {
                    NodeInfo startNode = controller.prepareInputTree(source);
                    source = startNode.getDocumentRoot();
                }
            }
            catch (TransformerException err) {
                XPathException xerr = XPathException.makeXPathException(err);
                xerr.setLocator(locator);
                xerr.setErrorCode("FODC0005");
                throw xerr;
            }
        }
        source = AugmentedSource.makeAugmentedSource(source);
        ((AugmentedSource)source).setStripSpace(4);
        if (controller.getExecutable().stripsInputTypeAnnotations()) {
            out = controller.getConfiguration().getAnnotationStripper(out);
        }
        new Sender(pipe).send(source, out);
    }

    private static NodeInfo getFragment(DocumentInfo doc, String fragmentId, XPathContext context) throws XPathException {
        if (fragmentId == null) {
            return doc;
        }
        if (!context.getConfiguration().getNameChecker().isValidNCName(fragmentId)) {
            XPathException err = new XPathException("Invalid fragment identifier in URI");
            err.setXPathContext(context);
            err.setErrorCode("XTRE1160");
            try {
                context.getController().recoverableError(err);
            }
            catch (XPathException dynamicError) {
                throw err;
            }
            return doc;
        }
        return doc.selectID(fragmentId);
    }

    private static class DocumentMappingFunction
    implements ItemMappingFunction {
        public String baseURI;
        public String stylesheetURI;
        public SourceLocator locator;
        public XPathContext context;

        public DocumentMappingFunction(XPathContext context) {
            this.context = context;
        }

        public Item map(Item item) throws XPathException {
            String b = this.baseURI;
            if (b == null) {
                b = item instanceof NodeInfo ? ((NodeInfo)item).getBaseURI() : this.stylesheetURI;
            }
            return Document.makeDoc(item.getStringValue(), b, this.context, this.locator);
        }
    }
}

