/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps10.level1;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.wps10.DataFixture;
import org.opengis.cite.wps10.util.XMLUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AllOperationServerValidation
extends DataFixture {
    String processId = "";

    @BeforeClass
    public void beforeClass() throws IOException, ParserConfigurationException, SAXException, SaxonApiException {
        String serviceURL = this.testSubjectUri.toString();
        String response = this.sendGetRequest(serviceURL, "?service=wps&request=GetCapabilities&language=en-US");
        InputSource sourceWR = new InputSource(new StringReader(response));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        XdmValue xdmValue = XMLUtils.evaluateXPath2(new DOMSource(documentWR), "//ows:Identifier", this.getStandardBindings());
        if (xdmValue.size() != 0) {
            this.processId = xdmValue.itemAt(0).getStringValue();
        }
        this.CheckServiceHasProcess();
    }

    private void CheckServiceHasProcess() {
        if (this.processId.isEmpty()) {
            throw new SkipException("Skip the DescribeProcess validation test due to no process offering.");
        }
    }

    @Test(enabled=true, groups={"A.4.1. All operations implemented test module"}, description="Verify that the rules and conventions governing the use of HTTP are observed")
    public void GetCapabilitiesHttpProtocolUsageValidation() throws IOException, URISyntaxException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&version=1.0.0&request=GetCapabilities";
        HttpURLConnection connection = this.GetConnection(serviceURL, param);
        connection.setRequestMethod("GET");
        Integer responseCode = connection.getResponseCode();
        boolean result = responseCode == 200;
        Assert.assertTrue(result, "The server does not respond to HTTP request");
    }

    @Test(enabled=true, groups={"A.4.1. All operations implemented test module"}, description="Verify that a service request which generates an exception produces response that contains 1) a service exception report, and 2) a status code indicating an error.")
    public void GetCapabilitiesHttpResponseStatusCodeValidation() throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&version=1.0.0&request=GetCapabilities";
        HttpURLConnection connection = this.GetConnection(serviceURL, param);
        connection.setRequestMethod("POST");
        Integer responseCode = connection.getResponseCode();
        int firstDigit = Integer.parseInt(Integer.toString(responseCode).substring(0, 1));
        boolean resCodeResult = firstDigit == 4 || firstDigit == 5;
        String responseWrong = "";
        if (responseCode > 299) {
            String inputLine;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = inputReader.readLine()) != null) {
                response.append(inputLine);
            }
            inputReader.close();
            responseWrong = response.toString();
        }
        boolean result = resCodeResult;
        Assert.assertTrue(result, "the response code from server is not either 4xx (Client error) or 5xx (Server error)");
        InputSource sourceWR = new InputSource(new StringReader(responseWrong));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        String candidateNodeWR = this.CheckXPath2("//ows:ExceptionReport", documentWR);
        boolean wrongResultRequest = !candidateNodeWR.contains("XdmEmptySequence");
        boolean finalResult = wrongResultRequest;
        Assert.assertTrue(finalResult, "The response body from server does not contain a service exception report.");
    }

    @Test(enabled=true, groups={"A.4.1. All operations implemented test module"}, description="Verify that the rules and conventions governing the use of HTTP are observed")
    public void DescribeProcessHttpProtocolUsageValidation() throws IOException, URISyntaxException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&request=DescribeProcess&Version=1.0.0&identifier=" + this.processId;
        HttpURLConnection connection = this.GetConnection(serviceURL, param);
        connection.setRequestMethod("GET");
        Integer responseCode = connection.getResponseCode();
        boolean result = responseCode == 200;
        Assert.assertTrue(result, "The server does not respond to HTTP request");
    }

    @Test(groups={"A.4.1. All operations implemented test module"}, description="Verify that a service request which generates an exception produces response that contains 1) a service exception report, and 2) a status code indicating an error.")
    public void DescribeProcessHttpResponseStatusCodeValidation() throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&request=DescribeProcess&Version=1.0.0";
        HttpURLConnection connection = this.GetConnection(serviceURL, param);
        connection.setRequestMethod("POST");
        Integer responseCode = connection.getResponseCode();
        int firstDigit = Integer.parseInt(Integer.toString(responseCode).substring(0, 1));
        boolean resCodeResult = firstDigit == 4 || firstDigit == 5;
        String responseWrong = "";
        if (responseCode > 299) {
            String inputLine;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = inputReader.readLine()) != null) {
                response.append(inputLine);
            }
            inputReader.close();
            responseWrong = response.toString();
        }
        boolean result = resCodeResult;
        Assert.assertTrue(result, "the response code from server is not either 4xx (Client error) or 5xx (Server error)");
        InputSource sourceWR = new InputSource(new StringReader(responseWrong));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        String candidateNodeWR = this.CheckXPath2("//ows:ExceptionReport", documentWR);
        boolean wrongResultRequest = !candidateNodeWR.contains("XdmEmptySequence");
        boolean finalResult = wrongResultRequest;
        Assert.assertTrue(finalResult, "The response body from server does not contain a service exception report.");
    }

    @Test(enabled=true, groups={"A.4.1. All operations implemented test module"}, description="Verify that a service request which generates an exception produces response that contains 1) a service exception report, and 2) a status code indicating an error.")
    public void ExecuteHttpResponseStatusCodeValidation() throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&version=1.0.0&request=DescribeProcess&identifier=JTS:Invalid";
        HttpURLConnection connection = this.GetConnection(serviceURL, param);
        connection.setRequestMethod("POST");
        Integer responseCode = connection.getResponseCode();
        int firstDigit = Integer.parseInt(Integer.toString(responseCode).substring(0, 1));
        boolean resCodeResult = firstDigit == 4 || firstDigit == 5;
        String responseWrong = "";
        if (responseCode > 299) {
            String inputLine;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = inputReader.readLine()) != null) {
                response.append(inputLine);
            }
            inputReader.close();
            responseWrong = response.toString();
        }
        boolean result = resCodeResult;
        Assert.assertTrue(result, "the response code from server is not either 4xx (Client error) or 5xx (Server error)");
        InputSource sourceWR = new InputSource(new StringReader(responseWrong));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        String candidateNodeWR = this.CheckXPath2("//ows:ExceptionReport", documentWR);
        boolean wrongResultRequest = !candidateNodeWR.contains("XdmEmptySequence");
        boolean finalResult = wrongResultRequest;
        Assert.assertTrue(finalResult, "The response body from server does not contain a service exception report.");
    }

    public HttpURLConnection GetConnection(String serviceURL, String param) throws IOException {
        URL urlObj = new URL(serviceURL + param);
        return (HttpURLConnection)urlObj.openConnection();
    }

    public String postMessage(String xmlString, String serviceURL) throws IOException {
        String str;
        StringBuffer content = new StringBuffer();
        URL url = new URL(serviceURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-type", "text/xml");
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        String msg = xmlString;
        wr.writeBytes(msg);
        wr.flush();
        wr.close();
        int responseCode = conn.getResponseCode();
        BufferedReader in = responseCode > 299 ? new BufferedReader(new InputStreamReader(conn.getErrorStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((str = in.readLine()) != null) {
            content.append(str);
        }
        in.close();
        return content.toString();
    }

    public String sendGetRequest(String serviceURL, String param) throws IOException {
        String str;
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = this.GetConnection(serviceURL, param);
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((str = in.readLine()) != null) {
            response.append(str);
        }
        in.close();
        return response.toString();
    }

    public Map<String, String> getStandardBindings() {
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.put("http://www.w3.org/1999/xlink", "xlink");
        nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
        nsBindings.put("http://www.opengis.net/wps/1.0.0", "wps");
        return nsBindings;
    }

    public String CheckXPath2(String xpath, Document testSubject) {
        Object xdmValue = null;
        try {
            xdmValue = this.evaluateXPath2(new DOMSource(testSubject), xpath, this.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    public XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        net.sf.saxon.s9api.DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap(domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem(node);
        return xpath.evaluate();
    }

    private static StringBuilder sendRequestByPOST(String requestURL, String XML) throws IOException {
        URL obj = new URL(requestURL);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestProperty("Content-Type", "application/xml");
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        os.write(XML.getBytes());
        os.flush();
        os.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = con.getInputStream();
            byte[] res = new byte[2048];
            int i = 0;
            StringBuilder response = new StringBuilder();
            while ((i = inputStream.read(res)) != -1) {
                response.append(new String(res, 0, i));
            }
            inputStream.close();
            return response;
        }
        System.out.println("HTTP POST request not worked");
        return null;
    }

    private static boolean isHTTPValid(String urlString, String reqMethod) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(reqMethod);
        int statusCode = con.getResponseCode();
        return statusCode / 100 == 2;
    }

    private static boolean isXMLSchemaValid(String xsdPath, String xmlString) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new File(xsdPath));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xmlString)));
        }
        catch (IOException | SAXException e) {
            System.out.println("Exception: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static String getStringFromXML(Document xmlDocument) {
        String xmlString = "";
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(xmlDocument), new StreamResult(writer));
            xmlString = writer.getBuffer().toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlString;
    }
}

