/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps10.level1;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.wps10.DataFixture;
import org.opengis.cite.wps10.util.ValidationUtils;
import org.opengis.cite.wps10.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GetCapabilitiesValidation
extends DataFixture {
    @Test(groups={"A.4.2. GetCapabilities operation test module"}, description="Verify that a server accepts at least HTTP GET transferred requests for the GetCapabilities operation")
    public void HTTPGETTransferredKVPGetCapabilitiesValidation() throws IOException, URISyntaxException {
        String serviceURL = this.testSubjectUri.toString();
        ArrayList<String> params = new ArrayList<String>();
        params.add(0, "?service=wps&request=GetCapabilities");
        params.add(1, "?service=wps&request=GetCapabilities&AcceptVersions=1.0.0");
        params.add(2, "?service=wps&request=GetCapabilities&aCcepTVersioNS=1.0.0");
        HashSet<Integer> res = new HashSet<Integer>();
        for (String param : params) {
            HttpURLConnection connection = this.GetConnection(serviceURL, param);
            connection.setRequestMethod("GET");
            Integer responseCode = connection.getResponseCode();
            res.add(responseCode);
            Assert.assertTrue(responseCode < 300, "The server does not provides the same response when the same parameter names use different cases and combinations of cases");
        }
        boolean result = res.size() == 1;
        Assert.assertTrue(result, "The server does not provides the same response when the same parameter names use different cases and combinations of cases");
    }

    @Test(groups={"A.4.2. GetCapabilities operation test module"}, description="Verify that a server accepts at HTTP POST transferred requests for the GetCapabilities operation if advertised in the GetCapabilities Response")
    public void HTTPPOSTTransferredXMLGetCapabilitiesValidation() throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        String serviceURL = this.testSubjectUri.toString();
        String msgCorrect = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:GetCapabilities service=\"WPS\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsGetCapabilities_request.xsd\"><wps:AcceptVersions><ows:Version xmlns:ows=\"http://www.opengis.net/ows/1.1\">1.0.0</ows:Version></wps:AcceptVersions></wps:GetCapabilities>";
        String responseCorrect = this.postMessage(msgCorrect, serviceURL);
        InputSource source = new InputSource(new StringReader(responseCorrect));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(source);
        String candidateNode = this.CheckXPath2("//wps:Capabilities", document);
        boolean correctResultRequest = !candidateNode.contains("XdmEmptySequence");
        String msgWrong = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:getcapabilities service=\"WPS\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsGetCapabilities_request.xsd\"><wps:AcceptVersions><ows:Version xmlns:ows=\"http://www.opengis.net/ows/1.1\">1.0.0</ows:Version></wps:AcceptVersions></wps:GetCapabilities>";
        String responseWrong = this.postMessage(msgWrong, serviceURL);
        InputSource sourceWR = new InputSource(new StringReader(responseWrong));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        String candidateNodeWR = this.CheckXPath2("//ows:ExceptionReport", documentWR);
        boolean wrongResultRequest = !candidateNodeWR.contains("XdmEmptySequence");
        boolean finalResult = correctResultRequest && wrongResultRequest;
        Assert.assertTrue(finalResult, "The server does not accepts at HTTP POST transferred requests for the GetCapabilities operation");
    }

    @Test(groups={"A.4.2. GetCapabilities operation test module"}, description="Verify that a server satisfies all requirements on the GetCapabilities operation response")
    public void GetCapabilitiesResponseValidation() throws IOException, SAXException {
        String serviceURL = this.testSubjectUri.toString();
        ArrayList<String> params = new ArrayList<String>();
        params.add(0, "?service=wps&request=GetCapabilities");
        params.add(1, "?service=wps&request=GetCapabilities&AcceptVersions=1.0.0");
        HashSet<Boolean> res = new HashSet<Boolean>();
        for (String param : params) {
            String response = this.sendGetRequest(serviceURL, param);
            String xsdPath = "xsd/opengis/wps/1.0/wpsGetCapabilities_response.xsd";
            boolean resultValidation = this.validateXMLString(response, xsdPath);
            res.add(resultValidation);
        }
        boolean result = res.size() == 1;
        Assert.assertTrue(result, "The server does not satisfies all requirements on the GetCapabilities operation response");
    }

    @Test(enabled=true, groups={"A.4.2. GetCapabilities operation test module"}, description="Verify that a server satisfies the requirements for version negotiation")
    public void VersionNegotiationGetCapabilitiesValidation() throws IOException, SaxonApiException, SAXException, ParserConfigurationException {
        String serviceURL = this.testSubjectUri.toString();
        String response = this.sendGetRequest(serviceURL, "?service=wps&request=GetCapabilities&language=en-US");
        InputSource sourceWR = new InputSource(new StringReader(response));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        XdmValue xdmValue = XMLUtils.evaluateXPath2(new DOMSource(documentWR), "//ows:ServiceTypeVersion", this.getStandardBindings());
        int higherSupportVersion = 0;
        int lowerSupportVersion = 0;
        if (xdmValue.size() == 0) {
            Assert.assertTrue(false, "The server does not satisfies the requirements for version negotiation.");
        } else if (xdmValue.size() > 0) {
            higherSupportVersion = Integer.parseInt(xdmValue.itemAt(0).getStringValue().replace(".", ""));
            lowerSupportVersion = Integer.parseInt(xdmValue.itemAt(0).getStringValue().replace(".", ""));
        }
        for (XdmItem xdmItem : xdmValue) {
            System.out.println(xdmItem.getStringValue());
            int version = Integer.parseInt(xdmItem.getStringValue().replace(".", ""));
            if (version > higherSupportVersion) {
                higherSupportVersion = version;
            }
            if (version < lowerSupportVersion) {
                lowerSupportVersion = version;
            }
            System.out.println(version);
        }
        int currentResponseVersion = 0;
        XdmValue xdmValue2 = XMLUtils.evaluateXPath2(new DOMSource(documentWR), "/wps:Capabilities/@version", this.getStandardBindings());
        if (xdmValue2.size() != 1) {
            Assert.assertTrue(false, "The server does not satisfies the requirements for version negotiation.");
        } else {
            System.out.println("A" + xdmValue2.itemAt(0).getStringValue() + "A");
            currentResponseVersion = Integer.parseInt(xdmValue2.itemAt(0).getStringValue().replace(".", ""));
        }
        boolean result = currentResponseVersion == higherSupportVersion;
        Assert.assertTrue(result, "The server does not satisfies the requirements for version negotiation.");
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(0, "?service=wps&request=GetCapabilities&language=en-US&AcceptVersions=3.0.0");
        paramList.add(1, "?service=wps&request=GetCapabilities&language=en-US&AcceptVersions=0.0.1");
        for (String param : paramList) {
            String exceptionResponse = this.sendGetRequest(serviceURL, param);
            String exceptionNode = this.CheckXPath2("//ows:Exception[@exceptionCode='VersionNegotiationFailed']", exceptionResponse);
            boolean exceptionResult = !exceptionNode.contains("XdmEmptySequence");
            Assert.assertTrue(exceptionResult, "The server does not satisfies the requirements for version negotiation.");
        }
        String supportVersionParam = "?service=wps&request=GetCapabilities&language=en-US&AcceptVersions=1.0.0";
        String supportVersionResponse = this.sendGetRequest(serviceURL, supportVersionParam);
        String node = this.CheckXPath2("/wps:Capabilities[@version='1.0.0']", supportVersionResponse);
        boolean supportVersionResult = !node.contains("XdmEmptySequence");
        Assert.assertTrue(supportVersionResult, "The server does not satisfies the requirements for version negotiation.");
    }

    @Test(enabled=true, groups={"A.4.2. GetCapabilities operation test module"}, description="Verify that a server satisfies the requirements for generating and using the updateSequence parameter, if the server implements the AcceptFormats request parameter.")
    public void HandlingUpdateSequenceValidation() throws IOException, SAXException {
        String serviceURL = this.testSubjectUri.toString();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(0, "?service=wps&request=GetCapabilities&AcceptVersions=1.0.0&AcceptFormats=text/xml");
        paramList.add(1, "?service=wps&request=GetCapabilities&AcceptVersions=1.0.0&AcceptFormats=application/x-bxml");
        for (String param : paramList) {
            String response = this.sendGetRequest(serviceURL, param);
            String xsdPath = "xsd/opengis/wps/1.0/wpsGetCapabilities_response.xsd";
            System.out.println("A.4.2.5: Send 'http get' request to: " + serviceURL + param);
            boolean isValid = false;
            isValid = this.validateXMLString(response, xsdPath);
            Assert.assertTrue(isValid, "The server does not satisfies the requirements for generating and using the updateSequence parameter.");
        }
    }

    @Test(groups={"A.4.2. GetCapabilities operation test module"}, description="Verify that a server satisfies the requirements for using the Language parameter.")
    public void LanguageSelectionGetCapabilitiesValidation() throws IOException, ParserConfigurationException, SAXException, SaxonApiException {
        String serviceURL = this.testSubjectUri.toString();
        String response = this.sendGetRequest(serviceURL, "?service=wps&request=GetCapabilities&AcceptVersions=1.0.0");
        InputSource sourceWR = new InputSource(new StringReader(response));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        XdmValue xdmValue = XMLUtils.evaluateXPath2(new DOMSource(documentWR), "/wps:Capabilities/wps:Languages/wps:Supported/ows:Language", this.getStandardBindings());
        if (xdmValue.size() == 0) {
            Assert.assertTrue(false, "The server does not satisfies the requirements for using the Language parameter.");
        }
        ArrayList<String> supportLanguageList = new ArrayList<String>();
        for (XdmItem xdmItem : xdmValue) {
            String language = xdmItem.getStringValue();
            supportLanguageList.add(language);
            System.out.println(language);
        }
        for (String language : supportLanguageList) {
            String languageSelectionResponse = this.sendGetRequest(serviceURL, "?service=wps&request=GetCapabilities&language=" + language);
            InputSource source = new InputSource(new StringReader(languageSelectionResponse));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document document = documentBuilder.parse(source);
            XdmValue languageXdmValue = XMLUtils.evaluateXPath2(new DOMSource(document), "/wps:Capabilities/@xml:lang", this.getStandardBindings());
            System.out.println(languageXdmValue.toString());
            boolean result = languageXdmValue.toString().contains(language);
            Assert.assertTrue(result, "The server does not satisfies the requirements for using the Language parameter.");
        }
    }

    public int sendHTTPGetRequestGetCapabilitiesOperationByVersion(String version) throws IOException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&request=GetCapabilities&language=en-US&AcceptVersions=" + version;
        HttpURLConnection connection = this.getConnection(serviceURL, param);
        connection.setRequestMethod("GET");
        System.out.println("A.4.2.4: Send 'http get' request to: " + serviceURL + param);
        Integer responseCode = connection.getResponseCode();
        System.out.println("A.4.2.4: Response Code: " + responseCode);
        return responseCode;
    }

    public HttpURLConnection getConnection(String serviceURL, String param) throws IOException {
        URL urlObj = new URL(serviceURL + param);
        return (HttpURLConnection)urlObj.openConnection();
    }

    public HttpURLConnection GetConnection(String serviceURL, String param) throws IOException {
        URL urlObj = new URL(serviceURL + param);
        return (HttpURLConnection)urlObj.openConnection();
    }

    public String postMessage(String xmlString, String serviceURL) throws IOException {
        String str;
        StringBuffer content = new StringBuffer();
        URL url = new URL(serviceURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-type", "text/xml");
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        String msg = xmlString;
        wr.writeBytes(msg);
        wr.flush();
        wr.close();
        int responseCode = conn.getResponseCode();
        BufferedReader in = responseCode > 299 ? new BufferedReader(new InputStreamReader(conn.getErrorStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((str = in.readLine()) != null) {
            content.append(str);
        }
        in.close();
        return content.toString();
    }

    public String sendGetRequest(String serviceURL, String param) throws IOException {
        String str;
        String dURL = URLDecoder.decode(serviceURL);
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = this.GetConnection(dURL, param);
        int responseCode = conn.getResponseCode();
        BufferedReader in = responseCode > 299 ? new BufferedReader(new InputStreamReader(conn.getErrorStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((str = in.readLine()) != null) {
            response.append(str);
        }
        in.close();
        return response.toString();
    }

    public Map<String, String> getStandardBindings() {
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.put("http://www.w3.org/1999/xlink", "xlink");
        nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
        nsBindings.put("http://www.opengis.net/wps/1.0.0", "wps");
        return nsBindings;
    }

    public String CheckXPath2(String xpath, Document testSubject) {
        Object xdmValue = null;
        try {
            xdmValue = this.evaluateXPath2(new DOMSource(testSubject), xpath, this.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    public String CheckXPath2(String xpath, String response) throws ParserConfigurationException, SAXException, IOException {
        InputSource sourceWR = new InputSource(new StringReader(response));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        Object xdmValue = null;
        try {
            xdmValue = XMLUtils.evaluateXPath2(new DOMSource(documentWR), xpath, this.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    public XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        net.sf.saxon.s9api.DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap(domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem(node);
        return xpath.evaluate();
    }

    public boolean validateXMLString(String inputXml, String schemaLocation) throws SAXException, IOException {
        Schema schema = ValidationUtils.createSchema(schemaLocation);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new StringReader(inputXml));
        boolean isValid = true;
        try {
            validator.validate(source);
        }
        catch (SAXException e) {
            isValid = false;
        }
        return isValid;
    }
}

