/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps10.level1;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.wps10.DataFixture;
import org.opengis.cite.wps10.util.ValidationUtils;
import org.opengis.cite.wps10.util.XMLUtils;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescribeProcessValidation
extends DataFixture {
    String processId = "";

    @BeforeClass
    public void beforeClass() throws IOException, ParserConfigurationException, SAXException, SaxonApiException {
        String serviceURL = this.testSubjectUri.toString();
        String response = this.sendGetRequest(serviceURL, "?service=wps&request=GetCapabilities&language=en-US");
        InputSource sourceWR = new InputSource(new StringReader(response));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        XdmValue xdmValue = XMLUtils.evaluateXPath2(new DOMSource(documentWR), "//ows:Identifier", this.getStandardBindings());
        if (xdmValue.size() != 0) {
            this.processId = xdmValue.itemAt(0).getStringValue();
        }
        this.CheckServiceHasProcess();
    }

    private void CheckServiceHasProcess() {
        if (this.processId.isEmpty()) {
            throw new SkipException("Skip the DescribeProcess validation test due to no process offering.");
        }
    }

    @Test(groups={"A.4.3. DescribeProcess operation test module"}, description="Verify that a server accepts at least HTTP GET transferred requests for the DescribeProcess operation")
    public void HTTPGETTransferredKVPDescribeProcessValidation() throws IOException, URISyntaxException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&version=1.0.0&request=DescribeProcess&Identifier=" + this.processId;
        HttpURLConnection connection = this.GetConnection(serviceURL, param);
        connection.setRequestMethod("GET");
        Integer responseCode = connection.getResponseCode();
        boolean result = responseCode == 200;
        Assert.assertTrue((boolean)result, (String)"The server does not accepts HTTP GET transferred requests for the DescribeProcess operation");
    }

    @Test(groups={"A.4.3. DescribeProcess operation test module"}, description="Verify that a server accepts at HTTP POST transferred requests for the DescribeProcess operation")
    public void HTTPPOSTTransferredXMLDescribeProcessValidation() throws IOException, URISyntaxException, ParserConfigurationException, SAXException, SaxonApiException {
        String serviceURL = this.testSubjectUri.toString();
        String msgCorrect = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wps:DescribeProcess service=\"WPS\" version=\"1.0.0\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsDescribeProcess_request.xsd\"><ows:Identifier>" + this.processId + "</ows:Identifier></wps:DescribeProcess>";
        String responseCorrect = this.postMessage(msgCorrect, serviceURL);
        InputSource source = new InputSource(new StringReader(responseCorrect));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(source);
        String candidateNode = this.CheckXPath2("//wps:ProcessDescriptions", document);
        boolean correctResultRequest = !candidateNode.contains("XdmEmptySequence");
        Assert.assertTrue((boolean)correctResultRequest, (String)"The server does not accepts at HTTP POST transferred requests for the DescribeProcess operation");
    }

    @Test(groups={"A.4.3. DescribeProcess operation test module"}, description="Verify that a server satisfies all requirements on the DescribeProcess operation response.")
    public void DescribeProcessResponseValidation() throws IOException, SAXException {
        String serviceURL = this.testSubjectUri.toString();
        String param = "?service=wps&version=1.0.0&request=DescribeProcess&Identifier" + this.processId;
        String response = this.sendGetRequest(serviceURL, param);
        String xsdPath = "xsd/opengis/wps/1.0/wpsDescribeProcess_response.xsd";
        boolean resultValidation = this.validateXMLString(response, xsdPath);
        Assert.assertTrue((boolean)resultValidation, (String)"The server does not satisfies all requirements on the DescribeProcess operation response");
    }

    @Test(groups={"A.4.3. DescribeProcess operation test module"}, description="Verify that a server satisfies the requirements for using the Language parameter for the DescribeProcess operation.")
    public void LanguageSelectionGetCapabilitiesValidation() throws IOException, ParserConfigurationException, SAXException, SaxonApiException {
        String serviceURL = this.testSubjectUri.toString();
        String response = this.sendGetRequest(serviceURL, "?service=wps&request=GetCapabilities&AcceptVersions=1.0.0");
        InputSource sourceWR = new InputSource(new StringReader(response));
        DocumentBuilderFactory dbfWR = DocumentBuilderFactory.newInstance();
        DocumentBuilder dbWR = dbfWR.newDocumentBuilder();
        Document documentWR = dbWR.parse(sourceWR);
        XdmValue xdmValue = XMLUtils.evaluateXPath2(new DOMSource(documentWR), "/wps:Capabilities/wps:Languages/wps:Supported/ows:Language", this.getStandardBindings());
        if (xdmValue.size() == 0) {
            Assert.assertTrue((boolean)false, (String)"The server does not satisfies the requirements for using the Language parameter.");
        }
        ArrayList<String> supportLanguageList = new ArrayList<String>();
        for (XdmItem xdmItem : xdmValue) {
            String language = xdmItem.getStringValue();
            supportLanguageList.add(language);
            System.out.println(language);
        }
        for (String language : supportLanguageList) {
            String languageSelectionResponse = this.sendGetRequest(serviceURL, "?service=wps&request=DescribeProcess&Version=1.0.0&identifier=" + this.processId + "&language=" + language);
            InputSource source = new InputSource(new StringReader(languageSelectionResponse));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document document = documentBuilder.parse(source);
            XdmValue languageXdmValue = XMLUtils.evaluateXPath2(new DOMSource(document), "/wps:ProcessDescriptions/@xml:lang", this.getStandardBindings());
            System.out.println(languageXdmValue.toString());
            boolean result = languageXdmValue.toString().contains(language);
            Assert.assertTrue((boolean)result, (String)"The server does not satisfies the requirements for using the Language parameter.");
        }
    }

    public HttpURLConnection GetConnection(String serviceURL, String param) throws IOException {
        URL urlObj = new URL(serviceURL + param);
        return (HttpURLConnection)urlObj.openConnection();
    }

    public String sendGetRequest(String serviceURL, String param) throws IOException {
        String str;
        String dURL = URLDecoder.decode(serviceURL);
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = this.GetConnection(dURL, param);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-type", "text/xml");
        conn.setDoOutput(true);
        BufferedReader in = conn.getResponseCode() < 400 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
        while ((str = in.readLine()) != null) {
            response.append(str);
        }
        in.close();
        return response.toString();
    }

    public Map<String, String> getStandardBindings() {
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.put("http://www.w3.org/1999/xlink", "xlink");
        nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
        nsBindings.put("http://www.opengis.net/wps/1.0.0", "wps");
        return nsBindings;
    }

    public boolean validateXMLString(String inputXml, String schemaLocation) throws SAXException, IOException {
        Schema schema = ValidationUtils.createSchema(schemaLocation);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new StringReader(inputXml));
        boolean isValid = true;
        try {
            validator.validate(source);
        }
        catch (SAXException e) {
            isValid = false;
        }
        return isValid;
    }

    public String CheckXPath2(String xpath, Document testSubject) {
        Object xdmValue = null;
        try {
            xdmValue = this.evaluateXPath2(new DOMSource(testSubject), xpath, this.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    public String postMessage(String xmlString, String serviceURL) throws IOException {
        String str;
        StringBuffer content = new StringBuffer();
        URL url = new URL(serviceURL);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-type", "text/xml");
        conn.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        String msg = xmlString;
        wr.writeBytes(msg);
        wr.flush();
        wr.close();
        int responseCode = conn.getResponseCode();
        BufferedReader in = responseCode > 299 ? new BufferedReader(new InputStreamReader(conn.getErrorStream())) : new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((str = in.readLine()) != null) {
            content.append(str);
        }
        in.close();
        return content.toString();
    }

    public XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        net.sf.saxon.s9api.DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap((Object)domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem((XdmItem)node);
        return xpath.evaluate();
    }
}

