/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps10.level1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.wps10.DataFixture;
import org.opengis.cite.wps10.util.ValidationUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExecuteValidation
extends DataFixture {
    @Test(enabled=true, groups={"A.4.4. Execute operation test module"}, description="A.4.4.1. Accept Execute HTTP GET transferred Execute operation requests")
    public void HTTPGETTransferredExecuteValidation() throws IOException, URISyntaxException {
        String serviceURL = this.testSubjectUri.toString();
        String parameters = "service=wps&request=GetCapabilities&version=1.0.0";
        String req = serviceURL + "?" + parameters;
        boolean status = false;
        String msg = null;
        boolean isValid = ExecuteValidation.isHTTPValid(req, "GET");
        if (isValid) {
            String xsdPath = "xsd/opengis/wps/1.0/wpsExecute_response.xsd";
            String HttpGetServiceURL = this.executeHttpGetUri.toString();
            StringBuilder xmlResponse = ExecuteValidation.sendRequestByGET(HttpGetServiceURL, "");
            status = ExecuteValidation.isXMLSchemaValid(xsdPath, xmlResponse.toString());
            msg = "The server does not satisfies all requirements on the Execute operation response";
        } else {
            status = isValid;
            msg = "The server does not respond to HTTP GET request";
        }
        Assert.assertTrue((boolean)status, (String)msg);
    }

    @Test(enabled=true, groups={"A.4.4. Execute operation test module"}, description="A.4.4.2. Accept Execute HTTP POST transferred Execute operation requests")
    public void HTTPPOSTTransferredExecuteValidation() throws IOException {
        this.PostRawDataOutputExecuteValidation();
    }

    @Test(enabled=true, groups={"A.4.4. Execute operation test module"}, description="A.4.4.3. Execute operation response: raw data output")
    public void RawDataOutputExecuteValidation() throws IOException {
        this.PostRawDataOutputExecuteValidation();
    }

    private void PostRawDataOutputExecuteValidation() throws IOException {
        String serviceURL = this.testSubjectUri.toString();
        String parameters = "service=wps&request=GetCapabilities&version=1.0.0";
        boolean status = false;
        String msg = null;
        boolean isValid = ExecuteValidation.isHTTPValid(serviceURL + "?" + parameters, "GET");
        if (isValid) {
            boolean isRequestValid;
            String xsdReqPath = "xsd/opengis/wps/1.0/wpsExecute_request.xsd";
            String xmlString = ExecuteValidation.getStringOfXmlDocument(this.executeRequestFileRawDataOutputSubject);
            boolean bl = isRequestValid = ExecuteValidation.isXMLSchemaValid(xsdReqPath, xmlString.toString());
            if (isRequestValid) {
                status = isRequestValid;
                msg = "The server does not satisfies all requirements on the Execute operation response";
            } else {
                status = isRequestValid;
                msg = "The server does not respond to invalid request";
            }
        } else {
            status = isValid;
            msg = "The server does not respond to HTTP POST request";
        }
        Assert.assertTrue((boolean)status, (String)msg);
    }

    @Test(enabled=true, groups={"A.4.4. Execute operation test module"}, description="A.4.4.4. Execute operation response: response document")
    public void ResponseDocumentExecuteValidation() throws IOException, URISyntaxException {
        String serviceURL = this.testSubjectUri.toString();
        String parameters = "service=wps&request=GetCapabilities&version=1.0.0";
        boolean status = false;
        String msg = null;
        boolean isValid = ExecuteValidation.isHTTPValid(serviceURL + "?" + parameters, "GET");
        if (isValid) {
            boolean isRequestValid;
            String xsdReqPath = "xsd/opengis/wps/1.0/wpsExecute_request.xsd";
            String xmlString = ExecuteValidation.getStringOfXmlDocument(this.executeRequestFileResponseDocumentOutputSubject);
            boolean bl = isRequestValid = ExecuteValidation.isXMLSchemaValid(xsdReqPath, xmlString.toString());
            if (isRequestValid) {
                String xsdPath = "xsd/opengis/wps/1.0/wpsExecute_response.xsd";
                StringBuilder xmlResponse = ExecuteValidation.sendRequestByPOST(serviceURL, xmlString);
                status = ExecuteValidation.isXMLSchemaValid(xsdPath, xmlResponse.toString());
                msg = "The server does not satisfies all requirements on the Execute operation response";
            } else {
                status = isRequestValid;
                msg = "The server does not respond to invalid request";
            }
        } else {
            status = isValid;
            msg = "The server does not respond to HTTP POST request";
        }
        Assert.assertTrue((boolean)status, (String)msg);
    }

    @Test(enabled=true, groups={"A.4.4. Execute operation test module"}, description="A.4.4.5. Execute operation response: updating of response document")
    public void UpdatingResponseDocumentExecuteValidation() throws IOException, URISyntaxException {
        String serviceURL = this.testSubjectUri.toString();
        String parameters = "service=wps&request=GetCapabilities&version=1.0.0";
        boolean status = false;
        String msg = null;
        boolean isValid = ExecuteValidation.isHTTPValid(serviceURL + "?" + parameters, "GET");
        if (isValid) {
            boolean isRequestValid;
            String xsdReqPath = "xsd/opengis/wps/1.0/wpsExecute_request.xsd";
            String xmlString = ExecuteValidation.getStringOfXmlDocument(this.executeRequestFileUpdatingResponseDocumentOutputSubject);
            boolean bl = isRequestValid = ExecuteValidation.isXMLSchemaValid(xsdReqPath, xmlString.toString());
            if (isRequestValid) {
                boolean isResponseValid;
                String xsdPath = "xsd/opengis/wps/1.0/wpsExecute_response.xsd";
                StringBuilder xmlResponse = ExecuteValidation.sendRequestByPOST(serviceURL, xmlString);
                boolean bl2 = isResponseValid = ExecuteValidation.isXMLSchemaValid(xsdPath, xmlResponse.toString());
                if (isResponseValid) {
                    String xsdLocPath = "xsd/opengis/wps/1.0/wpsExecute_response.xsd";
                    Document locationDoc = ExecuteValidation.convertStringToXMLDocument(xmlResponse.toString());
                    String location = locationDoc.getFirstChild().getAttributes().getNamedItem("statusLocation").getNodeValue();
                    StringBuilder xmlLocationResponse = ExecuteValidation.sendRequestByGET(location, "");
                    status = ExecuteValidation.isXMLSchemaValid(xsdLocPath, xmlLocationResponse.toString());
                    msg = "The server does not satisfies all requirements on the Execute operation response";
                } else {
                    status = isResponseValid;
                    msg = "The server does not return valid response";
                }
            } else {
                status = isRequestValid;
                msg = "The server does not respond to invalid request";
            }
        } else {
            status = isValid;
            msg = "The server does not respond to HTTP POST request";
        }
        Assert.assertTrue((boolean)status, (String)msg);
    }

    @Test(enabled=true, groups={"A.4.4. Execute operation test module"}, description="A.4.4.6. Language selection")
    public void LanguageSelectionExecuteValidation() throws IOException, URISyntaxException {
        String serviceURL;
        String HttpGetServiceURL = this.executeHttpGetUri.toString();
        String req = serviceURL = URLDecoder.decode(HttpGetServiceURL);
        boolean status = false;
        String msg = null;
        boolean isValid = ExecuteValidation.isHTTPValid(req, "GET");
        if (isValid) {
            boolean isLanguageValid = ExecuteValidation.isHTTPValid(req + "&Language=en-US", "GET");
            if (isLanguageValid) {
                String xsdPath = "xsd/opengis/wps/1.0/wpsExecute_response.xsd";
                StringBuilder xmlResponse = ExecuteValidation.sendRequestByGET(serviceURL, "");
                status = ExecuteValidation.isXMLSchemaValid(xsdPath, xmlResponse.toString());
                msg = "The server does not satisfies all requirements on the Execute operation response";
            } else {
                status = isLanguageValid;
                msg = "The server does not respond to Language parameter";
            }
        } else {
            status = isValid;
            msg = "The server does not respond to HTTP GET request";
        }
        Assert.assertTrue((boolean)status, (String)msg);
    }

    private static StringBuilder sendRequestByGET(String requestURL, String parameters) throws IOException {
        String dURL = URLDecoder.decode(requestURL);
        URL obj = new URL(dURL + "?" + parameters);
        if (parameters == "" || parameters == null) {
            obj = new URL(dURL);
        }
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = con.getInputStream();
            byte[] res = new byte[2048];
            int i = 0;
            StringBuilder response = new StringBuilder();
            while ((i = inputStream.read(res)) != -1) {
                response.append(new String(res, 0, i));
            }
            inputStream.close();
            return response;
        }
        System.out.println("HTTP GET request not worked");
        return null;
    }

    private static StringBuilder sendRequestByPOST(String requestURL, String XML) throws IOException {
        URL obj = new URL(requestURL);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestProperty("Content-Type", "application/xml");
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        OutputStream os = con.getOutputStream();
        os.write(XML.getBytes());
        os.flush();
        os.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = con.getInputStream();
            byte[] res = new byte[2048];
            int i = 0;
            StringBuilder response = new StringBuilder();
            while ((i = inputStream.read(res)) != -1) {
                response.append(new String(res, 0, i));
            }
            inputStream.close();
            return response;
        }
        System.out.println("HTTP POST request not worked");
        return null;
    }

    private static boolean isHTTPValid(String urlString, String reqMethod) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(reqMethod);
        int statusCode = con.getResponseCode();
        return statusCode / 100 == 2;
    }

    private static boolean isXMLSchemaValid(String xsdPath, String xmlString) {
        try {
            Schema schema = ValidationUtils.createSchema(xsdPath);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xmlString)));
        }
        catch (IOException | SAXException e) {
            System.out.println("Exception: " + e.getMessage());
            return false;
        }
        return true;
    }

    public Map<String, String> getStandardBindings() {
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.put("http://www.w3.org/1999/xlink", "xlink");
        nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
        nsBindings.put("http://www.opengis.net/wps/1.0.0", "wps");
        return nsBindings;
    }

    public String CheckXPath2(String xpath, Document testSubject) {
        Object xdmValue = null;
        try {
            xdmValue = this.evaluateXPath2(new DOMSource(testSubject), xpath, this.getStandardBindings());
        }
        catch (SaxonApiException e) {
            e.printStackTrace();
        }
        return xdmValue.toString();
    }

    public XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        net.sf.saxon.s9api.DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap((Object)domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem((XdmItem)node);
        return xpath.evaluate();
    }

    private static Document convertStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getStringOfXmlDocument(Document xmlDocument) {
        String xmlString = "";
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer t = tf.newTransformer();
            StringWriter sw = new StringWriter();
            t.transform(new DOMSource(xmlDocument), new StreamResult(sw));
            xmlString = sw.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlString;
    }
}

