/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20.level1;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.validation.RelaxNGValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.opengis.cite.wps20.CommonFixture;
import org.opengis.cite.wps20.ErrorMessage;
import org.opengis.cite.wps20.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Capability1Tests
extends CommonFixture {
    private Document testSubject;

    @BeforeClass
    public void obtainTestSubject(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null != obj && Document.class.isAssignableFrom(obj.getClass())) {
            this.testSubject = (Document)Document.class.cast(obj);
        }
    }

    public void setTestSubject(Document testSubject) {
        this.testSubject = testSubject;
    }

    @Test(description="Implements ATC 1-1")
    public void isEmpty() {
        String str = "  foo   ";
        Assert.assertTrue(str.isEmpty(), ErrorMessage.get("EmptyString"));
    }

    @Test(description="Implements ATC 1-2")
    public void trim() {
        String str = "  foo   ";
        Assert.assertTrue("foo".equals(str.trim()));
    }

    @Test(description="Implements ATC 1-3")
    public void docIsValidAtomFeed() throws SAXException, IOException {
        URL schemaRef = this.getClass().getResource("/org/opengis/cite/wps20/rnc/atom.rnc");
        RelaxNGValidator rngValidator = new RelaxNGValidator(schemaRef);
        DOMSource xmlSource = null != this.testSubject ? new DOMSource(this.testSubject) : null;
        rngValidator.validate(xmlSource);
        ValidationErrorHandler err = rngValidator.getErrorHandler();
        Assert.assertFalse(err.errorsDetected(), ErrorMessage.format("NotSchemaValid", err.getErrorCount(), err.toString()));
    }
}

