/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20.level1;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.wps20.CommonFixture;
import org.opengis.cite.wps20.util.URIUtils;
import org.opengis.cite.wps20.util.ValidationUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BasicTests
extends CommonFixture {
    String GET_CAPABILITIES_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/GetCapabilities.xml";
    String DESCRIBE_PROCESS_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/DescribeProcess.xml";
    String LITERAL_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/Echo_Process_Literal.xml";
    String COMPLEX_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/Echo_Process_Complex.xml";
    String INPUT_VALUE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidInputValue.xml";
    String INPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidInputReference.xml";
    String OUTPUT_VALUE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidOutputValue.xml";
    String OUTPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidOutputReference.xml";
    String UNIQUE_JOB_IDS_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidUniqueJobIds.xml";

    @Test(enabled=true, dependsOnMethods={}, groups={"A.4. WPS Process Model Encoding"}, description="A.4.1. Verify that a given process description is in compliance with the Process XML encoding")
    private void VerifyProcessXMLEncoding() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(this.LITERAL_REQUEST_TEMPLATE_PATH).toURI();
        Document SEPDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        String ECHO_PROCESS_ID = this.EchoProcessId;
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", ECHO_PROCESS_ID);
        String VPE_String = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Boolean VPE_Flag = null;
        if (BasicTests.isXMLSchemaValid(VPE_String, "xsd/opengis/wps/2.0/wps.xsd")) {
            VPE_Flag = true;
            String msg = "Valid Process XML Encoding for WPS 2.0";
            Assert.assertTrue((boolean)VPE_Flag, (String)msg);
        } else {
            VPE_Flag = false;
            String msg = "Invalid Process XML Encoding for WPS 2.0";
            Assert.assertTrue((boolean)VPE_Flag, (String)msg);
        }
    }

    @Test(enabled=true, dependsOnMethods={}, groups={"A.4. WPS Process Model Encoding"}, description="A.4.3. Verify that any XML data type description and values that are used in conjunction with the native process model are encoded in compliance with the process model XML encoding.")
    private void VerifyProcessDataTypeXMLEncoding() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(this.LITERAL_REQUEST_TEMPLATE_PATH).toURI();
        Document SEPDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        String ECHO_PROCESS_ID = this.EchoProcessId;
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", ECHO_PROCESS_ID);
        String VPE_String = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Document VPE_Document = BasicTests.TransformXMLStringToXMLDocument(VPE_String);
        Boolean HLCB_Flag = true;
        if (VPE_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").getLength() == 0) {
            HLCB_Flag = false;
        }
        if (VPE_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").getLength() == 0) {
            HLCB_Flag = false;
        }
        if (VPE_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "BoundingBoxData").getLength() == 0) {
            HLCB_Flag = false;
        }
        if (HLCB_Flag.booleanValue()) {
            Boolean VPE_Flag = null;
            String msg = null;
            if (BasicTests.isXMLSchemaValid(VPE_String, "xsd/opengis/wps/2.0/wps.xsd")) {
                VPE_Flag = true;
                msg = "Valid Process DataTypes XML Encoding for WPS 2.0";
            } else {
                VPE_Flag = false;
                msg = "Invalid Process DataTypes XML Encoding for WPS 2.0";
            }
            Assert.assertTrue((boolean)VPE_Flag, (String)msg);
        } else {
            String msg = "The process should include ComplexData, LiteralData and BoundingBoxData";
            Assert.assertTrue((boolean)HLCB_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="Precondition: Verify that the server can handle echo process")
    public void ValidEchoProcess() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(this.LITERAL_REQUEST_TEMPLATE_PATH).toURI();
        Document SEPDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        String ECHO_PROCESS_ID = this.EchoProcessId;
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", ECHO_PROCESS_ID);
        String responseDescribeProcess = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Document responseDescribeProcessDocument = BasicTests.TransformXMLStringToXMLDocument(responseDescribeProcess);
        NodeList inputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input");
        String literalInputId = "";
        String literalOutputId = "";
        String complexInputId = "";
        String complexOutputId = "";
        for (int i = 0; i < inputList.getLength(); ++i) {
            Element element = (Element)inputList.item(i);
            Element literalInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element complexInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalInputElement != null) {
                literalInputId = Id;
                continue;
            }
            if (complexInputElement == null) continue;
            complexInputId = Id;
        }
        NodeList outputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output");
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element element = (Element)outputList.item(i);
            Element literalOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element complexOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalOutputElement != null) {
                literalOutputId = Id;
                continue;
            }
            if (complexOutputElement == null) continue;
            complexOutputId = Id;
        }
        Element requestInputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input").item(0);
        Element requestOutputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output").item(0);
        Element requestIdElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0);
        requestIdElement.setTextContent(ECHO_PROCESS_ID);
        requestInputElement.setAttribute("id", literalInputId);
        requestOutputElement.setAttribute("id", literalOutputId);
        String resultLiteral = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, SEPDocument);
        String msgLiteral = "Echo Process LiteralData Test Failed";
        Assert.assertTrue((boolean)resultLiteral.contains("hello_literal"), (String)msgLiteral);
        URI uriComplexLiteralRequestTemplate = BasicTests.class.getResource(this.COMPLEX_REQUEST_TEMPLATE_PATH).toURI();
        SEPDocument = URIUtils.parseURI(uriComplexLiteralRequestTemplate);
        requestInputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input").item(0);
        requestOutputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output").item(0);
        requestIdElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0);
        requestIdElement.setTextContent(ECHO_PROCESS_ID);
        requestInputElement.setAttribute("id", complexInputId);
        requestOutputElement.setAttribute("id", complexOutputId);
        BasicTests.prettyPrint(SEPDocument);
        String responseComplex = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, SEPDocument);
        Document complexOutputDocument = BasicTests.TransformXMLStringToXMLDocument(responseComplex);
        String resultComplex = complexOutputDocument.getElementsByTagName("testElement").item(0).getTextContent();
        String msgComplex = "Echo Process ComplexData Test Failed";
        Assert.assertTrue((boolean)resultComplex.equals("hello_complex"), (String)msgComplex);
    }

    @Test(enabled=true, dependsOnMethods={}, groups={"A.5. Basic Tests"}, description="A.5.1. Verify that the correctly handles the service name parameter.")
    private void ValidServiceName() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        LinkedHashMap<String, Object> GC_TParameters = new LinkedHashMap<String, Object>();
        GC_TParameters.put("Service", "WPS");
        GC_TParameters.put("Version", "2.0.0");
        GC_TParameters.put("Request", "GetCapabilities");
        LinkedHashMap<String, Object> GC_FParameters = new LinkedHashMap<String, Object>();
        GC_FParameters.put("Service", "WMS");
        GC_FParameters.put("Version", "2.0.0");
        GC_FParameters.put("Request", "GetCapabilities");
        Boolean GC_Flag = null;
        if (BasicTests.IsValidHTTP(SERVICE_URL, GC_TParameters).booleanValue() && !BasicTests.IsValidHTTP(SERVICE_URL, GC_FParameters).booleanValue()) {
            GC_Flag = true;
            String msg = "Valid Service Name for WPS 2.0";
            Assert.assertTrue((boolean)GC_Flag, (String)msg);
        } else {
            GC_Flag = false;
            String msg = "Invalid Service Name for WPS 2.0";
            Assert.assertTrue((boolean)GC_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.2. Verify that the correctly handles the service version parameter.")
    private void ValidServiceVersion() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        LinkedHashMap<String, Object> GC_TParameters = new LinkedHashMap<String, Object>();
        GC_TParameters.put("Service", "WPS");
        GC_TParameters.put("Version", "2.0.0");
        GC_TParameters.put("Request", "GetCapabilities");
        LinkedHashMap<String, Object> GC_FParameters = new LinkedHashMap<String, Object>();
        GC_FParameters.put("Service", "WPS");
        GC_FParameters.put("Version", "3.0.0");
        GC_FParameters.put("Request", "GetCapabilities");
        Boolean GC_Flag = null;
        if (BasicTests.IsValidHTTP(SERVICE_URL, GC_TParameters).booleanValue() && !BasicTests.IsValidHTTP(SERVICE_URL, GC_FParameters).booleanValue()) {
            GC_Flag = true;
            String msg = "Valid Service Version for WPS 2.0";
            Assert.assertTrue((boolean)GC_Flag, (String)msg);
        } else {
            GC_Flag = false;
            String msg = "Invalid Service Version for WPS 2.0";
            Assert.assertTrue((boolean)GC_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.3. Verify that the server correctly handles input data transmission by value.")
    private void ValidInputDataTranmissionByValue() throws IOException, URISyntaxException, SAXException {
        boolean IVRD_Flag;
        URI URIInputValueTemplate;
        Document InputValueDocument;
        String SERVICE_URL = this.ServiceUrl.toString();
        String InputValueResponse = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, InputValueDocument = URIUtils.parseURI(URIInputValueTemplate = BasicTests.class.getResource(this.INPUT_VALUE_TRANSMISSION_TEMPLATE_PATH).toURI()));
        Document InputValueResponseDocument = BasicTests.TransformXMLStringToXMLDocument(InputValueResponse);
        NodeList IVRD_List = InputValueResponseDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Data");
        boolean bl = IVRD_Flag = IVRD_List.getLength() > 0;
        if (IVRD_Flag) {
            String msg = "Valid Input Data Transmission by Value for WPS 2.0";
            Assert.assertTrue((boolean)IVRD_Flag, (String)msg);
        } else {
            String msg = "Invalid Input Data Transmission by Value for WPS 2.0";
            Assert.assertTrue((boolean)IVRD_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.4. Verify that the server correctly handles input data transmission by reference.")
    private void ValidInputDataTranmissionByReference() throws IOException, URISyntaxException, SAXException {
        boolean IRRD_Flag;
        URI URIInputReferenceTemplate;
        Document InputReferenceDocument;
        String SERVICE_URL = this.ServiceUrl.toString();
        String InputReferenceResponse = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, InputReferenceDocument = URIUtils.parseURI(URIInputReferenceTemplate = BasicTests.class.getResource(this.INPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH).toURI()));
        Document InputReferenceResponseDocument = BasicTests.TransformXMLStringToXMLDocument(InputReferenceResponse);
        NodeList IRRD_List = InputReferenceResponseDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Result");
        boolean bl = IRRD_Flag = IRRD_List.getLength() > 0;
        if (IRRD_Flag) {
            String msg = "Valid Input Data Transmission by Reference for WPS 2.0";
            Assert.assertTrue((boolean)IRRD_Flag, (String)msg);
        } else {
            String msg = "Invalid Input Data Transmission by Reference for WPS 2.0";
            Assert.assertTrue((boolean)IRRD_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.5. Verify that the server correctly handles output data transmission by value.")
    private void ValidOutDataTranmissionByValue() throws IOException, URISyntaxException, SAXException {
        boolean OVRD_Flag;
        URI URIOutputValueTemplate;
        Document OutputValueDocument;
        String SERVICE_URL = this.ServiceUrl.toString();
        String OutputValueResponse = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, OutputValueDocument = URIUtils.parseURI(URIOutputValueTemplate = BasicTests.class.getResource(this.OUTPUT_VALUE_TRANSMISSION_TEMPLATE_PATH).toURI()));
        Document OutputValueResponseDocument = BasicTests.TransformXMLStringToXMLDocument(OutputValueResponse);
        NodeList OVRD_List = OutputValueResponseDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Data");
        boolean bl = OVRD_Flag = OVRD_List.getLength() > 0;
        if (OVRD_Flag) {
            String msg = "Valid Output Data Transmission by Value for WPS 2.0";
            Assert.assertTrue((boolean)OVRD_Flag, (String)msg);
        } else {
            String msg = "Invalid Output Data Transmission by Value for WPS 2.0";
            Assert.assertTrue((boolean)OVRD_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.6. Verify that the server correctly handles output data transmission by reference.")
    private void ValidOutDataTranmissionByReference() throws IOException, URISyntaxException, SAXException {
        boolean ORRD_Flag;
        URI URIOutputReferenceTemplate;
        Document OutputReferenceDocument;
        String SERVICE_URL = this.ServiceUrl.toString();
        String OutputReferenceResponse = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, OutputReferenceDocument = URIUtils.parseURI(URIOutputReferenceTemplate = BasicTests.class.getResource(this.OUTPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH).toURI()));
        Document OutputReferenceResponseDocument = BasicTests.TransformXMLStringToXMLDocument(OutputReferenceResponse);
        NodeList ORRD_List = OutputReferenceResponseDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Reference");
        boolean bl = ORRD_Flag = ORRD_List.getLength() > 0;
        if (ORRD_Flag) {
            String msg = "Valid Output Data Transmission by Reference for WPS 2.0";
            Assert.assertTrue((boolean)ORRD_Flag, (String)msg);
        } else {
            String msg = "Invalid Output Data Transmission by Reference for WPS 2.0";
            Assert.assertTrue((boolean)ORRD_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.7. Verify that each process the server offers has a unique identifier.")
    private void ValidUniqueIdentifier() {
        String SERVICE_URL = this.ServiceUrl.toString();
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", "ALL");
        String DPXmlString = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Document DPDocument = BasicTests.TransformXMLStringToXMLDocument(DPXmlString);
        NodeList DPList = DPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Process");
        Boolean UI_Flag = true;
        HashSet<String> PNameList = new HashSet<String>();
        for (int i = 0; i < DPList.getLength(); ++i) {
            Element PDocument = (Element)DPList.item(i);
            String PName = PDocument.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (PNameList.add(PName)) continue;
            UI_Flag = false;
            break;
        }
        if (UI_Flag.booleanValue()) {
            String msg = "Valid Unique Identifier for WPS 2.0";
            Assert.assertTrue((boolean)UI_Flag, (String)msg);
        } else {
            String msg = "Invalid Unique Identifier for WPS 2.0";
            Assert.assertTrue((boolean)UI_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.8. Verify that the server creates a unique jobID for each job.")
    private void ValidUniqueJobIdentifier() throws URISyntaxException, SAXException, IOException {
        String SERVICE_URL = this.ServiceUrl.toString();
        Boolean UJRD_Flag = true;
        HashSet<String> JNameList = new HashSet<String>();
        Random rand = new Random();
        int value = rand.nextInt(10);
        for (int i = 0; i < value; ++i) {
            URI URIUniqueJobIdsTemplate = BasicTests.class.getResource(this.UNIQUE_JOB_IDS_TEMPLATE_PATH).toURI();
            Document UniqueJobIdsDocument = URIUtils.parseURI(URIUniqueJobIdsTemplate);
            String UniqueJobIdsResponse = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, UniqueJobIdsDocument);
            Document UniqueJobIdsResponseDocument = BasicTests.TransformXMLStringToXMLDocument(UniqueJobIdsResponse);
            String JName = UniqueJobIdsResponseDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0).getTextContent();
            if (JNameList.add(JName)) continue;
            UJRD_Flag = false;
            break;
        }
        if (UJRD_Flag.booleanValue()) {
            String msg = "Valid Unique Job Ids for WPS 2.0";
            Assert.assertTrue((boolean)UJRD_Flag, (String)msg);
        } else {
            String msg = "Invalid Unique Job Ids for WPS 2.0";
            Assert.assertTrue((boolean)UJRD_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.9. Verify that the server can handle GetCapabilities requests via POST/XML.")
    public void ValidGetCapabilitiesViaPOSTXML() throws IOException, URISyntaxException, SAXException {
        URI uriGetCapabilitiesRequestTemplate;
        Document GCDocument;
        String SERVICE_URL = this.ServiceUrl.toString();
        String GCRXmlString = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, GCDocument = URIUtils.parseURI(uriGetCapabilitiesRequestTemplate = BasicTests.class.getResource(this.GET_CAPABILITIES_REQUEST_TEMPLATE_PATH).toURI()));
        Document GCRDocument = BasicTests.TransformXMLStringToXMLDocument(GCRXmlString);
        Boolean GCP_Flag = GCRDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Capabilities").getLength() > 0;
        if (GCP_Flag.booleanValue()) {
            String msg = "Valid GetCapabilities via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)GCP_Flag, (String)msg);
        } else {
            String msg = "Invalid GetCapabilities via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)GCP_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.10. Verify that the server can handle DescribeProcess requests via POST/XML.")
    public void ValidDescribeProcessViaPOSTXML() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriDescribeProcessRequestTemplate = BasicTests.class.getResource(this.DESCRIBE_PROCESS_REQUEST_TEMPLATE_PATH).toURI();
        Document DPDocument = URIUtils.parseURI(uriDescribeProcessRequestTemplate);
        DPDocument.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).setTextContent(this.EchoProcessId);
        String DPRXmlString = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, DPDocument);
        Document DPRDocument = BasicTests.TransformXMLStringToXMLDocument(DPRXmlString);
        Boolean DPP_Flag = DPRDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ProcessOfferings").getLength() > 0;
        if (DPP_Flag.booleanValue()) {
            String msg = "Valid DescribeProcess via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)DPP_Flag, (String)msg);
        } else {
            String msg = "Invalid DescribeProcess via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)DPP_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.11. Verify that the server can handle the execution mode 'synchronous' requested via POST/XML.")
    public void ValidSyncExcecuteViaPOSTXML() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(this.LITERAL_REQUEST_TEMPLATE_PATH).toURI();
        Document literalDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        this.ProcessEchoProcessLiteralDataRequest(SERVICE_URL, literalDocument);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "sync");
        executeElement.setAttribute("response", "document");
        String respDocResult = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document respDocResultDocument = BasicTests.TransformXMLStringToXMLDocument(respDocResult);
        boolean respDocFlag = respDocResultDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Result").getLength() > 0;
        String msg = "Invalid SyncExecute via POST/XML for WPS 2.0";
        Assert.assertTrue((boolean)respDocFlag, (String)msg);
        executeElement.setAttribute("response", "raw");
        String respRawResult = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        boolean VSE_Flag = respRawResult.contains("hello_literal");
        if (VSE_Flag) {
            String msg1 = "Valid SyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)VSE_Flag, (String)msg1);
        } else {
            String msg1 = "Invalid SyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)VSE_Flag, (String)msg1);
        }
    }

    public void ProcessEchoProcessLiteralDataRequest(String SERVICE_URL, Document SEPDocument) {
        String ECHO_PROCESS_ID = this.EchoProcessId;
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", ECHO_PROCESS_ID);
        String responseDescribeProcess = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Document responseDescribeProcessDocument = BasicTests.TransformXMLStringToXMLDocument(responseDescribeProcess);
        NodeList inputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input");
        String literalInputId = "";
        String literalOutputId = "";
        String complexInputId = "";
        String complexOutputId = "";
        for (int i = 0; i < inputList.getLength(); ++i) {
            Element element = (Element)inputList.item(i);
            Element literalInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element complexInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalInputElement != null) {
                literalInputId = Id;
                continue;
            }
            if (complexInputElement == null) continue;
            complexInputId = Id;
        }
        NodeList outputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output");
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element element = (Element)outputList.item(i);
            Element literalOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element complexOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalOutputElement != null) {
                literalOutputId = Id;
                continue;
            }
            if (complexOutputElement == null) continue;
            complexOutputId = Id;
        }
        Element requestInputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input").item(0);
        Element requestOutputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output").item(0);
        Element requestIdElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0);
        requestIdElement.setTextContent(ECHO_PROCESS_ID);
        requestInputElement.setAttribute("id", literalInputId);
        requestOutputElement.setAttribute("id", literalOutputId);
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.12. Verify that the server can handle the execution mode 'asynchronous' requested via POST/XML.")
    public void ValidAsyncExcecuteViaPOSTXML() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(this.LITERAL_REQUEST_TEMPLATE_PATH).toURI();
        Document literalDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        this.ProcessEchoProcessLiteralDataRequest(SERVICE_URL, literalDocument);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "async");
        executeElement.setAttribute("response", "document");
        String VAEXmlString = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document VAEDocument = BasicTests.TransformXMLStringToXMLDocument(VAEXmlString);
        Boolean VAE_Flag = VAEDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Status").getLength() > 0;
        if (VAE_Flag.booleanValue()) {
            String msg = "Valid AsyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)VAE_Flag, (String)msg);
        } else {
            String msg = "Invalid AsyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)VAE_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.13. Verify that the server can handle the execution mode 'auto' requested via POST/XML.")
    public void ValidAutoExcecuteViaPOSTXML() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(this.LITERAL_REQUEST_TEMPLATE_PATH).toURI();
        Document literalDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        this.ProcessEchoProcessLiteralDataRequest(SERVICE_URL, literalDocument);
        String ECHO_PROCESS_ID = this.EchoProcessId;
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", ECHO_PROCESS_ID);
        String responseDescribeProcess = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Document responseDescribeProcessDocument = BasicTests.TransformXMLStringToXMLDocument(responseDescribeProcess);
        Element ProcessOfferingElement = (Element)responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ProcessOffering").item(0);
        String outputTransmission = ProcessOfferingElement.getAttribute("outputTransmission");
        String jobControlOptions = ProcessOfferingElement.getAttribute("jobControlOptions");
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        if (outputTransmission.contains("reference")) {
            executeElement.setAttribute("response", "document");
            if (jobControlOptions.contains("sync-execute")) {
                executeElement.setAttribute("mode", "sync");
                this.TestPostWithDocumentAndAssertMessage(SERVICE_URL, literalDocument, "Invalid SyncExecute via POST/XML for WPS 2.0");
            }
            if (jobControlOptions.contains("async-execute")) {
                executeElement.setAttribute("mode", "async");
                this.TestPostWithDocumentAndAssertMessage(SERVICE_URL, literalDocument, "Invalid AsyncExecute via POST/XML for WPS 2.0");
            }
        }
        if (outputTransmission.contains("value")) {
            executeElement.setAttribute("response", "raw");
            if (jobControlOptions.contains("sync-execute")) {
                executeElement.setAttribute("mode", "sync");
                String respRawResult = BasicTests.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
                boolean respRawFlag = respRawResult.contains("hello_literal");
                Assert.assertTrue((boolean)respRawFlag, (String)"Invalid SyncExecute via POST/XML for WPS 2.0");
            }
            if (jobControlOptions.contains("async-execute")) {
                executeElement.setAttribute("mode", "async");
                this.TestPostWithDocumentAndAssertMessage(SERVICE_URL, literalDocument, "Invalid AsyncExecute via POST/XML for WPS 2.0");
            }
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.16. Verify that the server can handle GetCapabilities requests via GET/KVP.")
    private void ValidGetCapabilitiesViaGETKVP() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        LinkedHashMap<String, Object> GCU_Parameters = new LinkedHashMap<String, Object>();
        GCU_Parameters.put("Service".toUpperCase(), "WPS");
        GCU_Parameters.put("Version".toUpperCase(), "2.0.0");
        GCU_Parameters.put("Request".toUpperCase(), "GetCapabilities");
        String GCU_XmlString = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, GCU_Parameters);
        Document GCU_Document = BasicTests.TransformXMLStringToXMLDocument(GCU_XmlString);
        LinkedHashMap<String, Object> GCL_Parameters = new LinkedHashMap<String, Object>();
        GCL_Parameters.put("Service".toLowerCase(), "WPS");
        GCL_Parameters.put("Version".toLowerCase(), "2.0.0");
        GCL_Parameters.put("Request".toLowerCase(), "GetCapabilities");
        String GCL_XmlString = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, GCL_Parameters);
        Document GCL_Document = BasicTests.TransformXMLStringToXMLDocument(GCL_XmlString);
        Boolean GC_KVP_Flag = GCU_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Capabilities").getLength() > 0 && GCL_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Capabilities").getLength() > 0;
        if (GC_KVP_Flag.booleanValue()) {
            String msg = "Valid GetCapabilities via KVP for WPS 2.0";
            Assert.assertTrue((boolean)GC_KVP_Flag, (String)msg);
        } else {
            String msg = "Invalid GetCapabilities via KVP for WPS 2.0";
            Assert.assertTrue((boolean)GC_KVP_Flag, (String)msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.17. Verify that the server can handle DescribeProcess requests via GET/KVP.")
    private void ValidDescribeProcessViaGETKVP() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        LinkedHashMap<String, Object> GC_Parameters = new LinkedHashMap<String, Object>();
        GC_Parameters.put("Service", "WPS");
        GC_Parameters.put("Version", "2.0.0");
        GC_Parameters.put("Request", "GetCapabilities");
        String GC_XmlString = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, GC_Parameters);
        Document GC_Document = BasicTests.TransformXMLStringToXMLDocument(GC_XmlString);
        String IdentifierName = GC_Document.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
        LinkedHashMap<String, Object> DPU_Parameters = new LinkedHashMap<String, Object>();
        DPU_Parameters.put("Service".toUpperCase(), "WPS");
        DPU_Parameters.put("Version".toUpperCase(), "2.0.0");
        DPU_Parameters.put("Request".toUpperCase(), "DescribeProcess");
        DPU_Parameters.put("Identifier".toUpperCase(), IdentifierName);
        String DPU_XmlString = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DPU_Parameters);
        Document DPU_Document = BasicTests.TransformXMLStringToXMLDocument(DPU_XmlString);
        LinkedHashMap<String, Object> DPL_Parameters = new LinkedHashMap<String, Object>();
        DPL_Parameters.put("Service".toLowerCase(), "WPS");
        DPL_Parameters.put("Version".toLowerCase(), "2.0.0");
        DPL_Parameters.put("Request".toLowerCase(), "DescribeProcess");
        DPL_Parameters.put("Identifier".toLowerCase(), IdentifierName);
        String DPL_XmlString = BasicTests.GetContentFromGETKVPRequest(SERVICE_URL, DPL_Parameters);
        Document DPL_Document = BasicTests.TransformXMLStringToXMLDocument(DPL_XmlString);
        Boolean DP_KVP_Flag = DPU_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ProcessOfferings").getLength() > 0 && DPL_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ProcessOfferings").getLength() > 0;
        if (DP_KVP_Flag.booleanValue()) {
            String msg = "Valid DescribeProcess via KVP for WPS 2.0";
            Assert.assertTrue((boolean)DP_KVP_Flag, (String)msg);
        } else {
            String msg = "Invalid DescribeProcess via KVP for WPS 2.0";
            Assert.assertTrue((boolean)DP_KVP_Flag, (String)msg);
        }
    }

    public void TestPostWithDocumentAndAssertMessage(String SERVICE_URL, Document literalDocument, String message) throws Exception {
        HttpURLConnection conn = this.GetConnection(SERVICE_URL);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/xml");
        conn.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
        String xml = BasicTests.TransformXMLDocumentToXMLString(literalDocument);
        outputStream.writeBytes(xml);
        outputStream.flush();
        outputStream.close();
        int responseCode = conn.getResponseCode();
        boolean respDocFlag = responseCode == 200;
        Assert.assertTrue((boolean)respDocFlag, (String)message);
    }

    private static boolean isXMLSchemaValid(String xmlString, String xsdPath) {
        try {
            Schema schema = ValidationUtils.createSchema(xsdPath);
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xmlString)));
        }
        catch (IOException | SAXException e) {
            System.out.println("Exception: " + e.getMessage());
            return false;
        }
        return true;
    }

    private static Document TransformXMLStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Document TransformXMLFileToXMLDocument(String URI2) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(URI2));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String TransformXMLDocumentToXMLString(Document xmlDoc) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        StringWriter out = new StringWriter();
        tf.transform(new DOMSource(xmlDoc), new StreamResult(out));
        return ((Object)out).toString();
    }

    private static void prettyPrint(Document xmlDoc) throws Exception {
        String str = BasicTests.TransformXMLDocumentToXMLString(xmlDoc);
        System.out.println(str);
    }

    private static Boolean IsValidHTTP(String any_url, Map<String, Object> params) throws IOException {
        StringBuilder Data = new StringBuilder();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (Data.length() != 0) {
                Data.append('&');
            }
            Data.append(URLEncoder.encode(param.getKey(), "UTF-8"));
            Data.append('=');
            Data.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        URL url = new URL(any_url + "?" + Data.toString());
        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
        huc.setRequestMethod("GET");
        int responseCode = huc.getResponseCode();
        return responseCode == 200;
    }

    private static String GetContentFromGETKVPRequest(String any_url, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConn = null;
        InputStreamReader in = null;
        try {
            BufferedReader bufferedReader;
            StringBuilder Data = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (Data.length() != 0) {
                    Data.append('&');
                }
                Data.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                Data.append('=');
                Data.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            URL url = new URL(any_url + "?" + Data.toString());
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("GET");
            urlConn.setDoOutput(true);
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null && (bufferedReader = new BufferedReader(in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset()))) != null) {
                int cp;
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while calling URL:" + any_url, e);
        }
        return sb.toString();
    }

    private static String GetContentFromPOSTXMLRequest(String any_url, Document xml_doc) {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConn = null;
        InputStreamReader in = null;
        try {
            BufferedReader bufferedReader;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(xml_doc), new StreamResult(out));
            byte[] postDataBytes = ((Object)out).toString().getBytes("UTF-8");
            URL url = new URL(any_url);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/xml");
            urlConn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            urlConn.setDoOutput(true);
            urlConn.getOutputStream().write(postDataBytes);
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null && (bufferedReader = new BufferedReader(in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset()))) != null) {
                int cp;
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while calling URL:" + any_url, e);
        }
        return sb.toString();
    }

    private HttpURLConnection GetConnection(String serviceURL) throws IOException {
        URL urlObj = new URL(serviceURL);
        return (HttpURLConnection)urlObj.openConnection();
    }
}

