/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opengis.cite.wps20.SuiteAttribute;
import org.opengis.cite.wps20.util.ClientUtils;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CommonFixture {
    public static final String ROOT_PKG_PATH = "/org/opengis/cite/wps20/";
    protected Client client;
    protected ClientRequest request;
    protected ClientResponse response;
    protected URI ServiceUrl;
    protected String EchoProcessId;

    @BeforeClass
    public void initCommonFixture(ITestContext testContext) {
        Object EchoProcessIdObj;
        Object ServiceUrlObj;
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.CLIENT.getName());
        if (null != obj) {
            this.client = (Client)Client.class.cast(obj);
        }
        if (null != (ServiceUrlObj = testContext.getSuite().getAttribute(SuiteAttribute.SERVICE_URL.getName()))) {
            this.ServiceUrl = (URI)URI.class.cast(ServiceUrlObj);
            System.out.println("WPS 2.0 SERVICE URL: " + this.ServiceUrl.toString());
        }
        if (null != (EchoProcessIdObj = testContext.getSuite().getAttribute(SuiteAttribute.ECHO_PROCESS_ID.getName()))) {
            this.EchoProcessId = (String)String.class.cast(EchoProcessIdObj);
            System.out.println("WPS 2.0 ECHO PROCESS ID: " + this.EchoProcessId.toString());
        }
    }

    @BeforeMethod
    public void clearMessages() {
        this.request = null;
        this.response = null;
    }

    public Document getResponseEntityAsDocument(ClientResponse response, String targetURI) {
        return ClientUtils.getResponseEntityAsDocument(response, targetURI);
    }

    public ClientRequest buildGetRequest(URI endpoint, Map<String, String> qryParams, MediaType ... mediaTypes) {
        return ClientUtils.buildGetRequest(endpoint, qryParams, mediaTypes);
    }

    public String GetContentFromPOSTXMLRequest(String any_url, Document xml_doc) {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConn = null;
        InputStreamReader in = null;
        try {
            BufferedReader bufferedReader;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(xml_doc), new StreamResult(out));
            byte[] postDataBytes = ((Object)out).toString().getBytes("UTF-8");
            URL url = new URL(any_url);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/xml");
            urlConn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            urlConn.setDoOutput(true);
            urlConn.getOutputStream().write(postDataBytes);
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null && (bufferedReader = new BufferedReader(in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset()))) != null) {
                int cp;
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while calling URL:" + any_url, e);
        }
        return sb.toString();
    }

    public Document TransformXMLStringToXMLDocument(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String GetContentFromGETKVPRequest(String any_url, Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConn = null;
        InputStreamReader in = null;
        try {
            BufferedReader bufferedReader;
            StringBuilder Data2 = new StringBuilder();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (Data2.length() != 0) {
                    Data2.append('&');
                }
                Data2.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                Data2.append('=');
                Data2.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            URL url = new URL(any_url + "?" + Data2.toString());
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("GET");
            urlConn.setDoOutput(true);
            if (urlConn != null) {
                urlConn.setReadTimeout(60000);
            }
            if (urlConn != null && urlConn.getInputStream() != null && (bufferedReader = new BufferedReader(in = new InputStreamReader(urlConn.getInputStream(), Charset.defaultCharset()))) != null) {
                int cp;
                while ((cp = bufferedReader.read()) != -1) {
                    sb.append((char)cp);
                }
                bufferedReader.close();
            }
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while calling URL:" + any_url, e);
        }
        return sb.toString();
    }

    public Document TransformXMLFileToXMLDocument(String URI2) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(URI2));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String TransformXMLDocumentToXMLString(Document xmlDoc) throws Exception {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        StringWriter out = new StringWriter();
        tf.transform(new DOMSource(xmlDoc), new StreamResult(out));
        return ((Object)out).toString();
    }

    public void prettyPrint(Document xmlDoc) throws Exception {
        String str = this.TransformXMLDocumentToXMLString(xmlDoc);
        System.out.println(str);
    }

    public HttpURLConnection GetConnection(String serviceURL) throws IOException {
        URL urlObj = new URL(serviceURL);
        return (HttpURLConnection)urlObj.openConnection();
    }
}

