/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20.synchronous;

import java.net.URI;
import java.util.LinkedHashMap;
import org.opengis.cite.wps20.CommonFixture;
import org.opengis.cite.wps20.basictests.BasicTests;
import org.opengis.cite.wps20.util.URIUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SyncTests
extends CommonFixture {
    String GET_CAPABILITIES_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/GetCapabilities.xml";
    String DESCRIBE_PROCESS_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/DescribeProcess.xml";
    String LITERAL_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/Echo_Process_Literal.xml";
    String COMPLEX_REQUEST_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/Echo_Process_Complex.xml";
    String INPUT_VALUE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidInputValue.xml";
    String INPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidInputReference.xml";
    String OUTPUT_VALUE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidOutputValue.xml";
    String OUTPUT_REFERENCE_TRANSMISSION_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidOutputReference.xml";
    String UNIQUE_JOB_IDS_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidUniqueJobIds.xml";
    String GET_STATUS_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidGetStatus.xml";
    String GET_RESULT_TEMPLATE_PATH = "/org/opengis/cite/wps20/examples/ValidGetResult.xml";

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.11. Verify that the server can handle the execution mode 'synchronous' requested via POST/XML.")
    public void ValidSyncExcecuteViaPOSTXML() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        URI uriLiteralRequestTemplate = BasicTests.class.getResource(this.LITERAL_REQUEST_TEMPLATE_PATH).toURI();
        Document literalDocument = URIUtils.parseURI(uriLiteralRequestTemplate);
        this.ProcessEchoProcessLiteralDataRequest(SERVICE_URL, literalDocument);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "sync");
        executeElement.setAttribute("response", "document");
        String respDocResult = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document respDocResultDocument = this.TransformXMLStringToXMLDocument(respDocResult);
        boolean respDocFlag = respDocResultDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Result").getLength() > 0;
        String msg = "Invalid SyncExecute via POST/XML for WPS 2.0";
        Assert.assertTrue((boolean)respDocFlag, (String)msg);
        executeElement.setAttribute("response", "raw");
        String respRawResult = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        boolean VSE_Flag = respRawResult.contains("hello_literal");
        if (VSE_Flag) {
            String msg1 = "Valid SyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)VSE_Flag, (String)msg1);
        } else {
            String msg1 = "Invalid SyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue((boolean)VSE_Flag, (String)msg1);
        }
    }

    public void ProcessEchoProcessLiteralDataRequest(String SERVICE_URL, Document SEPDocument) {
        String ECHO_PROCESS_ID = this.EchoProcessId;
        LinkedHashMap<String, Object> DP_Parameters = new LinkedHashMap<String, Object>();
        DP_Parameters.put("Service", "WPS");
        DP_Parameters.put("Version", "2.0.0");
        DP_Parameters.put("Request", "DescribeProcess");
        DP_Parameters.put("Identifier", ECHO_PROCESS_ID);
        String responseDescribeProcess = this.GetContentFromGETKVPRequest(SERVICE_URL, DP_Parameters);
        Document responseDescribeProcessDocument = this.TransformXMLStringToXMLDocument(responseDescribeProcess);
        NodeList inputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input");
        String literalInputId = "";
        String literalOutputId = "";
        String complexInputId = "";
        String complexOutputId = "";
        for (int i = 0; i < inputList.getLength(); ++i) {
            Element element = (Element)inputList.item(i);
            Element literalInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element complexInputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalInputElement != null) {
                literalInputId = Id;
                continue;
            }
            if (complexInputElement == null) continue;
            complexInputId = Id;
        }
        NodeList outputList = responseDescribeProcessDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output");
        for (int i = 0; i < outputList.getLength(); ++i) {
            Element element = (Element)outputList.item(i);
            Element literalOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralData").item(0);
            Element complexOutputElement = (Element)element.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "ComplexData").item(0);
            String Id = element.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0).getTextContent();
            if (literalOutputElement != null) {
                literalOutputId = Id;
                continue;
            }
            if (complexOutputElement == null) continue;
            complexOutputId = Id;
        }
        Element requestInputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Input").item(0);
        Element requestOutputElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Output").item(0);
        Element requestIdElement = (Element)SEPDocument.getElementsByTagNameNS("http://www.opengis.net/ows/2.0", "Identifier").item(0);
        requestIdElement.setTextContent(ECHO_PROCESS_ID);
        requestInputElement.setAttribute("id", literalInputId);
        requestOutputElement.setAttribute("id", literalOutputId);
    }
}

