/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root, Mode irrelevant) {
        this.checkType(root, JA.PrefixMapping);
        return PrefixMappingAssembler.getPrefixes(a, root, PrefixMapping.Factory.create());
    }

    public static PrefixMapping getPrefixes(Assembler a, Resource root, PrefixMapping result) {
        PrefixMappingAssembler.setSimplePrefixes(root, result);
        PrefixMappingAssembler.includePrefixesFor(a, root, result, JA.includes);
        PrefixMappingAssembler.includePrefixesFor(a, root, result, JA.prefixMapping);
        return result;
    }

    private static void includePrefixesFor(Assembler a, Resource root, PrefixMapping result, Property includeUsing) {
        StmtIterator it = root.listProperties(includeUsing);
        while (it.hasNext()) {
            Statement s2 = it.nextStatement();
            PrefixMapping sub = (PrefixMapping)a.open(PrefixMappingAssembler.getResource(s2));
            result.setNsPrefixes(sub);
        }
    }

    private static void setSimplePrefixes(Resource root, PrefixMapping result) {
        if (root.hasProperty(JA.prefix)) {
            Literal prefix = PrefixMappingAssembler.getUniqueLiteral(root, JA.prefix);
            Literal namespace = PrefixMappingAssembler.getUniqueLiteral(root, JA.namespace);
            result.setNsPrefix(prefix.getLexicalForm(), namespace.getLexicalForm());
        }
    }
}

