/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20.asynchronous;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import org.opengis.cite.wps20.CommonFixture;
import org.opengis.cite.wps20.basictests.BasicTests;
import org.opengis.cite.wps20.util.URIUtils;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AsyncTests
extends CommonFixture {
    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.14. Verify that the server can handle GetStatus requests via POST/XML.")
    public void ValidGetStatusViaPOSTXML() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        Document literalDocument = this.GetDocumentTemplate(this.LITERAL_REQUEST_TEMPLATE_PATH, this.EchoProcessId, this.LITERAL_INPUT_ID, this.LITERAL_OUTPUT_ID);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "async");
        executeElement.setAttribute("response", "document");
        String VAEXmlString = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document VAEDocument = this.TransformXMLStringToXMLDocument(VAEXmlString);
        Boolean VAE_Flag = VAEDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "StatusInfo").getLength() > 0;
        if (VAE_Flag.booleanValue()) {
            Element JobIDElement1 = (Element)VAEDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            URI URIGetStatusTemplate = BasicTests.class.getResource(this.GET_STATUS_TEMPLATE_PATH).toURI();
            Document GetStatusDocument = URIUtils.parseURI(URIGetStatusTemplate);
            Element JobIDElement2 = (Element)GetStatusDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            JobIDElement2.setTextContent(JobIDElement1.getTextContent());
            String VGSXmlString = this.GetContentFromPOSTXMLRequest(SERVICE_URL, GetStatusDocument);
            Document VGSDocument = this.TransformXMLStringToXMLDocument(VGSXmlString);
            Boolean VGS_Flag = VGSDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Status").getLength() > 0;
            if (VGS_Flag.booleanValue()) {
                String msg = "Valid GetStatus via POST/XML for WPS 2.0";
                Assert.assertTrue(VGS_Flag, msg);
            } else {
                String msg = "Invalid GetStatus via POST/XML for WPS 2.0";
                Assert.assertTrue(VGS_Flag, msg);
            }
        } else {
            String msg = "Invalid Execute via POST/XML for WPS 2.0";
            Assert.assertTrue(VAE_Flag, msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.15. Verify that the server can handle GetResult requests via POST/XML.")
    public void ValidGetResultViaPOSTXML() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        Document literalDocument = this.GetDocumentTemplate(this.LITERAL_REQUEST_TEMPLATE_PATH, this.EchoProcessId, this.LITERAL_INPUT_ID, this.LITERAL_OUTPUT_ID);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "async");
        executeElement.setAttribute("response", "raw");
        String VAEXmlString1 = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document VAEDocument1 = this.TransformXMLStringToXMLDocument(VAEXmlString1);
        Boolean VAE_Flag1 = VAEDocument1.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "StatusInfo").getLength() > 0;
        executeElement.setAttribute("response", "document");
        String VAEXmlString2 = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document VAEDocument2 = this.TransformXMLStringToXMLDocument(VAEXmlString2);
        Boolean VAE_Flag2 = VAEDocument2.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "StatusInfo").getLength() > 0;
        Boolean VAE_Flag = VAE_Flag1 != false && VAE_Flag2 != false;
        if (VAE_Flag.booleanValue()) {
            URI URIGetResultTemplate1 = BasicTests.class.getResource(this.GET_RESULT_TEMPLATE_PATH).toURI();
            Element JobIDElement1 = (Element)VAEDocument1.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            Document GetResultDocument1 = URIUtils.parseURI(URIGetResultTemplate1);
            Element JobIDElement2 = (Element)GetResultDocument1.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            JobIDElement2.setTextContent(JobIDElement1.getTextContent());
            String VGRXmlString1 = this.GetContentFromPOSTXMLRequest(SERVICE_URL, GetResultDocument1);
            Document VGRDocument1 = this.TransformXMLStringToXMLDocument(VGRXmlString1);
            Boolean VGR_Flag1 = VGRDocument1.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralValue").getLength() > 0;
            URI URIGetResultTemplate2 = BasicTests.class.getResource(this.GET_RESULT_TEMPLATE_PATH).toURI();
            Element JobIDElement3 = (Element)VAEDocument2.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            Document GetResultDocument2 = URIUtils.parseURI(URIGetResultTemplate2);
            Element JobIDElement4 = (Element)GetResultDocument2.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            JobIDElement4.setTextContent(JobIDElement3.getTextContent());
            String VGRXmlString2 = this.GetContentFromPOSTXMLRequest(SERVICE_URL, GetResultDocument2);
            Boolean VGR_Flag2 = VGRXmlString2.contains("LiteralValue");
            Boolean VGR_Flag = VGR_Flag1 != false && VGR_Flag2 != false;
            if (VGR_Flag.booleanValue()) {
                String msg = "Valid GetResult via POST/XML for WPS 2.0";
                Assert.assertTrue(VGR_Flag, msg);
            } else {
                String msg = "Invalid GetResult via POST/XML for WPS 2.0";
                Assert.assertTrue(VGR_Flag, msg);
            }
        } else {
            String msg = "Invalid Execute via POST/XML for WPS 2.0";
            Assert.assertTrue(VAE_Flag, msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.18. Verify that the server can handle GetStatus requests via GET/KVP.")
    private void ValidGetStatusViaGETKVP() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        Document literalDocument = this.GetDocumentTemplate(this.LITERAL_REQUEST_TEMPLATE_PATH, this.EchoProcessId, this.LITERAL_INPUT_ID, this.LITERAL_OUTPUT_ID);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "async");
        executeElement.setAttribute("response", "document");
        String VAEXmlString = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document VAEDocument = this.TransformXMLStringToXMLDocument(VAEXmlString);
        Boolean VAE_Flag = VAEDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "StatusInfo").getLength() > 0;
        if (VAE_Flag.booleanValue()) {
            Element JobIDElement1 = (Element)VAEDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            LinkedHashMap<String, Object> GSU_Parameters = new LinkedHashMap<String, Object>();
            GSU_Parameters.put("Service".toUpperCase(), "WPS");
            GSU_Parameters.put("Version".toUpperCase(), "2.0.0");
            GSU_Parameters.put("Request".toUpperCase(), "GetStatus");
            GSU_Parameters.put("JobID".toUpperCase(), JobIDElement1.getTextContent());
            String GSU_XmlString = this.GetContentFromGETKVPRequest(SERVICE_URL, GSU_Parameters);
            Document GSU_Document = this.TransformXMLStringToXMLDocument(GSU_XmlString);
            LinkedHashMap<String, Object> GSL_Parameters = new LinkedHashMap<String, Object>();
            GSL_Parameters.put("Service".toLowerCase(), "WPS");
            GSL_Parameters.put("Version".toLowerCase(), "2.0.0");
            GSL_Parameters.put("Request".toLowerCase(), "GetStatus");
            GSL_Parameters.put("JobID".toLowerCase(), JobIDElement1.getTextContent());
            String GSL_XmlString = this.GetContentFromGETKVPRequest(SERVICE_URL, GSL_Parameters);
            Document GSL_Document = this.TransformXMLStringToXMLDocument(GSL_XmlString);
            Boolean GS_KVP_Flag = GSU_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Status").getLength() > 0 && GSL_Document.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Status").getLength() > 0;
            if (GS_KVP_Flag.booleanValue()) {
                String msg = "Valid GetStatus via GET/KVP for WPS 2.0";
                Assert.assertTrue(GS_KVP_Flag, msg);
            } else {
                String msg = "Invalid GetStatus via GET/KVP for WPS 2.0";
                Assert.assertTrue(GS_KVP_Flag, msg);
            }
        } else {
            String msg = "Invalid Execute via POST/XML for WPS 2.0";
            Assert.assertTrue(VAE_Flag, msg);
        }
    }

    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.19. Verify that the server can handle GetResult requests via GET/KVP.")
    private void ValidGetResultViaGETKVP() throws IOException, URISyntaxException, SAXException {
        String SERVICE_URL = this.ServiceUrl.toString();
        Document literalDocument = this.GetDocumentTemplate(this.LITERAL_REQUEST_TEMPLATE_PATH, this.EchoProcessId, this.LITERAL_INPUT_ID, this.LITERAL_OUTPUT_ID);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "async");
        executeElement.setAttribute("response", "document");
        String VAEXmlString1 = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document VAEDocument1 = this.TransformXMLStringToXMLDocument(VAEXmlString1);
        Boolean VAE_Flag1 = VAEDocument1.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "StatusInfo").getLength() > 0;
        executeElement.setAttribute("response", "raw");
        String VAEXmlString2 = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        System.out.println(VAEXmlString2);
        Document VAEDocument2 = this.TransformXMLStringToXMLDocument(VAEXmlString2);
        Boolean VAE_Flag2 = VAEDocument2.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "StatusInfo").getLength() > 0;
        Boolean VAE_Flag = VAE_Flag1 != false && VAE_Flag2 != false;
        if (VAE_Flag.booleanValue()) {
            Element JobIDElement1 = (Element)VAEDocument1.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            this.CheckGetStatus(SERVICE_URL, JobIDElement1.getTextContent());
            LinkedHashMap<String, Object> GR_Parameters1 = new LinkedHashMap<String, Object>();
            GR_Parameters1.put("Service", "WPS");
            GR_Parameters1.put("Version", "2.0.0");
            GR_Parameters1.put("Request", "GetResult");
            GR_Parameters1.put("JobID", JobIDElement1.getTextContent());
            String GR_XmlString1 = this.GetContentFromGETKVPRequest(SERVICE_URL, GR_Parameters1);
            Document GR_Document1 = this.TransformXMLStringToXMLDocument(GR_XmlString1);
            Boolean VGR_Flag1 = GR_Document1.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Result").getLength() > 0;
            Element JobIDElement2 = (Element)VAEDocument2.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "JobID").item(0);
            this.CheckGetStatus(SERVICE_URL, JobIDElement2.getTextContent());
            LinkedHashMap<String, Object> GR_Parameters2 = new LinkedHashMap<String, Object>();
            GR_Parameters2.put("Service", "WPS");
            GR_Parameters2.put("Version", "2.0.0");
            GR_Parameters2.put("Request", "GetResult");
            GR_Parameters2.put("JobID", JobIDElement2.getTextContent());
            String GR_XmlString2 = this.GetContentFromGETKVPRequest(SERVICE_URL, GR_Parameters2);
            Document GR_Document2 = this.TransformXMLStringToXMLDocument(GR_XmlString2);
            Boolean VGR_Flag2 = GR_Document2.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "LiteralValue").getLength() > 0;
            Boolean VGR_Flag = VGR_Flag1 != false && VGR_Flag2 != false;
            if (VGR_Flag.booleanValue()) {
                String msg = "Valid GetResult via GET/KVP for WPS 2.0";
                Assert.assertTrue(VGR_Flag, msg);
            } else {
                String msg = "Invalid GetResult via GET/KVP for WPS 2.0";
                Assert.assertTrue(VGR_Flag, msg);
            }
        } else {
            String msg = "Invalid Execute via POST/XML for WPS 2.0";
            Assert.assertTrue(VAE_Flag, msg);
        }
    }

    public void CheckGetStatus(String SERVICE_URL, String jobID) {
        LinkedHashMap<String, Object> GR_Parameters1 = new LinkedHashMap<String, Object>();
        GR_Parameters1.put("Service", "WPS");
        GR_Parameters1.put("Version", "2.0.0");
        GR_Parameters1.put("Request", "GetStatus");
        GR_Parameters1.put("JobID", jobID);
        String GR_XmlString1 = this.GetContentFromGETKVPRequest(SERVICE_URL, GR_Parameters1);
        Document docGetStatus = this.TransformXMLStringToXMLDocument(GR_XmlString1);
        Boolean statusFlag = docGetStatus.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Status").getLength() > 0;
        String msg = "Invalid GetStatus via GET/KVP for WPS 2.0";
        if (!statusFlag.booleanValue()) {
            Assert.assertTrue(false, msg);
        } else {
            Element statusElement = (Element)docGetStatus.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Status").item(0);
            String status = statusElement.getTextContent();
            if (status.toLowerCase().equals("succeeded")) {
                return;
            }
            Assert.assertTrue(false, msg);
        }
    }
}

