/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20.synchronous;

import org.opengis.cite.wps20.CommonFixture;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SyncTests
extends CommonFixture {
    @Test(enabled=true, groups={"A.5. Basic Tests"}, description="A.5.11. Verify that the server can handle the execution mode 'synchronous' requested via POST/XML.")
    public void ValidSyncExcecuteViaPOSTXML() throws Exception {
        String SERVICE_URL = this.ServiceUrl.toString();
        Document literalDocument = this.GetDocumentTemplate(this.LITERAL_REQUEST_TEMPLATE_PATH, this.EchoProcessId, this.LITERAL_INPUT_ID, this.LITERAL_OUTPUT_ID);
        Element executeElement = (Element)literalDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Execute").item(0);
        executeElement.setAttribute("mode", "sync");
        executeElement.setAttribute("response", "document");
        String respDocResult = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        Document respDocResultDocument = this.TransformXMLStringToXMLDocument(respDocResult);
        boolean respDocFlag = respDocResultDocument.getElementsByTagNameNS("http://www.opengis.net/wps/2.0", "Result").getLength() > 0;
        String msg = "Invalid SyncExecute via POST/XML for WPS 2.0";
        Assert.assertTrue(respDocFlag, msg);
        executeElement.setAttribute("response", "raw");
        String respRawResult = this.GetContentFromPOSTXMLRequest(SERVICE_URL, literalDocument);
        boolean VSE_Flag = respRawResult.contains("hello_literal");
        if (VSE_Flag) {
            String msg1 = "Valid SyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue(VSE_Flag, msg1);
        } else {
            String msg1 = "Invalid SyncExecute via POST/XML for WPS 2.0";
            Assert.assertTrue(VSE_Flag, msg1);
        }
    }
}

