/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wps20.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.wps20.util.ClientUtils;
import org.opengis.cite.wps20.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class URIUtils {
    private static final String FIXUP_BASE_URI = "http://apache.org/xml/features/xinclude/fixup-base-uris";

    public static Document parseURI(URI uriRef) throws SAXException, IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setExpandEntityReferences(false);
        docFactory.setXIncludeAware(true);
        Document doc = null;
        try {
            docFactory.setFeature(FIXUP_BASE_URI, false);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(uriRef.toString());
        }
        catch (ParserConfigurationException x) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create DocumentBuilder." + x);
        }
        if (null != doc) {
            doc.setDocumentURI(uriRef.toString());
        }
        return doc;
    }

    public static File dereferenceURI(URI uriRef) throws IOException {
        if (null == uriRef || !uriRef.isAbsolute()) {
            throw new IllegalArgumentException("Absolute URI is required, but received " + uriRef);
        }
        if (uriRef.getScheme().equalsIgnoreCase("file")) {
            return new File(uriRef);
        }
        Client client = ClientUtils.buildClient();
        WebTarget target = client.target(uriRef);
        Invocation.Builder builder = target.request();
        Response rsp = builder.buildGet().invoke();
        String suffix = null;
        if (rsp.getHeaders().getFirst((Object)"Content-Type").toString().endsWith("xml")) {
            suffix = ".xml";
        }
        File destFile = File.createTempFile("entity-", suffix);
        if (rsp.hasEntity()) {
            int bytesRead;
            Object entity = rsp.getEntity();
            if (!(entity instanceof InputStream)) {
                return null;
            }
            InputStream is = (InputStream)entity;
            FileOutputStream os = new FileOutputStream(destFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            is.close();
            os.flush();
            ((OutputStream)os).close();
        }
        TestSuiteLogger.log(Level.FINE, "Wrote " + destFile.length() + " bytes to file at " + destFile.getAbsolutePath());
        return destFile;
    }

    public static URI resolveRelativeURI(String baseURI, String uriRef) {
        URI uri;
        URI uRI = uri = null != baseURI ? URI.create(baseURI) : URI.create("");
        if (null != baseURI && null == uri.getScheme()) {
            throw new IllegalArgumentException("Base URI has no scheme component: " + baseURI);
        }
        return uri.resolve(uriRef);
    }
}

